#include "defs.h"
#include "integer.e"
#include "ring.h"
#include "mat.h"

t_void 
mat_ring_create_zero_sub WITH_2_ARGS(
	t_handle,		cring,
	matrix *,	mat
)
/* 
** Assigns all entries of unpacked matrix *mat to zero of the ring cring.
*/
{
	register t_int	j;
	register t_int	dim2;
	register t_int	*ptr_mat;
	t_int	zero;
	t_int	n;
	t_int	m;

	if (*mat == 0)
		error_internal( "matrix must be allocated in creating zero" );

	if (mat_is_packed(*mat))
		error_internal("Given packed matrix in mat_ring_create_zero_sub");

	n = mat_row(*mat);
	m = mat_col(*mat);

	zero = ring_zero(cring);

	ptr_mat = mat_elt0_ptr(*mat);
	dim2 = m * n;

	for (j = 1; j <= dim2; j++)
		ptr_mat[j] = zero;

	mat_incref_entries(cring, *mat);
	ring_elt_delete(cring, &zero);

	return;
}


matrix 
mat_ring_create_zero WITH_2_ARGS(
	t_handle,		cring,
	integer_small,	dim
)
/* 
** Returns a zero matrix over coefficient ring cring of dimension dim by dim.
*/
{
	matrix c;

	c = mat_new(dim, dim);
	mat_ring_create_zero_sub(cring, &c);
	return c;
}

