
#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "zm.e"
#include "error.e"

/*
 * This file includes
 *
 *	mat_ring_submat_sub()      - sub function
 *	mat_ring_submat()          - Returns submatrix of a matrix
 */



t_void
mat_ring_submat_sub WITH_7_ARGS(
t_handle,	cring,
matrix,	a,
integer_small,	rowposn,
integer_small,	colposn,
matrix*,	pc,
integer_small,	rows,
integer_small,	cols
)
/*
 * Puts in "pc" the submatrix of dimension rows x cols starting
 * at the (rowposn, colposn) entry of a.
 *
 * "cring" is the coefficient ring.
 * "rowposn" and "colposn" start counting at one.
 */
{
	register t_int	j1;
	register t_int	j2;
	register t_int	k1;
	register t_int	k2;
	register t_int*	ptr_a;
	register t_int*	ptr_c;
	register integer_small	dim2;
	integer_small	am;
	integer_small	an;
	integer_small	bm;
	integer_small	bn;
	matrix	mata;
	matrix	matc;
	Logical	respack;

	mata = matc = 0;
	/*
	 * check boundaries
	 */
	am = mat_row(a);		an = mat_col(a);
	DENY ( cols + colposn > an + 1 || colposn <= 0 || rows + rowposn > am + 1 || rowposn <= 0 );
	/*
	 * invalid row and/or column number
	 */

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, rows, cols);
	mat_create_unpkd(cring, a, mata, am, an);

	/*
	 * now copy the submatrix into stk
	 */
	ptr_a = mat_elt0_ptr(mata);
	ptr_c = mat_elt0_ptr(matc);
	j1 = 0;
	j2 = (rowposn - 1) * an + colposn - 1;
	for (k1 = 1; k1 <= rows; k1++)
	{
		for (k2 = 1; k2 <= cols; k2++)
		{
			j1++;
			ptr_c[j1] = ptr_a[j2 + k2];
		}
		j2 += an;
	}

	mat_incref_entries(cring, matc);
	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
}



matrix 
mat_ring_submat WITH_6_ARGS(
	t_handle,		cring,
	matrix, 	mat,
	integer_small,	rowposn,
	integer_small,	colposn,
	integer_small,	rows,
	integer_small,	cols
)
/* 
 *	Returns t_handle to submatrix of "mat" with dimension rows x cols
 *	starting at the (rowposn, colposn) entry of mat.
 *
 *	"cring" is the coefficient ring.
 *	"rowposn" and "colposn" start counting at one.
 *
 *	It calls mat_ring_submat_sub
 */
{
	matrix c = 0;

	mat_ring_submat_sub (cring, mat, rowposn, colposn, &c, rows, cols);
	return c;
}


