#include "defs.h"
#include "integer.e"
#include "ring.h"
#include "mat.h"

t_ring_elt
mat_ring_trace WITH_2_ARGS(
	t_handle,		ring,
	matrix,		a
)
/*
** Returns the trace of a square matrix a over coefficient ring ring.
*/
{
	t_int		n;
	t_int		row;
	t_ring_elt	trace;
	t_int		diag;
	matrix		mata;
	t_ring_elt	temp;
	t_ring_elt	(*ringadd)();

	switch( ring_type( ring ))
	{
	case RING_Z:
		return mat_z_trace( ring, a );

	case RING_ZM:
		return mat_zm_trace( ring, a );
	default:
		break;
	}

	n = mat_row(a);
	if (n != mat_col(a))
		error_internal("Cannot take trace of a non-square matrix");

	mata = 0;
	mat_create_unpkd(ring, a, mata, n, n);

	ringadd = ring_addition( ring );
	diag = 1;

	/*
	** Scan the diagonal entries
	*/

	trace = ring_zero( ring );
	for (row = 1; row <= n; row++)
	{
		temp = trace;
		trace = (*ringadd)( ring, temp, mat_entry( mata, diag ));
		ring_elt_delete( ring, &temp );
		diag += (n + 1);
	}

	mat_free_unpkd(a, mata);

	return trace;
}
