#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

t_int
mintd_mult WITH_3_ARGS(
    t_int,    mdig,
    t_int,    adig,
    t_int,    bdig
)
/*
** input:  mdig - positive beta-digit
** adig, bdig - beta-digits in z mdig
** output: imdprd = adig * bdig in z mdig, a beta-digit
** computes the modular digit product of adig and bdig.  the
** product is computed modulo mdig.
*/
{
	t_int    quot;
	t_int    carry;
	t_int    prod;
	t_int    result;

	ib_mult(adig, bdig, &carry, &prod);
	ib_quot_rem(carry, prod, mdig, &quot, &result);

	return result;
}
