#include "defs.h"
#include "mp.e"
#include "mp.h"

/*
OUTPUT ROUTINES:	These are subject to change, according to the 
			desired output format - it's very hard to write
			a generic output function.
*/

void
mp_priv_break_out	WITH_4_ARGS(
	char *,		s,
	mp_sign_type,	sign,
	mp_length,	width,
	void_func,	act /* (char) */
)
/*
Sends the string in s through act(), with optional sign prefixed,
and with suitable formatting spaces specified by width.
*/
{
    mp_length	i;

    i = strlen(s) + (sign < 0);

    if (width > 0)
	for (; i < width; i++)
	   (*act)(' ');

    if (sign < 0)
	(*act)('-');

    for (; *s; s++)
	(*act)(*s);

    if (width < 0)
    {
	width = -width;

	for (; i < width; i++)
	   (*act)(' ');
    }
}


void
mp_break	WITH_5_ARGS(
	mp_float,	x,
	mp_base_type,	outbase,
	mp_length,	width,
	mp_length,	places,
	void_func,	act /* (char) */
)
/*
Breaks x into characters for output, and sends them through act().  If places
is less than zero, as many fractional places as possible are sent, otherwise
places number of places are sent.  Accumulator operations are performed.
*/
{
    mp_ptr_type		xp = mp_ptr(x);
    mp_length		t, new_t, i, nmax, out_index;
    mp_expt_type	expt;
    mp_base_type	b;
    mp_sign_type	x_sign;
    mp_int		multiplier;
    mp_acc_float	x_temp, rnd_temp;
    mp_ptr_type		x_temp_ptr;
    char		*out_buf, *s;
    mp_bool		optimize;


    if (mp_is_zero(xp))
    {
	mp_length	len = (places > 0)? places + 2: 1;

	if (width > 0)
	    for (i = len; i < width; i++)
	       (*act)(' ');

	(*act)('0');

	if (places > 0)
	{
	    (*act)('.');

	    while (places--)
		(*act)('0');
	}

	if (width < 0)
	{
	    width = -width;

	    for (i = len; i < width; i++)
	       (*act)(' ');
	}

	return;
    }


    /*
    Copy parameters of x into temporary variables.
    */

    t = mp_t(xp);
    b = mp_b(xp);
    expt = mp_expt(xp);
    x_sign = mp_sign(xp);

    if (int_abs(expt) > t)
    {
	mp_break_expt(x, outbase, width, places, act);
	return;
    }


    DEBUG_BEGIN(DEBUG_BREAK);
    DEBUG_PRINTF_1("+break {\n");
    DEBUG_1("x = ", xp);


    /*
    Compute the highest power of outbase which we can multiply by.
    If b is a multiple of outbase, then use it since multiplication
    by b is trivial.
    */


    multiplier = outbase;

    while (multiplier <= MAX_INT / outbase && multiplier != b)
	multiplier *= outbase;


    new_t = t + 1 + mp_guard_digits(int_max(50, multiplier), b);
    DEBUG_PRINTF_2("new_t = %d\n", new_t);

    mp_acc_float_alloc(b, new_t, x_temp);
    mp_change_up();

    mp_move(x, x_temp);

    x_temp_ptr = mp_acc_float_ptr(x_temp);
    mp_set_sign(x_temp_ptr, 1);

    if (optimize = places < 0)
	places = -places;

    nmax = mp_change_base(outbase, b, t - expt);

    if (nmax < 0)
	nmax = 0;
    
    else if (nmax > places)
	nmax = places;


    if (round == MP_TRUNC || round == MP_RND ||
	    mp_fix_directed(mp_sign(mp_ptr(x)), round) == MP_RND_UP)
    {
	mp_round_type	save_round = round;


	mp_acc_float_alloc(b, new_t, rnd_temp);

	if (round == MP_TRUNC || round == MP_RND)
	    mp_q_to_mp(1, 2, rnd_temp);

	else
	{
	    round = MP_RND_UP;

	    mp_int_to_mp(1, rnd_temp);
	}

	if (nmax > 0)
	    mp_scale(rnd_temp, outbase, -nmax);

	mp_add_eq(x_temp, rnd_temp);

	if (mp_has_changed())
	    x_temp_ptr = mp_acc_float_ptr(x_temp);

	round = save_round;

	mp_acc_float_delete(rnd_temp);
    }


    out_index = (expt > 0? mp_change_base(outbase, b, expt): 0) + places;

    out_buf = (char *)mem_malloc(out_index + 4);
    out_index = 0;

    if ((expt = mp_expt(x_temp_ptr)) > 0)
    {
	mp_acc_float		int_x;
	mp_length		int_t, output_t;
	mp_ptr_type		int_x_ptr;

	/*
	We need to print out the integer part of x.
	Compute the size of the float needed to represent the integer part
	of x to full accuracy with internal base outbase.  Allocate an
	appropriate accumulator float.
	*/

	int_t = mp_change_base(outbase, b, int_min(t, expt));
	DEBUG_PRINTF_2("int_t = %d\n", int_t);

	mp_acc_float_alloc(outbase, int_t, int_x);

	/*
	Convert the integer part of x (in base b) to the equivalent
	number in int_x (in base outbase).
	*/

	int_x_ptr = mp_acc_float_ptr(int_x);
	mp_set_sign(int_x_ptr, 0);


	for (i = 0; i < expt; i++)
	{
	    mp_int	dig = (i < t)? mp_digit(x_temp_ptr, i): 0;
	    
	    if (i > 0)
		mp_mul_int_eq(int_x, b);

	    if (dig)
		mp_add_int_eq(int_x, dig);
	}
	mp_acc_float_delete(int_x);

	output_t = mp_expt(int_x_ptr);

	for (i = 0; i < output_t; i++, out_index++)
	    out_buf[out_index] = (i < int_t? mp_digit(int_x_ptr, i): 0) + '0';
    }


    /*
    i will be the number of characters (including point) used for
    the fractional part of x.
    */

    i = 0;

    if (nmax > 0)
    {

	mp_acc_float	frac_temp;
	mp_int		scale, digits;

	mp_acc_float_alloc(b, new_t, frac_temp);
	mp_to_frac(x_temp, frac_temp);

	if (expt <= 0)
	    out_buf[out_index++] = '0';

	out_buf[out_index++] = '.';

	scale = 1;

	for (; !mp_is_zero(mp_acc_float_ptr(frac_temp)) && i < nmax; i++)
	{
	    if (scale <= 1)
	    {
		mp_mul_int(frac_temp, multiplier, frac_temp);
		digits = mp_to_int(frac_temp);
		mp_to_frac(frac_temp, frac_temp);
		scale = multiplier;
	    }

	    scale /= outbase;
	    out_buf[out_index++] = digits / scale + '0';

	    digits %= scale;
	}
	mp_acc_float_delete(frac_temp);
    }


    /*
    It's simple to use the char* s now that no block operations are possible.
    */

    s = out_buf + out_index;


    if (optimize)
    {
	if (nmax > 0)
	{
	    while (s[-1] != '.' && s[-1] =='0')
		s--;
	    
	    if (s[-1] == '.')
		s--;
	}
    }

    else
    {
	while (i < places)
	    out_buf[out_index++] = '0';
    }

    if (s == out_buf)
    {
	*s++ = '0';
	x_sign = 0;
    }

    *s = 0;

    mp_break_out(out_buf, x_sign, width, act);

    mem_free(out_buf);
    mp_acc_float_delete(x_temp);
    mp_change_down();

    DEBUG_PRINTF_1("-} break\n");
    DEBUG_END();
}
