#include "defs.h"
#include "mp.e"
#include "mp.h"


void
mp_priv_nzr	WITH_5_ARGS(
	mp_sign_type,		sign,
	mp_expt_type,		expt,
	mp_ptr_type,		zp,
	mp_digit_ptr_type,	digs,
	mp_length,		guard
)
/*
Normalizes the digits digs containing the specified number of guard digits, and
stores the result in zp, with the sign and exponent.  The contents of digs are
destroyed.  See the notes for a description of the different rounding types.
*/
{
    mp_bool		must_round_away;
    mp_length		t, total, first, i, num;
    mp_base_type	b;


#define digit(i)	digs[i]
#define digit_ptr(i)	(digs + i)


    b = mp_b(zp);
    t = mp_t(zp);

    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+nzr {\n");

    if (sign == 0)
    {
	mp_set_sign(zp, 0);

	DEBUG_PRINTF_1("sign(z) = 0\n");
	DEBUG_PRINTF_1("-} nzr\n");
	DEBUG_END();

	return;
    }

    DEBUG_PRINTF_2("t = %d\n", t);
    DEBUG_PRINTF_2("guard = %d\n", guard);
    DEBUG_PRINTF_2("round = %d\n", round);
    DEBUG_PRINTF_2("expt = %d\n", expt);
    DEBUG_PRINTF_2("sign = %d\n", sign);
    DEBUG_DUMP("digits = ", digs, total);

    /*
    Find first non-zero digit.
    */

    total = t + guard;

    for (first = 0; first < total; first++)
	if (digit(first) > 0)
	    break;


    if (first == total)
    {
	/*
	The digits are all zero.
	*/

	mp_set_sign(zp, 0);

	DEBUG_PRINTF_1("z = 0\n");
	DEBUG_PRINTF_1("-} nzr\n");
	DEBUG_END();

	return;
    }


    if (first > 0)
    {
	/*
	The digits need to be shifted left.
	*/

	expt -= first;

	num = total - first;
	for (i = 0; i < num; i++)
	    digit(i) = digit(i + first);
	

	/*
	Pad right with zeros.
	*/

	for (; i < total; i++)
	    digit(i) = 0;

    }


    /*
    Check whether rounding away from zero is needed.
    */

    must_round_away = FALSE;

    if (guard > 0)
	if (round == (sign > 0? MP_RND_UP: MP_RND_DOWN) &&
		!mp_all_zero(digit_ptr(t), guard))
	    /*
	    Directed rounding - if any of the guard digits are non-zero and
	    the excess is in the direction of the rounding, then rounding
	    must take place.
	    */

	    must_round_away = TRUE;


	else if (round == MP_RND)
	{
	    /*
	    Simple rounding to nearest.  Even & odd bases need to be treated
	    separately.
	    */

	    mp_base_type	b2 = b / 2;


	    if (b % 2 == 0)
	    {
		/*
		b is even.  Round if the first guard digit >= b/2, unless
		the t'th significant digit is even, the first guard digit is
		b/2, and the other guard digits are all zero.
		*/

		if (digit(t) > b2 || digit(t) == b2 && (digit(t - 1) % 2 ||
			!mp_all_zero(digit_ptr(t + 1), guard - 1)))
		    must_round_away = TRUE;
	    }

	    else
	    {
		/*
		b is odd.  Round if guard digits > 1/2 (in base b).
		*/

		for (i = t; i < total; i++)
		    if (digit(i) != b2)
			break;

		
		/*
		If (i == total) now, then all the guard digits are b/2, which
		makes them equivalent to 1/2 in base b.
		*/

		must_round_away = (i == total || digit(i) > b2);
	    }
	}


    if (must_round_away)
    {
	/*
	Round away from zero.
	*/

	DEBUG_PRINTF_1("am rounding\n");

	for (i = t - 1; i >= 0 && ++digit(i) >= b; i--)
		digit(i) = 0;

	if (i < 0)
	{
	    /*
	    Exceptional case - rounded up to .1000...
	    */

	    DEBUG_PRINTF_1("exceptional- rounded up to .10..\n");

	    expt++;
	    digit(0) = 1;
	}
    }


    /*
    Check for overflow and underflow.
    */

    if (expt > MAX_EXPT)
    {
	mp_overflow(zp);

	DEBUG_PRINTF_1("-} nzr\n");
	DEBUG_END();

	return;
    }

    if (expt <= -MAX_EXPT)
    {
	mp_underflow(zp);

	DEBUG_PRINTF_1("-} nzr\n");
	DEBUG_END();

	return;
    }


    /*
    Copy sign, exponent, and final digits into z.
    */

    mp_set_sign(zp, sign);
    mp_expt(zp) = expt;
    mp_dig_copy(mp_digit_ptr(zp, 0), digs, t);

    /*
    Update statistical indicators of max & min exponents.
    */

    mp_update(zp);

    DEBUG_PRINTF_1("-} nzr\n");
    DEBUG_END();
}
