#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "dyn_arr.h"
#include "system.h"

t_void  poly_array_permute WITH_1_ARG(
t_handle,       arr
)
{ 
	/* 
	** Randomly permute the elements of the array.
	*/
        t_int           n, r, i;
        integer_big     t; 
 
        n = poly_array_length(arr);
        for (i = n-1;  i >= 0; i--)
        { 
                r = utl_rand_int(0, i);
                t = dyn_arr_element(arr, r);
                dyn_arr_element(arr, r) = dyn_arr_element(arr, i); 
                dyn_arr_element(arr, i) = t; 
        }
} 

t_handle	f_poly_array_alloc MEM_DECL_1(length)
t_int		length;
{
	return dyn_arr_alloc_INHERIT(length);
}

t_void		poly_array_delete WITH_2_ARGS(
t_handle, 	pring,
t_handle *,	parray
)
{
	t_int	i, len;
	t_poly	temp;

	len = dyn_arr_curr_length(*parray);

	for(i=0; i < len; i++)
	{
		temp = dyn_arr_element(*parray, i);
		poly_z_elt_delete(pring, &temp);
	}
	mem_delete_hptr(parray);
}
		
t_void		poly_array_write WITH_2_ARGS(
t_handle,	pring,
t_handle,	parray
)
{
	t_int	i, len;
	t_poly	temp;

	len = dyn_arr_curr_length(parray);
	dmplin();

	for(i=0; i < len; i++)
	{
		cay_print("Array element %d = ", i);
		temp = dyn_arr_element(parray, i);
		poly_z_write(pring, temp);
		dmplin();
	}
	dmplin();
}

t_int	poly_array_length WITH_1_ARG(
t_handle,	resmh
)
{
	return dyn_arr_curr_length(resmh);
}

t_poly	poly_array_get WITH_2_ARGS(
t_handle,	resmh,
t_int,		entry
)
{
	return dyn_arr_element(resmh, entry);
}


void	poly_array_append WITH_2_ARGS(
t_handle,	resmh,
t_poly,	entry
)
/* 
** Adds entry to the end of the array resmh
*/
{
	t_int    nfactors;

	nfactors = dyn_arr_curr_length( resmh );

	/* add factor to end */

	dyn_arr_assure_space( resmh, nfactors+1, 3 );
	dyn_arr_element( resmh, nfactors ) =  entry;
	dyn_arr_curr_length( resmh) = nfactors+1;
}

