#include "defs.h"
#include "debug.e"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"
#include "error.e"

t_handle
poly_u_zm_fact_b2_large WITH_3_ARGS(
        t_handle,      pring,
	integer_big,   pdig,	 /* field modulus */
	t_poly,	apoly
)
/*
** MODUPOLY_FACT_B2_LARGE: Modular univariate polynomial Berlekamp
** Q matrix construction - Step 2 .
** pdig: prime beta-integer.
** apoly: uivariate polynomial over Zpdig.
** deg( apoly ) >= 2 .
** Returns the Q matrix for apoly as defined in Knuth p 425.
*/
{
	block_declarations;
	t_int	apolydeg;
	t_int	aexpt;
	integer_big	acoefft;
	t_matrix		Qhdl;
	t_matrix		phdl;
	t_int	i;
	t_int	j;
	t_int	anterms;
	t_int	atermno;
	t_handle		aph;
	integer_big	temp;
	t_int	n;
	t_int	len;
	t_int	off_apoly;
	t_int	off_a;
	t_int	off_b;
	t_int	off_n;
	t_int	dega;
	t_int	degb;
	t_int	degc;

	aph = m_poly_poly_to_handle( apoly );
	ASSERT (m_poly_univariate(aph));

	apolydeg = poly_deg( apoly );

	DENY ( apolydeg < 2 );

	Qhdl = poly_mat_new( apolydeg, apolydeg );

#define ROW_APOLY 1
#define ROW_A 2
#define ROW_B 3
#define ROW_C 4
#define ROW_TOTAL 4

	len = 2 * apolydeg;
	off_a = (ROW_A - 1) * len;
	off_b = (ROW_B - 1) * len;
	off_apoly = (ROW_APOLY - 1) * len;

	phdl = poly_mat_new( ROW_TOTAL, len );

	for ( i = len * ROW_TOTAL; i >= 1; --i )
	{
		m_poly_mat_entry( phdl, i ) = 0;
	}

	anterms = m_poly_nterms( aph );

	for ( atermno=0; atermno < anterms; atermno++ )
	{
		aexpt = m_poly_expt( aph, atermno );
		acoefft = m_poly_coefft( aph, atermno );
		m_poly_mat_entry( phdl, off_apoly + aexpt+1 ) = integer_incref( acoefft );
	}

	m_poly_mat_entry( phdl, off_a + 2 ) = 1;
	dega = 2;

	IF_DEBUG_FLAG( DEBUG_MODUPOLY_FACT_B2_LARGE,
	{
		cay_print( "initial phdl = \n" );
		poly_z_Qmatrix_write( phdl );
	}
	);

	poly_u_zm_d_power_rem( pdig, pdig, phdl, dega, ROW_A, apolydeg+1, ROW_APOLY, &degb, ROW_B, ROW_C );

	for ( j = 1; j <= len; ++j )
	{
		temp = m_poly_mat_entry( phdl, off_a + j );
		integer_delref( temp );
		temp = m_poly_mat_entry( phdl, off_b + j );
		m_poly_mat_entry( phdl, off_a + j ) = integer_incref( temp );
	}
	dega = degb;

	/*
	** x^0 into Qmatrix
	*/

	m_poly_mat_entry( Qhdl, 1 ) = 1;
	for ( j=2; j<=apolydeg; ++j )
	{
		m_poly_mat_entry( Qhdl, j ) = 0;
	}

	n = 2;

	for ( ;; )
	{
		/*
		** put a into Qmatrix
		*/

		off_n = (n - 1) * apolydeg;

		for ( j = 1; j <= dega; ++j )
		{
			temp = m_poly_mat_entry( phdl, off_a + j );
			m_poly_mat_entry( Qhdl, off_n + j ) = integer_incref( temp );
		}

		for ( ; j <= apolydeg; ++j )
		{
			m_poly_mat_entry( Qhdl, off_n + j ) = 0;
		}

		if ( n >= apolydeg )
		{
			break;
		}

		++n;

		/*
		** c := a * b;
		*/

		poly_u_zm_d_mult( pdig, phdl, dega, ROW_A, degb, ROW_B, &degc, ROW_C );

		IF_DEBUG_FLAG( DEBUG_MODUPOLY_FACT_B2_LARGE,
		{
			cay_print( "mult %d * %d into %d to produce\n", ROW_A, ROW_B, ROW_C );
			poly_z_Qmatrix_write( phdl );
		}
		);

		/*
		** a := c mod apoly;
		*/

		poly_u_zm_d_rem( pdig, phdl, degc, ROW_C, apolydeg+1, ROW_APOLY, &dega, ROW_A );

		IF_DEBUG_FLAG( DEBUG_MODUPOLY_FACT_B2_LARGE,
		{
			cay_print( "mod %d by %d into %d to produce\n", ROW_C, ROW_APOLY, ROW_A );
			poly_z_Qmatrix_write( phdl );
		}
		);
	}

	IF_DEBUG_FLAG( DEBUG_MODUPOLY_FACT_B2_LARGE,
	{
		cay_print( "poly_u_zm_fact_b2_large() returns Q =\n" );
		poly_z_Qmatrix_write( Qhdl );
		dmplin();
	}
	);

	/* dusseldorf fix */
	mem_delete_hptr( &phdl );     /*  MD 31.03.92 */


	return  Qhdl;
}

