
#include "defs.h"
#include "integer.e"
#include "poly.h"

/*
 * This file contains three functions
 *	poly_z_constant_poly (pring, apoly, aint)
 *	poly_z_constant_dims (pring, pvar, lpvar, aint)
 *	poly_z_is_one_poly (pring, apoly)
 */

t_poly
poly_z_constant_poly WITH_3_ARGS(
        t_handle,    pring,
        t_poly,   apoly,
        integer_big, aint
)
/*
 * create the constant polynomial with the same princvar and
 * least_princvar as apoly and value aint.
 */

{
    block_declarations;
    t_handle       aph;
    t_int  lpvar;
    t_int  pvar;

    if (m_poly_const (apoly))
        return integer_incref(aint);

    aph = m_poly_poly_to_handle (apoly);
    pvar = m_poly_princvar (aph);
    lpvar = m_poly_least_pvar (aph);

    return poly_z_constant_dims (pring, pvar, lpvar, aint);
}

t_poly
poly_z_constant_dims WITH_4_ARGS(
        t_handle,     pring,
        t_int, pvar,
        t_int, lpvar,
        integer_big,  aint
)
/*
 * create the constant polynomial with the same princvar and
 * least_princvar as apoly and value aint.
 */

{
    block_declarations;
    t_handle       resph;
    t_handle       temp;
    t_int  varno;

    resph = m_poly_poly_to_handle (integer_incref (aint));

    for (varno = lpvar; varno >= pvar; varno --)
    {
        m_poly_create_empty(&temp, varno, lpvar, 1);
        m_poly_coefft (temp, 0) = m_poly_handle_to_poly(resph);
        m_poly_expt (temp, 0) = 0;
        resph = temp;
    }

    return m_poly_handle_to_poly(resph);

} /* poly_z_constant_poly () */

t_bool
poly_z_is_one_poly WITH_2_ARGS (
        t_handle,     pring,
        t_poly,    apoly
)
/*
 *  return TRUE if apoly equals 1 
 */
{
    t_handle   aph;

    if (m_poly_const (apoly))
        return (apoly == 1);

    aph = m_poly_poly_to_handle (apoly);
    for (;;)
    {
        if (m_poly_nterms (aph) != 1)
            return FALSE;
        if (m_poly_expt (aph, 0) != 0)
            return FALSE;
        if (m_poly_univariate (aph))
            return (m_poly_coefft (aph, 0) == 1);
        aph = m_poly_poly_to_handle (m_poly_coefft (aph, 0));
    }
} /* poly_z_is_one_poly */

