#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_poly
poly_z_subtract WITH_3_ARGS(
    t_handle,    pring,
    t_poly,   apoly,
    t_poly,   bpoly
)
/*
*        IPOLY_SUBTRACT: integral  polynomial difference.
*        apoly, bpoly are integral polynomials
*        returns apoly - bpoly
*/
{
    block_declarations;
    t_poly    temp;
    t_poly    result;

    if ( m_poly_const( apoly ) && m_poly_const( bpoly ) )
    {
        /* both constants, apoly != bpoly */

        return  integer_subtract( apoly, bpoly );
    }

    /* at least one non-constant polynomial */

    if (m_poly_const (bpoly) || m_poly_const (apoly))
    {
        error_internal ("poly_z_subtract: polys not lifted\n");
        return  0;
    }

    /* both non-const polys */

    if ( poly_z_is_zero_poly (pring, bpoly))
    {
        return  m_poly_z_incref( pring, apoly );
    }

    if ( poly_z_is_zero_poly (pring, apoly))
    {
        return  poly_z_negate( pring, bpoly );
    }

    /* both non-trivial polynnomials */

    temp = poly_z_negate( pring, bpoly );
    result = poly_z_add( pring, apoly, temp );
    m_poly_z_delref( pring, temp );

    return  result;

} /* poly_z_subtract() */

