#include "defs.h"
#include "principal_ideal.e"

t_pi_elt
principal_ideal_elt_mult(ideal, elt1, elt2)
t_handle	ideal;
t_pi_elt	elt1, elt2;
{

	t_pi_context    context;

        pi_ctx_init(ideal, &context);
        return pi_elt_mult_ctx(&context, elt1, elt2);
}

t_pi_elt pi_elt_mult_ctx(context, elt1, elt2)
t_pi_ctx	context;
t_pi_elt	elt1, elt2;
{
        t_handle        ring;
	t_handle	gen;
        t_pfh           elt_mult;
        t_pfv           elt_delete;
	t_pi_elt	res;
	t_handle	temp;
	t_int		it;

	ring = m_pi_ctx_ring(context);
	gen = m_pi_ctx_generator(context);
	elt_mult = m_pi_ctx_elt_mult(context);
	elt_delete = m_pi_ctx_elt_delete(context);
	ASSERT(elt_mult);
	ASSERT(elt_delete);


        (*elt_mult)(ring, elt1, 0, elt2, 0, &temp, &it);
	(*elt_mult)(ring, temp, 0, gen, 0, &res, &it);
	(elt_delete)(ring, &temp);
	return res;
}

t_pi_elt
principal_ideal_elt_scalar_mult(ideal, elt1, s)
t_handle        ideal;
t_pi_elt        elt1;
t_handle	s;
{

        t_pi_context    context;

        pi_ctx_init(ideal, &context);
        return pi_elt_scalar_mult_ctx(&context, elt1, s);
}

t_pi_elt pi_elt_scalar_mult_ctx(context, elt1, s)
t_pi_ctx	context;
t_pi_elt	elt1;
t_handle 	s;
{
        t_handle        ring;
        t_pfh           elt_mult;
	t_pi_elt	res;
	t_int		it;

	ring = m_pi_ctx_ring(context);
	elt_mult = m_pi_ctx_elt_mult(context);
	ASSERT(elt_mult);

        (*elt_mult)(ring, elt1, 0, s, 0, &res, &it);
	return res;
}
