#include "defs.h"
#include "principal_ideal.e"
#include "error.e"
#include "structure.e"
#include "ring.e"

static t_handle pi_str_create_hard P_((t_handle, t_handle));
#ifndef KANT
#include "alg.e"
static t_logical pi_str_create_arg P_((t_int,t_handle,t_handle));

private t_logical pi_str_create_arg( n, m1, m2 )
t_int n;
t_handle m1, m2;
/* m1 is the new value, m2 is the old. */
{
	static 	t_handle	ring;
	t_pfl			elt_equal;

	switch( n )
	{
		case 0:
			ring = m1;
			return m1 == m2; /* Rings are equal. */
			break;
		case 1:
			/* This assumes that the case 0 has been called!! */
			elt_equal = ALG_FIND(ring, OP_EQ);
			return (*elt_equal)(ring,  m1,0,ring, m2,0 );
			break;
		default:
			DIE();
	}
	return FALSE;
}

#endif /* KANT */


private t_handle pi_str_create_hard(ring, g)
t_handle 	ring, g;
{
	t_handle r;

	r = structure_alloc( sizeof( t_pi_table ), 0, 1, REP_PRINCIPAL_IDEAL, TRUE );

	m_pi_ring(r) = m_ring_incref(ring);
	m_pi_generator(r) = ring_elt_incref(ring, g);
	m_pi_factors(r) = NH;

	return r;
}

public t_handle principal_ideal_str_create( ring, g)
t_handle	ring, g;
{
	t_handle	res;
	
#ifndef KANT
	res =  structure_create( REP_PRINCIPAL_IDEAL, pi_str_create_hard, 
		pi_str_create_arg, 2, ring, g );
#else
	res = structure_create_hard(ring, g);
#endif /* KANT */
 
	return res;
}
