#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_mult WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	rational,	b
)
/*
Returns the product of rationals a and b.
*/
{
    rational		c;

    if (a == 0 || b == 0)
    {
	return 0;
    }

    if (b == Q_ONE)
    {
	return q_incref(a);
    }

    if (q_numer(b) == q_denom(b))
    {
	return q_incref(a);
    }

    c = q_new();
    q_numer(c) = integer_mult(q_numer(a), q_numer(b));
    q_denom(c) = integer_mult(q_denom(a), q_denom(b));
    q_simplify(c);

    return c;
}

