#ifndef KANT

#include "error.e"
#include "alg.e"
#include "real.e"
#include "comp.e"
#include "mp.e"
#include "eseq.e"
#include "conv.e"
#include "structure.e"

t_bool
real_elt_coerce (rring, str, elt, itm, nelt, nitm, do_error)
t_handle	       rring, str, elt, *nelt;
t_int	          itm, *nitm;
t_logical		do_error;
/*
** Lift elt into rring
** Called by ring_coerce
*/
{
	mp_float tmp1, tmp2;
	t_real	temp_r;
	t_handle	temp;

	ASSERT (structure_repnum (rring) == REP_REAL);

	switch (structure_varnum(str)) 
	{
	case VAR_RING:
		switch (ring_type (str))
		{
			case RING_Z:
				*nelt = conv_int_to_real (rring, elt);
				break;
			case RING_Q :
				*nelt = conv_q_to_real (rring, elt);
				break;
			case RING_QM :
				if (qm_is_real(str, elt))
				{
					*nelt = conv_qm_to_real (rring, elt);
					break;
				}
				else
					return 0;
			case RING_QUAD :
				temp = conv_quad_to_real(rring, str, elt);
				if (temp)
				{
					*nelt = temp;
					break;
				}
				else
					return 0;
			case RING_R :
				if (real_beta_prec(rring) < real_beta_prec(str))
				return 0;
				*nelt = conv_real_to_real (elt, str, rring);
				break;
			case RING_C :
				comp_split_mp( elt, tmp1, tmp2);
				if (! mp_is_zero(mp_ptr(tmp2)))
					return 0;
				if (real_beta_prec(rring) < comp_beta_prec(str))
					return 0;
				tmp2 = mp_alloc( real_base, comp_beta_prec( str ));
				mp_priv_move( tmp1, tmp2);
				temp_r = mp_to_real (tmp2);
				*nelt = conv_real_to_real (temp_r, str, rring);
				break;

			default :
				return 0;
		}
		break;
	case VAR_POW_SEQ:
		if (eseq_length( elt) != 2)
                        return FALSE;
 
                if (structure_repnum(eseq_univ_str( elt)) != REP_Z)
                        return FALSE;
                *nelt = conv_seq_to_real(rring,  elt);
		break;
	default:
		return FALSE;
	}
	*nitm = 0;
	return 1;
}


#else /* KANT */

#include "error.e"
#include "real.e"
#include "comp.e"
#include "mp.e"
#include "conv.e"
#include "structure.e"

t_bool
real_elt_coerce (rring, str, elt, itm, nelt, nitm, do_error)
t_handle	       rring, str, elt, *nelt;
t_int	          itm, *nitm;
t_logical		do_error;
/*
** Lift elt into rring
** Called by ring_coerce
*/
{
	mp_float tmp1, tmp2;
	t_real	temp_r;
	t_handle	temp;

	ASSERT (structure_repnum (rring) == REP_REAL);

	switch (ring_type (str))
	{
		case RING_Z:
			*nelt = conv_int_to_real (rring, elt);
			break;
		case RING_Q :
			*nelt = conv_q_to_real (rring, elt);
			break;
		case RING_R :
			if (real_beta_prec(rring) < real_beta_prec(str))
			return 0;
			*nelt = conv_real_to_real (elt, str, rring);
			break;
		case RING_C :
			comp_split_mp( elt, tmp1, tmp2);
			if (! mp_is_zero(mp_ptr(tmp2)))
				return 0;
			if (real_beta_prec(rring) < comp_beta_prec(str))
				return 0;
			tmp2 = mp_alloc( real_base, comp_beta_prec( str ));
			mp_priv_move( tmp1, tmp2);
			temp_r = mp_to_real (tmp2);
			*nelt = conv_real_to_real (temp_r, str, rring);
			break;

		default :
			return 0;
	}
	*nitm = 0;
	return 1;
}


#endif /* KANT */
