#include "defs.h"
#include "debug.h"

extern t_int	seed;

t_int
utl_rand_num(reset)
t_int	reset;
{
	register t_int	m = 2147483647;
	register t_int	a = 48271;
	register t_int	q = 44488;
	register t_int	r = 3399;
	register t_int	hi;
	register t_int	lo;
	register t_int	test;

	/*
	 * Returns a pseudo-random number in the range 1 to 2 ** 31 - 2.
	 * Guaranteed not to cause overflow on machines with more
	 * than 31 bits per word.
	 * This routine uses the linear congruential method. The
	 * initial seed is 1, since all numbers in the sequence
	 * are generated.
	 * If "reset" is < 0, the seed is reset to "-reset"
	 * modulus (m) = 2 ** 31 - 1 = 2,147,483,647
	 * multiplier (a) = 48,271
	 * To prevent overflow, we use the following numbers as well:
	 * q = m div a = 44,488
	 * r = m mod a = 3,399
	 * Other possible values of a, q, and r are:
	 * a = 69621, q = 30845, r = 23902
	 * a = 7^5 = 16807, q = 127773, r = 2836 (the "minimal standard")
	 * For more details, see Communications of the ACM, October, 1988.
	 */
	if (reset < 0 && reset > -m)
		seed = -reset;

	if (seed <= 0)
		seed = 1;
	/*
	 * New rand = ( last rand * a ) mod m
	 * Because of overflow, the multiplications must be broken up.
	 */
	hi = seed / q;
	lo = seed % q;
	test = a * lo - r * hi;
	if (test > 0)
		seed = test;
	else
		seed = test + m;

	return seed;
}
