#include "kant.h"

t_void
anf_rel_field_basis WITH_8_ARGS (order           , ord              ,
                                 anf_elt         , my               ,
                                 anf_ideal       , field_disc       ,
                                 faclst          , faclst_disc      ,
                                 faclst          , faclst_sqr_index ,
				 integer_small   , pos_index_my     ,

				 order          *, rel_ord          ,
                                 dyn_arr_handle *, generators         )
/* 
  Computes a minimal system of alg. numbers a(1),..,a(m) with
 
             o(E) = [a(1),..,a(m)] * o(F)
  The function returns a dynamic array with the following structure :
  
    In case we have an integral basis we return :       

           0    1    2 ...        
         [ 2 , a1 , z1 , .. , zn ]

    If we have't got such an basis we return :       

           0    1    2    3 ....         
         [ 3 , a1 , a2 , z1 , .. , zn ]
 
    
    And we say : w1,..,wn,z1,..,zn is a Z - basis of o(E) with 
    w1,..,wn is such a basis for o(F).



*/

{

                 block_declarations;

   
		 anf_ideal       index,index_2,index_my;
		 anf_ideal       b,gamma_ideal,temp1,temp2;
		 
                 anf_elt         xi;
		 anf_elt         gamma,ny;
             
		 integer_small   classno;
		 t_logical       index_is_princ,ok;



  order_must_be_over_z (ord); 


  

/* There is one thing that we can do anyway */

  *rel_ord = order_create_pure (ord,my,2);
  order_abs_degree (*rel_ord) = 2*order_abs_degree (ord);
  order_rel_degree (*rel_ord) = 2;


/* First check if there ex. a rel. integral basis or if we need three */
/* elements to create o(E).                                           */

/* Therefor check if the index ist a principle ideal.                 */
/* and so create the sqrt (faclst_sqr_index) first and check          */

  anf_rel_field_basis_create_index (ord,faclst_sqr_index,pos_index_my,
                                        &index,&index_2,&index_my);
  
/* This is the main check for the ex. of integral basis :             */

          
  index_is_princ      = anf_ideal_is_principal (ord,index,&gamma);


/*
  index_is_princ = FALSE;
*/


 
/* By now we know whether or not there ex an rel. integral basis      */
/* This depends on : index_is_princ = true or index_is_princ = false  */


  if (anf_print_level > 1) 
  {
    if (index_is_princ)
    {
      printf ("The index is principal with generator : ");
      anf_elt_write (ord,gamma);puts ("");
    } 
    else
      printf ("The index is NOT principle\n");
  }

  ny = anf_rel_field_basis_create_ny (ord,my,index_2,index_my);


  if (!index_is_princ)   /* There ex. no relative basis */ 
  {             

/*
    if (!order_class_number_known (ord))
      error_internal ("ORDER_CREATE_REL_2_BASIS : Classnumber not known");
  
  

    if (order_class_number_known (ord))                                       
    {
      classno = order_class_number (ord);
      b = anf_ideal_power (ord,index,classno - 1);  
                                                    

      gamma_ideal = anf_ideal_mult (ord,index,b);      
      ok          = anf_ideal_is_principal (ord,gamma_ideal,&gamma);
      if (!ok) 
        error_internal ("ORDER_CREATE_REL_2_BASIS : `index * b` is not principal");
      anf_ideal_delete (ord,&gamma_ideal);
    }      
    else
*/
      {                                   

        anf_ideal_2_assure (ord,index);
        gamma  = anf_elt_incref (anf_ideal_gen1(index));

/*
        temp1 = anf_elt_to_princ_ideal (ord,gamma);
        temp2 = anf_ideal_invert_integral (ord,index);
        b    = anf_ideal_mult (ord,temp1,temp2);
*/  

        b = anf_rel_field_basis_create_b (ord,faclst_sqr_index,gamma);
  
/*     

       anf_ideal_delete (ord,&temp1);
       anf_ideal_delete (ord,&temp2);
*/
    }


    if (anf_print_level > 1)
    {
      anf_ideal_2_assure (ord,b);
      anf_ideal_z_assure (ord,b);
      printf ("Ideal b :  ");anf_ideal_write (ord,b); puts ("");
      anf_ideal_z_write (ord,b);puts("");

      printf ("Gamma : ");
      anf_elt_write (ord,gamma);puts ("");
    }

  }


/* Afterall just one problem is left :                    */
/*    evaluate    xi = (ny + sqrt(my)) /gamma             */
    
  xi = anf_rel_field_basis_create_xi (ord,*rel_ord,my,ny,gamma);


/* Now store the solution in the dynamic array */
/*              "generators"                   */

   
  anf_rel_field_basis_create (ord,*rel_ord,index_is_princ,xi,b,generators); 

  if (!index_is_princ) 
  {
    anf_elt_delete (*rel_ord,&xi);
    anf_ideal_delete (ord,&b);
  }


  anf_elt_delete (ord,&ny);
   

  anf_ideal_delete (ord,&index);
  anf_ideal_delete (ord,&index_2);
  anf_ideal_delete (ord,&index_my);


}


