#include "kant.h"


anf_elt
anf_rel_field_basis_create_ny WITH_4_ARGS (order      , ord     ,
            			           anf_elt    , my      ,
					   anf_ideal  , index_2 ,
					   anf_ideal  , index_my  )
{
               block_declarations;

               anf_ideal      ideal;
 
               anf_elt        temp0,temp1,temp2,temp3;
               anf_elt        ny,alpha1,alpha2;


               integer_big norm,den;
                 


/* We have to solve the following problem                 */
/*                                                        */
/* (X)  find ny in o(F) (== ord) so that                  */
/*                                                        */
/*    (i)       ny^2 conrg. my mod. (index_2)^2           */
/*    (ii)      ny in index_my                            */
/*                                                        */

 
/* We solve now (X) :                                     */
/* To solve this problem we first solve (X)(i)            */
/* We know (by theory) that this problem has a solution   */

  anf_ideal_norm (ord,index_2,&norm,&den);
  
  if (integer_compare (norm,1) == 0)
  {
    ny = 1;
    ideal = anf_ideal_incref (index_2);
  }
  else
    {

      ideal = anf_ideal_mult (ord,index_2,index_2);

      if (!anf_elt_is_square_rem (ord,ideal,my,&ny))
        error_internal ("ANF_REL_FIELD_BASIS_CREATE_NY : Unable to solve congr., ask Hilbert");


    }

  integer_delref (norm);
  integer_delref (den); 
 

  if (anf_print_level > 1)
  {
    printf ("solving quad. conrg                   :");
    anf_elt_write (ord,ny);puts ("");
  }

/* Maybe we are lucky , so check : ny in index_my.        */
       
  if (! anf_elt_in_ideal (ord,ny,index_my))
  {   
   /* Index_Is_Princ we are not lucky : so we have to solve a        */
   /* congruence - problem with the chinese - remainder  */
   /* theorem.                                           */
                                  
    anf_ideal_idempotent (ord,ideal,index_my,&alpha1,&alpha2);
                       
    if (anf_print_level > 4)
    {
      printf ("Found ");anf_elt_write (ord,alpha1);
      printf (" + ");anf_elt_write (ord,alpha2);
      printf (" =  1\n");              
    }

/* We just need an Element (not zero) in index_my         */
/* So we take the first element of the ZZ - basis         */ 

    anf_ideal_z_assure (ord,index_my);
    temp0 = mat_order_col_to_anf_elt (ord,anf_ideal_tran (index_my),1);

                
    temp1 = anf_elt_mult (ord,alpha2,ny);
    temp2 = anf_elt_mult (ord,alpha1,temp0);
    
    temp3 = ny;
    ny    = anf_elt_add (ord,temp1,temp2);

    anf_elt_delete (ord,&alpha1);    
    anf_elt_delete (ord,&alpha2);   
 
    anf_elt_delete (ord,&temp0);
    anf_elt_delete (ord,&temp1);
    anf_elt_delete (ord,&temp2);
    anf_elt_delete (ord,&temp3);

  }

  anf_ideal_delete (ord,&ideal);


/* We now have created an ny with                         */
/*                                                        */
/*   (i)     ny conrg. my^2 mod (index_2)^2               */
/*   (ii)    ny in index_my                               */

 if (anf_print_level > 1)
 {
   printf ("Our final ny :");
   anf_elt_write (ord,ny);puts ("");
 }

  return ny;

} 
