#include "kant.h" 

 
t_logical
comp_equality_eps WITH_5_ARGS(
	t_handle,		C,
	t_handle,		R,
	t_comp,		a,
	t_comp,		b,
        t_real,         eps
)
/*******************************************************************************
 
Description:
 
	Compares real a and b (with error eps), returning:

		1	if |(Re(a) - Re(b))| <= eps*pow_eps,
			if |(Im(a) - Im(b))| <= eps*pow_eps,

		0	if |(Re(a) - Re(b))|  > eps*pow_eps,
			if |(Im(a) - Im(b))|  > eps*pow_eps,

	where pow_eps= max(mp_expt(a)*log10(bse), mp_expt(b)*log10(bse) ).
	We cannot guarantee for the exact precision of this function.

 
Calling sequence:
 
	flag= comp_equality(C, R, a, b, eps);
 
      	t_handle      C        = complex ring
	t_comp	    a	     = first t_comp number      
	t_comp	    b	     = second t_comp number      
	t_real	    eps	     = precision of the comparisation
 
History:
 
	92-09-25 AJ    written
 
*******************************************************************************/
{
	t_real	re_a, im_a, re_b, im_b;
	t_logical l, erg;   


	re_a= comp_re(C, a);
	im_a= comp_im(C, a);

	re_b= comp_re(C, b);
	im_b= comp_im(C, b);

	erg= real_equality_eps(R, re_a, re_b, eps);
         
	if (erg==TRUE)
	 {
	  l= real_equality_eps(R, im_a, im_b, eps);
	  erg= l & erg;
	 }
 
	real_delete(&re_a);
	real_delete(&im_a);
	real_delete(&re_b);
	real_delete(&im_b);
  
        return erg;
}
