#include "kant.h"
#include "anf_rel_sort.h"


t_void 
order_norm_equation_aj WITH_10_ARGS (
	order            , ord,
	order            , sub_ord,
        integer_big      , K,
        anf_elt*         , gamma ,
        dyn_arr_handle*  , list  , 
        t_logical        , find_all, 
        t_logical        , abs_value, 
        anf_rel_sort     , sort,
        vector           , rel_K,
        anf_elt          , norm_elt
 )
/*******************************************************************************
 
Description:
 
      Tries to solve the eqaution 
      (*)                         |N(x)| = K        
      in the order ord. The switch find_all indicates whether you want to
      have just on solution or you need all of them.


 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 

        integer_big     K        = as desc. in (*).

        anf_elt         gamma    = Element solving (*).
        dyn_arr_handle  list     = If you need all sol. of (*) they
                                   will be stored in this dyn. array.

	t_logical         find_all = switch as desc. above.
                                                                  

            order_norm_equation (ord,K,&gamma,&list,find_all);
 
History:
 
	92-06-22 MD     written
 
*******************************************************************************/
{
  
                 block_declarations;

                          
                 lattice        lat;
                 lat_enum_env   lat_env;                    
                                
                 t_logical        is_ideal   = FALSE;
                 t_logical        check_sign = FALSE;



  order_reals_assure (ord);
 

  order_lat (ord,&lat,&lat_env);
  order_lat_norm_equation_aj (ord,sub_ord,0,lat,lat_env,K,gamma,list,
           find_all,is_ideal,abs_value,sort,rel_K, norm_elt);

  lat_enum_delete(lat, &lat_env);
  lat_delete(&lat);                  
                              
}
