#include "kant.h" 


order
order_trans_down WITH_2_ARGS(
	order,		ord,
	matrix,	        trans
)
/*******************************************************************************
 
Description:
 
       Computes the suborder given by an order and a transformation matrix.
       All order values of the new order are transformed to
       representations referring to the new order basis.
 
       If (and only if) the index of the new order in the old order is one
       the units (if known) are moved to the new order.
 
       The handling of ideal class group generators is not yet supported.
 
 
Calling sequence:
 
	ordnew = order_trans_down(ordold, trans);
 
      	order       ordold   = t_handle of an order 
      	order       ordnew   = t_handle of an suborder 
      	trans       gamma    = transformation matrix
      
 
History:
 
	92-07-08 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

	order		power_ord, sub_ord;              
	matrix 		mat1, mat2;
	integer_big	den;
	integer_small	i,j;
	t_handle 		Z;  



	Z= m_z_str_incref(structure_z);

	order_maximal_to_power(ord, &power_ord, &mat1, &den);

	if (anf_print_level >=7 )
	 {
	  printf("\n\norder_trans_down: mat1= \n");
          for (i=1; i<=order_abs_degree(ord); i++)
	   {
            for (j=1; j<=order_abs_degree(ord); j++)
	    printf(" \t %d", mat_elt(mat1, i,j) );
	    printf("\n");
	   }
	  printf("\n \n");   

	  printf("\norder_trans_down: detenominator of mat1: ");
	  integer_write(den);
	  printf("\n \n");
	 }
	 
	mat2=  mat_ring_mult(Z, mat1, trans);

	sub_ord= order_trans(power_ord, mat2, den);
	order_reals_set(sub_ord, real_dec_prec(order_reals(ord)) );
	order_reals_assure(sub_ord);

	mat_delref(Z, &mat1);
	mat_delref(Z, &mat2);
	order_delete(&power_ord); 
	integer_delref(den);
	ring_delete(&Z);
	                         
	return sub_ord;

} 

