/****************************************************************************** 
  rel_lat_delete.c                                                           
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"  


t_void
rel_lat_delete WITH_1_ARG (
	rel_lattice*,	rel_lat
)

/******************************************************************************
 
Description:
 

 
Calling sequence:
 

 
History:
 
	92-03-12 AJ    written
 
*******************************************************************************/
{
	block_declarations;

	integer_small	i, r1, r2, r1r2;
	t_handle		Z;

	if (block_ref_count(*rel_lat) == 1)
	 {  
                                       
	  r1= order_r1(rel_lat_coef_ord(*rel_lat)); 
	  r2= order_r2(rel_lat_coef_ord(*rel_lat)); 
	  r1r2= r1+r2;

	  if (rel_lat_coef_ord_gram(*rel_lat)!=MEM_NH)
	    mat_delref(order_reals(rel_lat_coef_ord(*rel_lat)),
	               &rel_lat_coef_ord_gram(*rel_lat));

	  if (rel_lat_coef_ord_known(*rel_lat))
	    order_delete(&rel_lat_coef_ord(*rel_lat));

	  Z= m_z_str_incref(structure_z);

	  if (rel_lat_basis_known(*rel_lat))
	    if (rel_lat_basis(*rel_lat)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {
	        mat_delref(rel_lat_basis_ring(*rel_lat),
	                   &rel_lat_basis_con(*rel_lat,i));
	        rel_lat_basis_con(*rel_lat,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_basis(*rel_lat));
	     }                           
          ring_delete(&rel_lat_basis_ring(*rel_lat));

	  if (rel_lat_gram_known(*rel_lat))
	    if (rel_lat_gram(*rel_lat)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {
	        mat_delref(rel_lat_gram_ring(*rel_lat),
	                   &rel_lat_gram_con(*rel_lat,i));
	        rel_lat_gram_con(*rel_lat,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_gram(*rel_lat));
	     }     	    
	  ring_delete(&rel_lat_gram_ring(*rel_lat));      

	  if (rel_lat_chol_known(*rel_lat))
	    if (rel_lat_chol(*rel_lat)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {
	        mat_delref(rel_lat_chol_ring(*rel_lat),
	                   &rel_lat_chol_con(*rel_lat,i));
	        rel_lat_chol_con(*rel_lat,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_chol(*rel_lat));
	     }     	    
	  ring_delete(&rel_lat_chol_ring(*rel_lat));

	  if (rel_lat_disc(*rel_lat)!= MEM_NH)
	   {
	    ring_elt_delete(rel_lat_disc_ring(*rel_lat), 
	                    &rel_lat_disc(*rel_lat));
	   }
	  if (rel_lat_disc_ring(*rel_lat)!= MEM_NH)
	      ring_delete(&rel_lat_disc_ring(*rel_lat));     

   	  ring_delete(&Z);
	 }        

	block_decref_delete(*rel_lat);

	*rel_lat = MEM_NH;
}
