#include "kant.h"
#include "thue.h" 

t_real
thue_bd_Q1_min WITH_7_ARGS(
                thue,           th,
		t_handle,	R,
                t_real,		Q1,
                t_real,         Q2,
                t_real,         Q3,
                t_real,         q_max,
                t_real,         dist_min
)

/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_int		r, hh1;
	t_real		h1, h2, h3, h4, rm1, one, factor, Q1_min;
        order           ord;
        
        ord = thue_order(th);
        r = order_r(ord);

        hh1 = integer_power(2, r-1);
        h1 = conv_int_to_real(R, hh1);
        integer_delete(&hh1);
        rm1 = conv_int_to_real(R, r-1);
        one = conv_int_to_real(R, 1);
        h3 = real_mult(R, rm1, Q2);
        factor = real_add(R, h3, one);
        real_delete(&h3);
        Q1_min = real_mult(R, factor, h1);
        real_delete(&h1);

        h1 = real_divide(R, q_max, Q3);
        h2 = Q1_min;
        Q1_min = real_max(R, Q1_min, h1);
        real_delete(&h1);
        real_delete(&h2);

        h1 = real_divide(R, factor, dist_min);
        h2 = real_real_power(R, h1, rm1);
        h3 = Q1_min;
        Q1_min = real_max(R, Q1_min, h2);
        real_delete(&h1);
        real_delete(&h2);
        real_delete(&h3);

        real_delete(&rm1);
        real_delete(&one);
        real_delete(&factor);

        /* next int */

        hh1 = conv_real_to_int_ceil(R, Q1_min);
        real_delete(&Q1_min);
        Q1_min = conv_int_to_real(R, hh1);
        integer_delete(&hh1);

        if (real_compare(R, Q1, Q1_min) == -1)
                {
                printf("Q1_min > Q1\n");
                printf("Q1_min = ");real_write(R, Q1_min, 20);puts("");
                printf("Q1     = ");real_write(R, Q1, 20);puts("");
                real_delete(&Q1_min);
                Q1_min = real_incref(Q1);
                }

        return Q1_min;
}




