#include "kant.h"
#include "thue.h" 

t_real
thue_waldschmidt_c5 WITH_2_ARGS(
                thue,           th,
                t_real,         c3
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	i, j, deg, r;
	t_handle	R, C;
	t_real		h1, h2, h3, ma, mi, T, c5;
	t_comp		z1, z2, zz;
        order           ord;
        anf             field;
        
        deg = thue_abs_degree(th);
        ord = thue_order(th);
        R = thue_reals(th);
        C = comp_create(real_dec_prec(R));

        r = order_r(ord);
        field = order_anf(ord);

        ma = ring_zero(R);
	z1 = thue_zero(th, 1);
	z2 = thue_zero(th, 2);
        zz = comp_subtract(C, z1, z2);
        mi = comp_abs(C, zz);
        comp_delete(&zz);
	comp_delete(&z1);
	comp_delete(&z2);
        for (i=1; i<=deg; i++)
                {                    
                for (j=1; j<=deg; j++)
                        {
                        if (i<j)
                                {
			        z1 = thue_zero(th, i);
			        z2 = thue_zero(th, j);
                                zz = comp_subtract(C, z1, z2);
                                h2 = comp_abs(C, zz);
				comp_delete(&zz);
				comp_delete(&z1);
				comp_delete(&z2);
                                if (real_compare(R, ma, h2) == -1)
                                        {
                                        real_delete(&ma);
                                        ma = real_incref(h2);
                                        }
                                if (real_compare(R, mi, h2) == 1)
                                        {
                                        real_delete(&mi);
                                        mi = real_incref(h2);
                                        }
                                real_delete(&h2);
                                }
                        }
                }
        if (thue_print_level(th) >= 3)
                {
                printf("T_max = ");real_write(R, ma, 20);puts("");
                printf("T_min = ");real_write(R, mi, 20);puts("");
                }
        T = real_divide(R, ma, mi);
        real_delete(&ma);
        h1 = real_log(R, T);
	real_delete(&T);
        h3 = conv_int_to_real(R, 1);
        h2 = real_add(R, h1, h3);
        real_delete(&h1);
        real_delete(&h3);
        c5 = real_add(R, h2, c3);
        real_delete(&h2);
	ring_delete(&C);

        return c5;
}
