*
*DOC  INCLUDE-FILE (NUMBER FIELD TOOLS)
*
*                                                        (JS 11.11.87)
*
*                 Einfuehrung von  FIELD7       JS 07.06.88
*                 FINIR4                        JS 22.07.88
*                 GALOIS und FIELD8             JS 21.09.88
*                 JOBNAM                        JS 17.10.88
*                 RITBER                     FS/JS 15.12.88
*                 Torsionseinheiten (EXFLAG(4)) JS 21.12.88
*                 EXFLAG(10) hat keine Bedeutung mehr  JS 16.01.89
*                 EXFLAG(5)                     JS 19.01.89
*                 FINIR4 verbessert             JS 31.01.89
*                 RIEHYP implemented            JS 01.07.89
*                 OUTFLG implemented            BA/FS 12.07.89
*                 English documentation         JS 25.07.89
*                 ERRMSG                     MJ/JS 14.08.89
*                 FLEDIM/FLENRS in FIELD4       JS 23.08.89
*                 TIMSET, TIMBND and TIMSTT     JS 08.02.90
*                 FLDFLG                     MJ/JS 12.02.90
*                 PURE, CYCLOT and PI        MJ/JS 15.02.90
*                 MUFLAG                  AS/MJ/JS 21.03.90
*                 FLDNR and CG*                 JS 10.04.90
*                 Maintenance of main programs  FS 30.07.90
*                 LZRFLG                        FS 23.11.90
*                 SHLFLG                        JS 07.03.91
*                 TSTFL1,TSTFL2,TSTSUB          JS 12.06.91
*
************************************************************************
*  Part 1: Declarations
************************************************************************
*
*     MAXDIM: maximal possible field degree
*     RADIX : Logarithm of base 2 of MAXINT+1
*     MAXMAT: maximal dimension of scratch arrays in subroutines
*
      INTEGER MAXDIM,MAXMAT,RADIX
      PARAMETER (MAXDIM=20,MAXMAT=50,RADIX=32)
*
*     MAXINT: maximal possible INTEGER*4 (usually 2**31-1)
*     EPS   : Values below EPS are treated as zero
*     LOGEPS: natural logarithm of EPS
*     MAXDP : maximal (as REAL*8) exact representable integer
*     FINITY: maximal representable DP-number
*     FINIR4: maximal representable  REAL*4-number
*     PI    : pi
*
      REAL FINIR4
      DOUBLE PRECISION MAXINT,EPS,MAXDP,FINITY,LOGEPS,RNLGRX,PI
      PARAMETER (MAXINT=2147483647.0D0,MAXDP=1.0D14,EPS=1.0D-14)
      PARAMETER (LOGEPS=-0.3223619D+02,FINITY=0.7237D+76)
      PARAMETER (FINIR4=0.99999E+38)
      PARAMETER (PI=3.14159265358979D0)
*
*     F     : coefficients of minimal polynomial, declining and without
*             leading coefficient
*     DISC  : field discriminant, INTEGER (=0 if too big)
*
      INTEGER F(MAXDIM), DISC
*
*     ROOTSF: roots of F, first NS real ones, then NT real parts, then
*             NT imaginary parts
*     RDISC : field discriminant, DP
*
      DOUBLE PRECISION ROOTSF(MAXDIM), RDISC
*
*     CROOTS: Zeroes of F, "complex" representation
*
      DOUBLE PRECISION CROOTS(2,MAXDIM)
*
*     EXFLAG: Flags for indicating the existence of field invariants
*             EXFLAG( 1)= 0  :  no integral basis known
*             EXFLAG( 1)= +-1:  integral basis equal to power basis
*             EXFLAG( 1)= +-2:  integral basis not equal power basis
*             EXFLAG( 1)< 0  :  ITB is an integral basis if all prime divisors
*                               of the index are below 10**5.
*             EXFLAG( 2)= 0  :  (and EXFLAG(3)=0) no system of units
*             EXFLAG( 2)= NR :  complete system of independent units in FUNIT
*             EXFLAG( 2)=-NR :  logarithms of FUNIT in FUNLOG
*             EXFLAG( 3)= NR :  (and EXFLAG(2)=0) the units are stored in LFUNIT
*             EXFLAG( 4)= 0  :  Number of torsion units is not known
*             EXFLAG( 4)> 0  :  Number of torsion units
*             EXFLAG( 5)= 0  :  The units are perhaps not fundamental
*             EXFLAG( 5)= NR :  The units are fundamental units
*             EXFLAG( 6)<>0  :  The Galois group structure is known
*             EXFLAG( 7)<>0  :  The Class group structure is known
*                   
*     FLDFLG:  if = 0: Field was read and initialized in normal way
*                 = 1: Complete field data was read from file
*     PURE  :  if = 0: the field is no pure field
*                 > 0: it is
*     CYCLOT:  if = 0: the field is a cyclotomic field
*                 = K: the field is the k-th cyclotomic field
*     FLDNR:           serial number of field (e.g. for FORD data)
*
      INTEGER FLDFLG, PURE, CYCLOT, FLDNR
*
*     EXFDIM:  maximal dimension of EXFLAG
*     EXFNUM:  number of relevant EXFLAG's (for all programs)
*
      INTEGER EXFDIM, EXFNUM
      PARAMETER ( EXFDIM=50, EXFNUM=10)
      INTEGER EXFLAG(EXFDIM)
*
*     N     : field degree
*     NS    : number of real zeroes of F
*     NT    : half the number of non-real zeroes of F
*     NR    : unit rank = NS+NT-1
*     NST   : NS + NT
*     NP1   : N + 1
*     NM1   : N - 1
*     NSP1  : NS + 1
*     NP2   : N + 2
*
      INTEGER N, NS, NT, NR, NST, NP1, NM1, NSP1, NP2
*
*     ITB   : transition matrix from power basis to integral basis, 
*             denominators of each column in row NP1
*     CDEN  : lcm of the denominators
*     INVITB: inverse matrix to ITB
*
      INTEGER ITB(MAXDIM+1,MAXDIM), CDEN, INVITB(MAXDIM,MAXDIM)
*
*     REDRHO: reduction table for powers of a zero of F
*     MUTAB : multiplication table for integral basis elements
*             MUTAB(k,i,j) is the k-th coefficient of omega(i)*omega(j)
*     MUFLAG: if =0: MUTAB exists
*                >0: File number of scratch file where MUTAB is stored
*
      INTEGER MUTAB(MAXDIM,MAXDIM,MAXDIM),REDRHO(MAXDIM,MAXDIM-1),MUFLAG
*
*     RITB  : basis for Minkowski lattice of the principal order
*             RITB(J,I) = the J-th conjugate of the I-th basis element (1<=i<=NS)
*             RITB(J,I) + i*RITB(J+NT,I) = the conjugate of the I-th basis
*                                          element (NS<I<=NT)
*             RITB(J,I) - i*RITB(J+NT,I) = the conjugate of the I-th basis
*                                          element (NT<I<=N)
*     RITBER: Error of RITB
*
      DOUBLE PRECISION RITB(MAXDIM,MAXDIM)
      DOUBLE PRECISION RITBER(MAXDIM,MAXDIM)
*
*     DUALB : inverse of RITB (dual base)
*     ABSDUA: absolute values of dual basis elements
*
      DOUBLE PRECISION DUALB(MAXDIM,MAXDIM),ABSDUA(MAXDIM,MAXDIM)
*
*     FUNIT : coefficients of independent resp. fundamental units
*             last column: coefficients of a generator of torsion subgroup
*
      INTEGER FUNIT(MAXDIM,MAXDIM)
*
*     REG   : regulator
*     REGLBD: lower regulator bound
*     FUNLOG: logarithms of absolute values of units
*     FUNCON: conjugates of units
*
      DOUBLE PRECISION REG,FUNLOG(MAXDIM,MAXDIM),FUNCON(MAXDIM,MAXDIM)
      DOUBLE PRECISION REGLBD
*                                  
*
*  Class Group structure
*
*     CGH   : class number
*     CGCYC : number of cyclic factors of class group
*     CGORD : orders of factors
*     CGIDN : number of prime ideals used
*     CGID  : table of prime ideals
*     CGIDXP: exponents of prime ideals for each generator
*
      INTEGER CGH, CGCYC, CGORD(MAXDIM)
      INTEGER CGIDN, CGID(-1:MAXDIM,MAXDIM), CGIDXP(MAXDIM,MAXDIM)
*
*     IER   : error parameter, =0 if everything OK, else <>0
*     DNRIER: file number for error outputs
*     DNRINP: file number for standard input
*     DNROUT: file number for standard output
*     INIFLG: controlling flag for output of initialized values
*     TSTFLG: controlling flag for output of intermediate data
*     TSTFL1: primary TSTFLG
*     TSTFL2: alternative TSTFLG (for name list of TSTSUB)
*     RIEHYP: =0 (default if GRH is not assumed, else: 1)
*     OUTFLG: =1 ((Output in COMOUT)
*     PRECIS: =10 for long computation of the zeroes LROOTF and LRITB
*                (default, else: 0)
*
      INTEGER IER,DNRIER,DNRINP,DNROUT,INIFLG,TSTFLG,RIEHYP,OUTFLG
      INTEGER PRECIS,TSTFL1,TSTFL2
*
*     TIMSET: if > 0: time limitation controlling is active
*               else: controlling deactivated
*     TIMBND: Bound for time controlling
*     TIMSTT: Start of controlling
*     LZRFLG: Flag for long zeroes
*
      INTEGER TIMSET, LZRFLG
      DOUBLE PRECISION TIMBND, TIMSTT
*
*     parameters only for internal use:
*
*     LVLPTR: zeigt die aktuelle Verschachtelungsebene an
*     ERRFLG: =1, falls gerade eine Fehlermeldung ausgegeben wurde, sonst 0
*     DLEVEL: Debug-Level fuer Unterprogrammstatistik u.a.
*     ENDLUT: aktuelle Anzahl der in SUBLUT gespeicherten Unterprogrammnamen
*     SUBPTR: zeigt auf den aktuellen Unterprogrammnamen
*     SUBCNT: zaehlt die Anzahl der Aufrufe der Unterprogramme
*
      INTEGER LVLPTR,ERRFLG,DLEVEL,ENDLUT,SUBPTR,SUBCNT(200)
*
*     SUBTIM: akkumuliert die Rechenzeit der einzelnen Unterprogramme
*     SUBTI1: Hilfsfeld fuer Aufrufzeitstatistik
*
      DOUBLE PRECISION SUBTIM(200),SUBTI1(100)
*
*     SUBNAM: beinhaltet die aktuelle Verschachtelung
*     SUBLUT: Look-Up-Table mit Unterprogrammnamen
*
      CHARACTER*6 SUBNAM(100),SUBLUT(200)            
*
*     FLEDIM: maximal number of possible scratch files
*     FLENRS: scratch file organisation array
*     SHLFLG: >0: Programs are called by Kant-Shell
*
      INTEGER FLEDIM, FLENRS(2,20)
      INTEGER SHLFLG
*
*     AIZERO: representation of 0 (as an algebraic integer)
*     AIONE : representation of 1 (as an algebraic integer)
*
      INTEGER AIZERO(MAXDIM+1),AIONE(MAXDIM+1)
*
*     PRMFLE: name of prime number file
*     FILExx: Names of other files
*     JOBNAM: Name of Job
*     ERRMSG: actual error message
*     TSTSUB: List of subroutine names to be tested with TSTFL2
*
      CHARACTER*60 PRMFLE,FILE01,FILE02,FILE03,JOBNAM
      CHARACTER*120 ERRMSG,TSTSUB
*     
*     GALGRP: Structure of Galois group
*
      CHARACTER*6 GALGRP
*
*
************************************************************************
*     main programs
************************************************************************
*
*     MAXMP:  maximal number of main programs
*     NUMMP:  number of main programs
*     IERMP:  IER-parameter for the main programs
*
      INTEGER MAXMP, NUMMP, INDXMP, IERMP
      PARAMETER (MAXMP=50)
*
      CHARACTER*6    NAMEMP(MAXMP)
      CHARACTER*80   STR1MP(MAXMP)
      CHARACTER*10   EXFLMP(MAXMP)
*
*
*
************************************************************************
*  Part 2: COMMON-statements
************************************************************************
*
*                     Field data
*
      COMMON /FIELD0/ F, ROOTSF, CROOTS, DISC, RDISC, EXFLAG, FLDFLG,
     *                PURE, CYCLOT, FLDNR
*
*                     
*
      COMMON /FIELD1/ N, NS, NT, NR, NST, NP1, NM1, NSP1, NP2
*
*  
*
      COMMON /FIELD2/ ITB, CDEN, INVITB, RITB, MUTAB, REDRHO,
     *                DUALB, ABSDUA, RITBER, MUFLAG
*
*
*
      COMMON /FIELD3/ FUNIT,REG,FUNLOG,FUNCON,REGLBD,
     *                CGH, CGCYC, CGORD, CGIDN, CGID, CGIDXP
*
*                     DEBUGGING tools
*
      COMMON /FIELD4/ IER,DNRIER,LVLPTR,ERRFLG,DLEVEL,ENDLUT,SUBPTR,
     *                SUBCNT,SUBTIM,SUBTI1,DNRINP,DNROUT,INIFLG,TSTFLG,
     *                RIEHYP,OUTFLG,FLEDIM,FLENRS,PRECIS,
     *                TIMSET,TIMBND,TIMSTT,LZRFLG,SHLFLG,
     *                TSTFL1,TSTFL2
*
*         
*
      COMMON /FIELD5/ SUBNAM,SUBLUT
*
*                     constants
*
      COMMON /FIELD6/ AIZERO,AIONE
*
*                     file & job names & error message
*
      COMMON /FIELD7/ PRMFLE, FILE01, FILE02, FILE03, JOBNAM, ERRMSG,
     *                TSTSUB
*
*                     Galois group
*
      COMMON /FIELD8/ GALGRP
*
*
************************************************************************
*    main programs
************************************************************************
*
      COMMON /MAIN1/  IERMP, NUMMP, INDXMP
*
      COMMON /MAIN2/  STR1MP, NAMEMP, EXFLMP
*
*END
