      SUBROUTINE SECOND(T)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        S E C O N D                             *
C     *                                                                *
C     ******************************************************************
*
*DOC             returns used CPU time in second
**DOC
*INDEX  SECOND(IN/1): used CPU Time in Seconds
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine returns the used CPU time. To compute the used
**DOC       time of a routine you have to call SECOND twice and compute
**DOC       the difference.
**DOC       This routine is dependent on the system.
**DOC
**DOC                Siemens 7.580-S:
**DOC                   FOR1:       COMOPT FPOOL = FOR1.FPOOL
**DOC                   TSOSLNK:    RESOLVE ,FOR1.FPOOLLIB
**DOC
**DOC                SUN 3/60:
**DOC                   T = DBLE(ETIME())   (ETIME is REAL*4)
**DOC
**DOC                apollo DN3000:
**DOC                   T wird in Vielfachen von 4 Mikrosekunden
**DOC                   (0.000004 sec.) geliefert.
**DOC
**DOC                VAX:
**DOC                   CALL GETTIME(C)
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       T       (DP)     CPU time in seconds
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC          GEPRT
**DOC       APOLLO DN3000:
**DOC          CAL_$GET_LOCAL_TIME(CLOCK)
**DOC          CAL_$FLOAT_CLOCK(CLOCK,T)
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC                APOLLO DN3000:
C*SYS*ANF*APOLLO*
%INCLUDE  '/sys/ins/cal.ins.ftn/'
C*SYS*END*APOLLO*
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       24.11.86
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       01.09.87
**DOC       JS       08.06.88  MINU instead MIN
**DOC       US       21.02.89  APOLLO DN3000
**DOC       US       19.07.89  *SYS*.*7580-S*
**DOC       US       24.08.89  CENTI IN MASM FUER IBMMS
**DOC       US       20.10.89  VAX
**DOC       US       25.10.89  CONVEX
**DOC       US       12.02.90  Namen der Include-files in lower case
**DOC       JS       01.03.91  etime for SUN
**DOC       JS       12.06.91  etime(XFOO)
**DOC
C*SYS*ANF*APOLLO*
      INTEGER STD,MINU,SEC,ZTDL
      INTEGER*2 CLOCK(3)
      DOUBLE PRECISION T
      CHARACTER*100 DUMMY
C
      CALL CAL_$GET_LOCAL_TIME(CLOCK)
      CALL CAL_$FLOAT_CLOCK(CLOCK,T)
C*SYS*END*APOLLO*
*
C*SYS*ANF*SUN*
C      REAL etime,XFOO
C      T = DBLE(etime(XFOO)) 
C*SYS*END*SUN*
*
C
C*SYS*ANF*7580-S*
C      INTEGER STD,MINU,SEC,ZTDL
C      INTEGER*2 CLOCK(3)
C      DOUBLE PRECISION T
C      CHARACTER*100 DUMMY
CC
C      CALL GEPRT(STD,MINU,SEC,ZTDL,DUMMY)
CC
C      T = DBLE(ZTDL + 10000*(SEC + 60*(MINU + 60*STD)))/10000.0D0
C*SYS*END*7580-S*
C
C*SYS*ANF*VAX*
C      DOUBLE PRECISION T
CC
C      CALL GETTIME(T)
C*SYS*END*VAX*
C
C*SYS*ANF*CADMUS*
C      DOUBLE PRECISION T
CC
C      T = DBLE(MCLOCK())
C*SYS*END*CADMUS*
C
C*SYS*ANF*CONVEX*
C      DOUBLE PRECISION T
CC
C      T = 0.0D0
C*SYS*END*CONVEX*
C
C*SYS*ANF*ATARI*
CC>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CC-----------------------------------------------------------------------
CC     ANFANG VERSION:  A T A R I  S T - COMPUTER
CC-----------------------------------------------------------------------
CC.... SCALAR ARGUMENTS .................................................
C      DOUBLE PRECISION  T
CC
CC.... LOCAL SCALARS ....................................................
C      INTEGER           IT
CC
CC
C      CALL MILLIE(IT)
CC
C      T = DBLE(IT) / 200.0D0
CC
CC-----------------------------------------------------------------------
CC     DIE  A T A R I - VERSION BENOETIGT FOLGENDES ASSEMBLERPROGRAMM:
CC-----------------------------------------------------------------------
CC
CC*----------------------------------------------------------------------
CC* MILLISEKUNDEN DES SYSTEM-TIMERS HOLEN
CC* LITERATUR:  ST INTERN  S. 146 UND 324
CC*----------------------------------------------------------------------
CC
CC        XDEF    MILLIE
CC
CC        SECTION .CODE
CC
CCMILLIE
CC
CC*----------------------------------------------------------------------
CC* IN DEN SUPERVISOR-MODUS UMSCHALTEN
CC*----------------------------------------------------------------------
CC
CC        CLR.L   -(SP)                      * USER- WIRD SUPERV.-STACK
CC        MOVE.W  #$20,-(SP)                 * SUPER AUFRUFEN
CC        TRAP    #1                         * SUPERV.-MODUS AKTIVIEREN
CC        ADD.L   #6,SP                      * D0 = ALTER SUPERV. STACK
CC        MOVE.L  D0,USER                    * WERT MERKEN
CC
CC*----------------------------------------------------------------------
CC* FORTRAN ARGUMENT HOLEN
CC*----------------------------------------------------------------------
CC
CC        MOVEA.L 4(SP),A1                   * ADRESSE ARGUMENT HOLEN
CC        MOVE.L  A1,-(SP)                   * ADRESSE AUF DEN STACK
CC
CC*----------------------------------------------------------------------
CC* SYSTEMVARIABLE _HZ_200 VON ADRESSE $4BA HOLEN
CC*----------------------------------------------------------------------
CC
CC        MOVE.L  ($4BA),D0                  * WERT AN D0 UEBERGEBEN
CC
CC*----------------------------------------------------------------------
CC* ERGEBNIS AN DAS FORTRAN-ARGUMENT UEBERGEBEN
CC*----------------------------------------------------------------------
CC
CC        MOVE.L  (SP),A1                    * ADRESSE WIEDER NACH A1
CC        MOVE.L  D0,(A1)                    * D0 UEBERGEBEN
CC        ADDQ.L  #4,SP                      * STACK 'AUFRAEUMEN'
CC
CC*----------------------------------------------------------------------
CC* ZURUECK IN DEN USER-MODUS
CC*----------------------------------------------------------------------
CC
CC        MOVE.L  USER,-(SP)                 * ALTEN SUPERV. STACKPOINTER
CC        MOVE.W  #$20,-(SP)                 * SUPER AUFRUFEN
CC        TRAP    #1                         * JETZT WIEDER IM USER-MODE
CC        ADD.L   #6,SP                      * AUFRAEUMEN
CC
CC*----------------------------------------------------------------------
CC* ZURUECK ZU FORTRAN
CC*----------------------------------------------------------------------
CC
CC        MOVE.L  (SP)+,A0                   * CALLERS LINK
CC        ADDA.L  #4,SP                      * ARGUMENT VOM STACK
CC        JMP     (A0)                       * ZURUECK ZU FORTRAN
CC
CC*----------------------------------------------------------------------
CC* SPEICHERPLAETZ RESERVIERUNG
CC*----------------------------------------------------------------------
CC
CCUSER    DC.L    0                          * SPEICHERPLATZ USERSTPTR.
CC
CC*----------------------------------------------------------------------
CC* FERTIG
CC*----------------------------------------------------------------------
CC
CC        END
CC
CC-----------------------------------------------------------------------
CC     ENDE VERSION:  A T A R I  S T - COMPUTER
CC-----------------------------------------------------------------------
CC<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C*SYS*END*ATARI*
*
C*SYS*ANF*IBMMS*
CC>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CC----------------------------------------------------------------------
CC     ANFANG VERSION:  I B M     M S - F O R T R A N 7 7
CC----------------------------------------------------------------------
CC.... SCALAR ARGUMENTS ................................................
C      DOUBLE PRECISION  T
CC
CC.... LOCAL SCALARS ...................................................
C      INTEGER*2         STUND,MINU,SEKU,HUNSTL
CC
C      CALL CENTI(STUND,MINU,SEKU,HUNSTL)
CC
C      T = DBLE(100*(60*(60*STUND+MINU)+SEKU)+HUNSTL)/100.0D0
CC
CC----------------------------------------------------------------------
CC     DIE  I B M M S - VERSION BENOETIGT FOLGENDES ASSEMBLERPROGRAMM:
CC     (ASSEMBLER: MICROSOFT MASM)
CC----------------------------------------------------------------------
CC;         TITLE        CENTI
CC;
CCGETS      SEGMENT      'CODE'
CCPUBLIC    CENTI
CCCENTI     PROC         FAR
CC          PUSH         BP
CC          MOV          BP,SP
CC;
CC          MOV          AH,2CH
CC          INT          21H
CC;
CC          LES          BX,DWord Ptr 18[BP]
CC          MOV          AX,0
CC          MOV          AL,CH
CC          MOV          ES:[BX],AX
CC;
CC          LES          BX,DWord Ptr 14[BP]
CC          MOV          AX,0
CC          MOV          AL,CL
CC          MOV          ES:[BX],AX
CC;
CC          LES          BX,DWord Ptr 10[BP]
CC          MOV          AX,0
CC          MOV          AL,DH
CC          MOV          ES:[BX],AX
CC;
CC          LES          BX,DWord Ptr 6[BP]
CC          MOV          AX,0
CC          MOV          AL,DL
CC          MOV          ES:[BX],AX
CC;
CC          POP          BP
CC          RET          16
CC;
CCCENTI     ENDP
CCGETS      ENDS
CC;
CC          END
CC----------------------------------------------------------------------
CC     ENDE VERSION:  I B M     M S - F O R T R A N 7 7
CC----------------------------------------------------------------------
CC<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C*SYS*END*IBMMS*
*
      RETURN
*
      END
