#ifndef _DEBUG_E_
#define _DEBUG_E_

#include "defs.h"

/*
 *	Exported prototypes
 */

extern t_logical debug_find_flag P_((t_char*,t_int *));
extern t_void debug_number_dump P_((void));
extern t_void debug_print P_((t_handle,t_handle,t_int,t_logical));
extern t_void f_assert();

/* 
 *	Macros to access the debug flags.
 */

extern Int debug[];
extern t_logical debug_flags[];

#define v3_df				((Logical *)&debug[0 - 1])
#define DEBUG_FLAG(x)	debug_flags[(t_int)(x)]

#undef IF_DEBUG_FLAG
#ifdef DEVELOP
#define IF_DEBUG_FLAG(x,y)		if( DEBUG_FLAG((x))) { y; }
#else
#define IF_DEBUG_FLAG(x,y)		/* nothing */
#endif

#define DEBUG_PRINT(s,e,it,f)	debug_print((s),(e),(it),(f))

/*
 *	V4 debug flags.
 */

enum 
{
	/* entries 0 -> 51 are used by the v3_df[] array */
	DEBUG_START_FLAGS = 52,
	DEBUG_ALG = 52,
	DEBUG_BIND,
	DEBUG_CONSTR,
	DEBUG_COMMAND,
	DEBUG_EVAL,
	DEBUG_EXPR,
	DEBUG_FRAME,
	DEBUG_INIT,
	DEBUG_INTERP,
	DEBUG_INTRINSIC,
	DEBUG_LEX,
	DEBUG_MAIN,
	DEBUG_PARSE,
	DEBUG_PROGRAM,
	DEBUG_STMT,
	DEBUG_SYMBOL,
	DEBUG_TREE,
	DEBUG_TIME,
	DEBUG_VARARG,
	DEBUG_WALK,
	DEBUG_CHSTR,
	DEBUG_SHOW_EXTRAS,
	DEBUG_MODPOLY_GCD,
	DEBUG_MODPOLY_INTERPOLATE,
	DEBUG_MODUPOLY_FACT,
	DEBUG_MODUPOLY_FACT_B1,
	DEBUG_MODUPOLY_FACT_B2,
	DEBUG_MODUPOLY_FACT_B2_SMALL,
	DEBUG_MODUPOLY_FACT_B2_LARGE,
	DEBUG_MODUPOLY_FACT_B3,
	DEBUG_MODUPOLY_FACT_B4,
	DEBUG_MODUPOLY_FACT_B4_SMALL,
	DEBUG_MODUPOLY_FACT_B4_LARGE,
	DEBUG_MODUPOLY_D_POWER_REM,
	DEBUG_LLL_INT_Q_REDUCE,
	DEBUG_MLLL_INT_Q_REDUCE,
	DEBUG_LLL_INT_D_REDUCE,
	DEBUG_MLLL_INT_D_REDUCE,
	DEBUG_ESEQ,
	DEBUG_ESET,
	DEBUG_UNDEF,
	DEBUG_GF,
	DEBUG_TUPLE,
	DEBUG_LOOKUP,
	DEBUG_ECART,
	DEBUG_BLOCKS,
	DEBUG_PROCESS,
	DEBUG_MAP,
	DEBUG_CURRENT,
	DEBUG_STRUCTURE,
	DEBUG_CONTEXT,
	DEBUG_GRP_PERM,
	DEBUG_MAT,
	DEBUG_GRP_MAT,
	DEBUG_BSGS,
	DEBUG_CODE,
	DEBUG_GRAPH,
	DEBUG_EDGE,
	DEBUG_VERTEX,
	DEBUG_BASE_CHANGE,
	DEBUG_BACKTRACK,
	DEBUG_CENTRAL,
	DEBUG_CLASS,
	DEBUG_POLY,
	DEBUG_CHTR,
	DEBUG_DBASE,
	DEBUG_OPNAMES,
	DEBUG_KANT,
	DEBUG_MP,
	DEBUG_NUM_FLAGS
};

#endif /* _DEBUG_E_ */
