/* 
   ideal1.c
  
   JS September 1991                                         Version 18.03.92
 
   Test program for ideals
 
   - Initialization of a pure order over Z
   - Input of two algebraic numbers
   - Norm of these numbers (and gcd of norm) regardless of denominators
   - creating an ideal generated by these two numbers
   - conversion into Z-Basis and norm of ideal   
*/

#include "kant.h"        
 
main(
)
{
	block_declarations;         
 
	order		ord, z;
	char		str[200];
	integer_small	deg;
	integer_big	a, norm, norma, normb, gcd, den;
	anf_elt	  	alpha, beta;
	anf_ideal  	id;


/*  Initialization of environment */
   
        kant_start();
 
/*  We create Z as first order */
 
	z = m_z_str_incref(structure_z);

	printf("Give print-level and degree!\n");
	scanf("%d %d", &anf_print_level, &deg); gets(str);
	printf("Give a!\n"); gets(str);	a = integer_read(str);  

	ord = order_create_pure(z, a, deg);
	 
	for (;;)
	{
		printf("Give first algebraic number:\n");
		alpha = anf_elt_read(ord);
		if(alpha == -1) break;
 
		printf("Give second algebraic number:\n");
		beta = anf_elt_read(ord);
		gets(str);
 
		printf("norm of alpha:  "); 
		anf_norm(ord, alpha, &norma, &den);
		integer_write(norma);
                printf("\n");

		printf("norm of beta:  "); 
		anf_norm(ord, beta, &normb, &den);
		integer_write(normb);
                printf("\n");
 
		printf("gcd:  "); 
		gcd = integer_gcd(norma, normb);
		integer_write(gcd);
                printf("\n");
 
		integer_delref(gcd);
		integer_delref(norma);
		integer_delref(normb);
 
                id = anf_ideal_2_create(ord, alpha, beta);

		printf("\nIdeal:\n");
		anf_ideal_2_write(ord, id);
                printf("\n");
 		 
		anf_ideal_2_z(ord, id);
		printf("\n=\n");
		anf_ideal_z_write(ord, id);
 
		printf("\nnorm:\n");
		anf_ideal_norm(ord, id, &norm, &den);
		integer_write(norm);
                printf("\n");
	}
}
