#include <stdio.h>
#include "types.h" 
#include "faclst.e" 
#include "poly_z_faclst.h"
#include "anf.h" 
 
 
main(
)
/*******************************************************************************
 
ideal2.c
  
JS October 1991
Last modification: 18.03.92
 
Test program for factorization of 
   - discriminant
   - prime numbers into prime ideals
  
*******************************************************************************/
{
	block_declarations;
 
	order		ord;
	faclst		facs;
	t_handle		idfacs, rem;
	integer_small	p;
	integer_big	d;
	char		str[200];
 
	kant_start();
 
	while (order_read(&ord))
	{
		order_mult_assure(ord);
		order_disc_calc(ord);
 
		d = integer_abs(order_disc(ord));
 
		integer_lst_factorise
		(d, &facs, &rem, 20, 1000, 262144, 0, 0, 0, 0, d, 0);
 
		printf("\nFactorization of discriminant: ");
		faclst_print(facs); 
		if (rem) printf(" ... with a composite remainder ... ");
		printf("\n");
 
		for (;;)
		{
			printf("Give a prime for factorization:\n");
			scanf("%d", &p);
			if (p < 2) break;
			idfacs = order_prime_factorize(ord, p);
			anf_ideal_faclst_delete(ord, &idfacs);
		}                 
 
 		integer_delref(d);
	}
}
