/* 
   order_arith.c
 
   JS September 1991                                        Version 18.03.92
  
   Test program for 
      - allocating space
      - adding, multiplying and dividing algebraic numbers of pure orders
 
   This main program reads interactively pure orders of the form S = R[s] 
   where s is a root of an algebraic number of the order R. R must be
   initialized before.
   The program automatically initializes the order No. 0 (=Z). For every
   subsequent order the user is asked for 
       - number of ground order
       - extension degree
       - coefficients of algebraic numbers of the ground order
   Then easy arithmetics can be performed by typing in the number
   of the order to compute in, and two algebraic numbers. These numbers
   then will be added and multiplied.
 
History:
 
	92-03-24 JS   	anf_elt_equal
	91-09-10 JS   	first version
*/

#include "kant.h"
 
  
main(
)
{
	block_declarations;         
  
	order		ords[10], ord, ordcoef;
	anf_elt		alpha, beta, gamma, gamma1;
	char		str[200];
	integer_small	cnt;
	integer_small	i, j, isub, deg;

/*  Initialization of environment */
   
        kant_start();
 
/*  We create Z as first order */
 
	ords[0] = m_z_str_incref(structure_z);
  
	printf("Give number of additional orders:\n");
 	scanf("%d", &cnt); 
 
/*  Creating additional orders via primitive elements.
    anf_elt_read automatically allocates space for the deg-th power
    of the generator, so this space has to be freed again by anf_elt_delete.
    Once the number is read we can call order_create_pure which 
    initializes a pure order (and also its multiplication table). */
 
        for (i=1; i<=cnt; ++i) 
	{
 	  	printf("Creating pure order No. %d...\n",i);
		printf("Give number of suborder (< %d), ",i);
		printf("relative degree and algebraic number of suborder!\n");
		scanf("%d %d", &isub, &deg); 
		alpha = anf_elt_read(ords[isub]); gets(str);
    
		ords[i] = order_create_pure(ords[isub], alpha, deg);
 	  	printf("Order No. %d initialized.\n",i);
                anf_elt_delete(ords[isub], &alpha);
	} 
        
	for (;;)
	{
		printf("Give number of order and two algebraic numbers:\n");
		scanf("%d", &i); 
		if (i < 0) break;
		ord = ords[i];
	        ordcoef = order_coef_order(ord);
		
		alpha = anf_elt_read(ord);
		beta  = anf_elt_read(ord);
		gets(str);
        
                if (anf_elt_equal(ord, alpha, beta))
                        puts("These numbers are equal.");
                else
                        puts("These numbers are not equal.");
                     
		printf("Sum: "); 
		gamma = anf_add(ord, alpha, beta);
		anf_elt_write(ord, gamma);
                printf("\n");
		anf_elt_delete(ord, &gamma);
  
		printf("Product: "); 
		gamma = anf_mult(ord, alpha, beta);
		anf_elt_write(ord, gamma);
                printf("\n");
		anf_elt_delete(ord, &gamma);       
 
		if (ring_type(ord) == RING_Z) continue;
 
		if (ring_type(ordcoef) == RING_Z)
		{
			printf("Quotient: "); 
			gamma = anf_div(ord, alpha, beta);
			anf_elt_write(ord, gamma);
	                printf("\n");
			anf_elt_delete(ord, &gamma);       
		}			
	}
}
