

//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : coeff_sparse_power_serie.h
// Author      : Frank Lehmann (FL), Markus Maurer (MM) 
// Last change : FL/MM, Oct 2 1995, initial version
//



#ifndef POWER_SERIE_SPC__H
#define POWER_SERIE_SPC__H


#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:lidia.h>
#include <LiDIA:arith.inl>

#else
#include <LiDIA/lidia.h>
#include <LiDIA/arith.inl>
#endif


// **************************************************************************
// *
// *    class name :  spc< T >
// *
// **************************************************************************


 template < class T >  class spc
  {
     public  :

        T     	     coeff ;
        lidia_size_t exp   ;

     int coeff_cmp_zero ( const spc< T > & b ) const;
     void swap ( spc< T > & b );



     public :

     // 
     // ***** constructors / destructor *****
     //

     spc ( ) { }
     spc ( const T & c , lidia_size_t e ) { coeff = c ; exp = e ; }
     ~spc ( ) { }


     //
     //  *****  I/O - operators  *****
     //

     void read  (istream & in);
     void print (ostream & out) const;

     inline friend 
     istream & 
     operator >> ( istream & in, spc< T > & c )
      {c.read(in); return in;}

     inline friend 
     ostream & 
     operator << ( ostream & out, const spc< T > & c )
      {c.print(out); return out;}


     //
     //  *****  assignment operator   *****
     //

     const spc< T > & operator = ( const spc< T > & c );


     //
     //  *****  comparison operators  *****
     //

     int operator < ( const spc< T > & c ) const;
     int operator <= ( const spc< T > & c ) const;
     int operator == ( const spc< T > & c ) const;
     
     inline friend 
     int 
     coeff_cmp_zero ( const spc< T > & a, const spc< T > & b )
      {return (a.coeff_cmp_zero(b));}

     inline friend
     void
     swap ( spc< T > & a, spc< T > & b )
      {a.swap(b);}

 } ;


#ifdef LIDIA_INCLUDE_C
#include <LiDIA/coeff_sparse_power_serie.c>
#endif

#endif
