//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : dense_matrix.h
// Author      : Patrick Theobald (PT)
// Last change : PT, Jun 16, 1996, initial version
//             

/*
$Id: dense_matrix.h,v 1.4 1996/10/25 01:04:57 lidiaadm Exp $
*/

#ifndef LIDIA_DENSE_MATRIX_H
#define LIDIA_DENSE_MATRIX_H

/**
 ** PRINT MODE SETTINGS 
 **/

#define BEAUTY_MODE       0
#define LIDIA_MODE        1
#define GP_MODE           2
#define MAPLE_MODE        3
#define MATHEMATICA_MODE  4
#define KASH_MODE	  5
#define LATEX_MODE	  6

#define DEFAULT_PRINT_MODE      BEAUTY_MODE 

/**
 ** STORAGE MODE SETTINGS
 **/

#define REPRESENTATION		3
#define DENSE_REPRESENTATION	1
#define SPARSE_RESPRESENTATION  2
#define	MIXED_REPRESENTATION    3

#define ORIENTATION		4
#define ROW_ORIENTED		0
#define COLUMN_ORIENTED		4

#define DEFAULT_STORAGE_MODE	DENSE_REPRESENTATION|ROW_ORIENTED

/**
 ** STRUCTURE MODE SETTINGS
 **/

#define DIAG			1
#define UPPER_DIAG		2
#define	LOWER_DIAG		4
#define UPPER_TRIA		8
#define LOWER_TRIA		16
#define COLUMNS_LININD		32
#define ROWS_LININD		64

#define DEFAULT_STRUCTURE_MODE	0

/**
 ** INFO MODE SETTINGS (Position der Diagonalen)
 **/

#define DIAG_UP			1
#define DIAG_RIGHT		4
#define DIAG_LD_TO_RU		8

#define DEFAULT_INFO_MODE	0

/**
 ** LATTICE MODE SETTINGS
 **/

#define DEFAULT_LATTICE_MODE       0

template < class T >
class dense_matrix
{
// MM
#ifdef __GNUG__
protected:
#else
public:
#endif
  
  lidia_size_t rows;
  lidia_size_t columns;
  
  T **value;
  
  unsigned long print_mode;
  unsigned long storage_mode;
  unsigned long structure_mode;
  unsigned long info_mode;
  unsigned long lattice_mode;
};

#endif






