//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : error.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_ERROR_H
#define LIDIA_ERROR_H

typedef void (*error_handler_ptr)(const char *, const char *);

extern error_handler_ptr lidia_error_handler;
extern void default_error_handler(const char *, const char *);
extern error_handler_ptr set_error_handler(error_handler_ptr);

#if !defined(HAVE_LEDA)
#define error_handler(f, m) lidia_error_handler(f, m)
#endif

#define error_handler_c(f, m, code) { code; lidia_error_handler(f, m); }
#define lidia_error_handler_c(f, m, code) { code; lidia_error_handler(f, m); }

#endif
