
//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995, 1996 by the LiDIA Group
//
// File        : divisors.c
// Author      : Markus Maurer
// Last change : MM, Sep 26 1996, initial version
//

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:bigint.h>
#include <LiDIA:rational_factorization.h>
#include <LiDIA:sort_vector.h>
#else
#include <LiDIA/bigint.h>
#include <LiDIA/rational_factorization.h>
#include <LiDIA/sort_vector.h>
#endif



/* file: divisors.c */

extern void h_divisors     (sort_vector<bigint> & div, rational_factorization & f, int flag = 0);
extern void h_all_divisors (sort_vector<bigint> & div, rational_factorization & f, int flag = 0);

extern sort_vector<bigint> divisors (rational_factorization & f);
extern sort_vector<bigint> divisors (const bigint & N);

extern sort_vector<bigint> all_divisors (rational_factorization & f);
extern sort_vector<bigint> all_divisors (const bigint & N);

extern sort_vector<bigint> square_free_divisors (rational_factorization & f);
extern sort_vector<bigint> square_free_divisors (const bigint & N);

extern sort_vector<bigint> all_square_free_divisors (rational_factorization & f);
extern sort_vector<bigint> all_square_free_divisors (const bigint & N);

extern sort_vector<bigint> square_divides_n_divisors (rational_factorization & f);
extern sort_vector<bigint> square_divides_n_divisors (const bigint & N);

extern sort_vector<bigint> all_square_divides_n_divisors (rational_factorization & f);
extern sort_vector<bigint> all_square_divides_n_divisors (const bigint & N);
