

//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : is_prime_appl.c 
// Author      : Oliver Morsch (OM)
// Last change : OM, Mar 1996, initial version
//		 MM, Sep 24 1996, inserted and modified
//		 some cout's
//

#include<LiDIA/bigint.h>
#include<LiDIA/timer.h>

int main()
{
  bigint a, p;
  bigint r;
  timer T;

  cout << "Computing Square Roots r of a mod p,\n";
  cout << "where p is a prime and 0 <= a < p.\n";
  cout.flush ();

  while(1)
    {
      cout << "\n\n";
      cout << "RESSOL: please enter a: ";
      cin >> a;
      cout << "        please enter p: ";
      cin >> p;

      T.start_timer();
      ressol_p (r, a, p);
      T.stop_timer();

      cout << "        square root of " << a << " mod " << p;
      cout << " is " << r << "\n";
      cout << "        Time: " << T;
    }
}
