/******************************************************************************
 ** LiDIA's Temporary Variable Manager
 ** Original Author: Ralf Dentzer
 ** Rewritten By: Thomas Papanikolaou
 ** Copyright (c) by the LiDIA Group
 ** All rights reserved
 *****************************************************************************/

/**
 ** We test the use of temporary variables which are immediatelly released
 ** at the end of a block. MM is much faster since it uses free lists and
 ** do not actually release memory the whole time.
 **/

#include "mm.h"
#include <stdlib.h>

void 
mm_random_alloc_test(max)
	long            max;
{
	char           *s;
	long            len_s;
	long            len_t;
	long            t;
	long            i;

	fprintf(stderr, "\ndoing %8ld allocs/dels using %22s in",
		max, "malloc/free");
	t = clock();
	t = clock();
	for (i = 0; i < max; i++) {
		len_t = len_s = abs(random()) & 0x1fffff;
		s = (char *) malloc(len_s);
		free(s);
	}
	t = clock() - t;
	fprintf(stderr, " %ld ns", t);
}

void 
mm_random_mm_alloc_test(max)
	long            max;
{
	char           *s;
	long            len_s;
	long            t;
	long            i;

	fprintf(stderr, "\ndoing %8ld allocs/dels using %22s in",
		max, "mm_malloc/mm_free");
	t = clock();
	t = clock();
	for (i = 0; i < max; i++) {
		len_s = abs(random()) & 0x1fffff;
		s = mm_malloc(len_s);
		mm_free(s);
		/* mm_free_with_size(s, len_s); */
	}
	t = clock() - t;
	fprintf(stderr, " %ld ns", t);
}

int 
main(argc, argv)
	int             argc;
	char           *argv[];
{
	long            l;
	if (argc == 2)
		l = atol(argv[1]);
	else
		l = 100000;
	mm_random_alloc_test(l);
	mm_random_mm_alloc_test(l);
	mm_statistics();
	mm_collect();
	mm_statistics();
	fprintf(stderr, "\n");
	return 0;
}
