//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : indexed_hash_table_appl.c
// Author      : Michael Jacobson, Jr. (MJ)
// Last change : MJ, September 24, 1996
//

#include <LiDIA/indexed_hash_table.h>

bigint
ikey(const int & G) { return bigint(G); }

main()
{
  indexed_hash_table < int > IHT,IHT2;
  int i,x,*y;
  lidia_size_t j;

  IHT.initialize(20);
  IHT.set_key_function(&ikey);

  cout << "#buckets = " << IHT.no_of_buckets() << "\n";
  cout << "current size = " << IHT.no_of_elements() << "\n\n";

  for (i=0; i<30; ++i) 
    IHT.hash(i);
  for (i=-50; i>-60; --i)
    IHT.hash(i);

  cout << "\ncurrent size = " << IHT.no_of_elements() << "\n";
  x = IHT.last_entry();
  cout << "last entry = " << x << "\n";
  y = IHT.search(x);
  if (y)
    cout << "search succeeded!  Last entry is in the table.\n";
  else
    cout << "search failed!  Please report this bug!\n";

  cout << "\nsequential access:\n";
  for (j=0; j<20; j+=5)
    cout << "element " << j << " = " << IHT.member(j) << "\n";
  for (j=20; j<=35; j+=5)
    cout << "element " << j << " = " << IHT[j] << "\n";

  cout << "Contents of IHT:\n";
  cout << IHT << "\n";

  cout << "\ncopying...\n\n";
  IHT2 = IHT;
  cout << "contents of new table:\n";
  cout << IHT2 << "\n";
  cout << "#buckets = " << IHT2.no_of_buckets() << "\n";
  cout << "current size = " << IHT2.no_of_elements() << "\n\n";

  cout << "remove_from function...\n";
  for (j=35; j>=0; j-=5) {
    cout << "remove element " << j << " = " << IHT2.member(j) << "\n";
    IHT2.remove_from(j);
  }
  cout << "remove function...\n";
  for (i=7; i<50; i+=7) {
    cout << "remove " << i << "\n";
    IHT2.remove(i);
  }
  cout << "contents of new table:\n";
  cout << IHT2 << "\n";
  cout << "#buckets = " << IHT2.no_of_buckets() << "\n";
  cout << "current size = " << IHT2.no_of_elements() << "\n\n";


  cout << "emptying it...\n";
  cout << "contents of new table:\n";
  IHT2.empty();
  cout << IHT2 << "\n";
  cout << "#buckets = " << IHT2.no_of_buckets() << "\n";
  cout << "current size = " << IHT2.no_of_elements() << "\n\n";
}
