/* file plet.c */
#include "def.h"
#include "macro.h"

#ifdef PLETTRUE

#ifdef SCHURTRUE
#define LENGTH 100
#define DEPTH 100
#include <memory.h> /* for memcpy (3C) */
#endif

#ifdef DGUX
#define signed
#endif  /* DGUX */

#ifdef sun
#define signed
#endif 
#ifdef hpux
#define signed
#endif 
/* CC 25/09/91. 4 FUNCTIONS DEFINED IN PLET.C ARE INCLUDED IN def.h:

plet_complete_schur WHICH COMPUTES S_n(S_I).

plet_elementary_schur WHICH COMPUTES L_n(S_I).

l_plet_complete_schur WHICH COMPUTES THE TERMS OF S_n(S_I) LESS THAN lng.

l_plet_elementary_schur WHICH COMPUTES THE TERMS OF L_n(S_I) LESS THAN lng.*/


static INT plethysm();
static INT calcul();
static INT operer();
static INT conjug();
static INT  cmmp();


struct  liste {
     INT  coef;
     signed char  *tab;
     struct  liste  *suivant;
         };
struct monomial{
   int degree;
   unsigned indice;
   struct liste *resultat;
   struct monomial *suivant;
   };


signed char gv,booo,gvr,lng;


/* CMMP returns 1 to insert*/

static INT  cmmp(a,b) OP a,b;
{return (-1L);}


/*CONJUGUE  takes a partition its length and  conjugates it */

static INT conjug(tab,j,ve)
/* tab is a partition j its length */
	signed char *tab; signed char j; OP  ve;
{
  signed char *btab;
  signed char mid,temp,high,i,k;

  btab = tab+j;
  mid = *btab;
  m_il_v( (INT) mid,ve);
  k = (signed char) 0;
  j++;
  temp = 0;
  while(j >=  (signed char) 0)
  {
    high = 0;
    while(*btab == mid)
    {
      j--;
      high++;
      if(j == 0)
      {
        j--;
        break;
      }
      btab--;
    }
    temp = temp+high;
    if(j == -1)
      i = 0;
    else
      i = *btab;
    for(;i < mid;i++)
    {
      M_I_I( (INT)temp , S_V_I( ve,(INT)k ) );
      k++;
    }
    mid = *btab;
  }
}




static INT operer(n,ttp,deg,baf,cof,liste,parite)
	signed char n,ttp,deg,*baf,parite;
	struct liste *liste;
	INT cof;

{
  signed char np,cond,si,v,tv,k,tp,var,first;
  register signed char j,jn,temp;
  signed char *s,*init,*tabn,*st,*af,*bs,*binit,*btabn,*bab,*bobo;
  static struct liste *liste3p;
  struct liste *liste1,*liste2,*liste3;
  static signed char *obo;


/* The succesive "buf" which come are ordered; The search in "liste" begins
 at its first pointed element if buf is the first pointed element of
 "bp" in calcul (gv = 0) or begins in at the element pointed by liste3p if
 not */

  first = (signed char)0;
  if(gv == 0)
  {
    liste3 = liste;
    gv = 1;
  }
  else
    liste3 = liste3p;
  si = sizeof(struct liste);

  /*j is the length of baf; instead of this: strlen(baf)*/

  j = 0;
  bab = baf;
  while(*baf != '\0')
  {
    baf++;
    j++;
  }
  /*The maximal length of the new terms will be less than or equal to np;
    tmp is a useful variable giving the difference of length*/

  tp = ttp - j;
  np = j + (deg * n);

  /*Allocation of four different tableaux*/

  s = (signed char *)malloc(np + 1);
  init = (signed char *)malloc(np + 1);
  af = (signed char *)malloc(np + 1);
  tabn = (signed char *)malloc(deg + 1);

  /*Init is the initial Schur function we want multiply by the monomial
  function indexed by n*/

  binit = init;
  for(jn = 0;jn < np - j;jn++)
    *binit++ =  jn + tp;
  baf = bab;
  for(jn = 0;jn < j;jn++)
    *binit++ =  *baf++ + (deg * n);
  *binit = 0;

  /* s is the tableau result of the product; tab is the tableau giving the
  position of the parts which are incremented*/

  temp = np - 1;

  if(booo == 1)
  {
    binit = init + temp;
    first = 1;
    for(jn = temp; jn >= 0; jn--)
    {
      if(((*binit) + n - tp - temp) <= lng)
        break;
      if(jn != 0)
        binit--;
    }
    binit = init;
    bs = s;
    for(temp = 0; temp <= jn - deg;temp++)
      *bs++ = *binit++;
    for(;temp < jn;temp++)
      *bs++ = *binit++ + n;
    for(; temp < np;temp++)
      *bs++ = *binit++;
    *(tabn + deg - 1) = jn + 1;
    if(j < deg)
      j = deg;
    tp = j;
    var = deg - 1;
    goto et1;
  }
  else
  {
    jn = np - deg;
    binit = init + jn;
    baf = tabn;
    bs = s + jn;

    for(;jn <=  temp;jn++)
    {
      *baf++ =  jn;
      *bs++ =  *binit++ + n;
    }
    *baf = 0;
    *bs = 0;
    bs = s;
    binit = init;
    for(jn = 0;jn < np - deg;jn++)
      *bs++ =  *binit++;
    if(j < deg)
      j = deg;
    tp = j;
    liste2 = liste3->suivant;
    if(liste2 != NULL)
    {

  /*The Schur function result of the product must be put in a structure liste
  which is not empty. The real result is st which is an offset of s*/

      st = (signed char *)malloc(j + 1);
      baf = st;
      temp = np - j;
      bs = s + temp;
      for(jn = temp;jn < np;jn++)
        *baf++ = *bs++ ;
      *baf = 0;

      while(liste2 != NULL)
      {

      /*Is the Schur function in liste? As the cofactor is ordered, the result
      must not be very far in the liste*/

        /* Position on the last part of the partition for the liste: bab
        for the result:bs*/

        temp = -1;
        bab = liste2->tab;
        while(*bab != '\0')
        {
          bab++;
          temp++;
        }

      cond = 0;
      bab = (liste2->tab) + temp;

      bs = st + j - 1;

      /* The comparaison*/

      for(jn = temp;jn >=  0;jn--)
      {
        if(*bs < *bab)
        {
          cond = -1;
          break;
        }
        else if(*bs > *bab)
        {
          cond = 1;
          break;
        }
        bs--;
        bab--;
      }

      /*The result of the comparaison*/

      if(cond > 0)

      /*Stop of the comparaison for insertion*/

        break;

      else if(cond == 0)
      {
      /*The Schur function is already in the liste*/

        liste2->coef += (cof * parite);

        if(liste2->coef == 0L)
        {
        /*the coefficient of the Schur function is null: Supression*/

          liste1 = liste2->suivant;
          free(liste2->tab);
          free((signed char *)liste2);
          liste3->suivant = liste1;
          liste2 = liste1;
        }
        else
        {
          liste3 = liste2;
          liste2 = liste2->suivant;
        }
        free(st);
        /*the comparaison is ended*/

        break;
      }

     /*End of if cond == 0*/

      else
      {
      /*In this case the comparaison go on*/

        liste3 = liste2;
        liste2 = liste2->suivant;
      }
    }

    /*End of while liste2 != NULL*/

    if (cond != 0)
    {
    /*Insertion*/

      liste1 = (struct liste *)malloc(si);
      liste1->tab = st;
      liste1->suivant = liste2;
      liste1->coef = cof * parite;
      liste3->suivant = liste1;
      liste3 = liste1;
    }

    /*The first product from the next cofactor will be after the product st
    in the pointed liste*/

    liste3p = liste3;

    /* Gordan's algorithm starts trying to add n to the part indexed by
    tabn[0]-1*/

    *tabn -= 1;
    s[np - deg] = s[np - deg] - n;

    for(;;)
    {
      while((v = tabn[0]) >=  0)
      {
      /*To try to add the leftest part n of the monomial function*/

        if(((np - v) > lng) && (booo == 0))
        /*If the result has its length bigger than lng, go out the loop*/

          break;
        tv = s[v] + n;
        for(jn= v+1;jn< np;jn++)
          if(tv == s[jn])
          /*If two parts are equal, try to put n to another place*/

            break;
        if(jn == np)
        {
        /*Build the vector result in af; af is not ordered*/

          baf = af;
          bs = s;
          for(jn= 0;jn< v;jn++)
            *baf++ =  *bs++;
          *baf++ =  tv;
          bs++;
          for(jn= v+1;jn< np;jn++)
            *baf++ =  *bs++;
          *baf = '\0';

          /*We reorder the vector into a partition*/

          tv = parite;


          for(k = n /2;k > 0;k /= 2)

            for(jn = k;jn< np;jn++)

              for(j = jn-k;((j >=  0) && (af[j] > af[j+k]));j -= k)
              {
                tv = -tv;
                temp = af[j];
                af[j] = af[j+k];
                af[j+k] = temp;
              }
          /*j is the length of the partition less one; v is np-v i.e.
          the number of parts which are null*/

          if(tp < np - v)
            j = np - v - 1;
          else
          {
            v = np - tp;
            j = tp - 1;
          }

            if(first == 1)
            {
              if(gvr == 0)
              {
                gvr = 1;
                liste3 = liste;
              }
              else
              {
                temp = strlen(obo);
                bobo = obo + (temp - 1);
                baf = af + np - 1;
/*                liste3 = liste;*/
                if(np < temp)
                  temp = np;
                for(;temp > 1; temp--)
                {
                  if(*bobo > *baf)
                  {
                    liste3 = liste3p;
                    break;
                  }
                  else if(*bobo < *baf)
                  {
                    liste3 = liste;
                    break;
                  }
                  bobo--;
                  baf--;
                }
                if (temp == 1)
                {
                  if(*bobo > *baf)
                    liste3 = liste3p;
                  else
                    liste3 = liste;
                }
                free(obo);
              }
              temp = j + 1;
              obo = (signed char *)malloc(temp + 1);
              bobo = obo;
              baf = af + v;
              for(jn = 0;jn < temp;jn++)
                *bobo++ = *baf++;
              *bobo = 0;

              liste2 = liste3->suivant;

            }

          /*It is the same search than before: is the Schur function af in
          the liste*/

          if (liste2 == NULL)
            cond = 1;

          while(liste2 != NULL)
          {
            temp = -1;
            bab = liste2->tab;
            while(*bab != '\0')
            {
              bab++;
              temp++;
            }
            bab = (liste2->tab) + temp;

            baf = af + np - 1;

            cond = 0;

            if(temp > j)
              temp = j;

            for(jn = temp;jn>=  0;jn--)
            {
            /*Comparaison*/

              if(*baf < *bab)
              {
                 cond = -1;
                 break;
              }
              else if(*baf > *bab)
              {
                cond = 1;
                break;
              }
              baf--;
              bab--;
            }
            if(cond > 0)
              break;
            else if(cond == 0)
            {
              if(tv == -1)
                liste2->coef -= cof;
              else
                liste2->coef += cof;

              if(liste2->coef == 0L)
              {
                liste1 = liste2->suivant;
                free(liste2->tab);
                free((signed char *)liste2);
                liste3->suivant = liste1;
                liste2 = liste1;
              }
              else
              {
                liste3 = liste2;
                liste2 = liste2->suivant;
              }

              break;
            }

         /*End  of if cond == 0*/

            else
            {
              liste3 = liste2;
              liste2 = liste2->suivant;
            }
          }

          /*End of while liste2 == NULL*/

          if (cond != 0)
          {
          /*Insertion*/

            liste1 = (struct liste *)malloc(si);
            liste3->suivant = liste1;
            j++;

            /*The Schur function is put in the liste*/

            bab = (signed char *)malloc(j+1);
            liste1->tab = bab;
            baf = af + v;
            for(jn= 0;jn< j;jn++)
              *bab++ =  *baf++;
            *bab = '\0';
            liste1->coef = tv * cof;
            liste1->suivant = liste2;
            liste3 = liste1;
          }

          /*End of cond != 0*/
        if(first == 1)
        {
          first = 0;
          liste3p = liste3;
        }

        }
        /*End of jn == np*/

        tabn[0]--;
      }
      /*End of the while tabn[0]>= 0*/
      var = 1;
et1:      for(jn= var;jn< deg;jn++)
      {
      /*To put all the indexes of the monomial function except the
      leftest one*/

        bab = tabn + jn;
        if((v = *bab ) != jn)
        {
        /*Shift left still the jn index of the monomial function which is
        at the position v*/

          binit = init + v;
          baf = s + v;
          *baf = *binit;
          for(j = jn;j >=  0;j--)

          /*Try to put the index j of the monomial function*/

            for(;;)
            {
              v--;
              binit--;
              baf--;
              if((j > v) || ((booo == 0) && ((np + j - v) > lng)))

              /*It is impossible to put the jn leftest indexes of the monomial
               function; try to put more than jn indexes*/

                goto boucle1;
              else
              {
              /*Shift*/

                tv = *binit + n;
                if(np <= v + n)
                  temp = np;
                else
                  temp = v + n + 1;
                bs = s + v;
                for(k = v+1;k < temp;k++)
                {
                  bs++;
                  if(tv == *bs)
                  {
                  /*Impossible to shift the index j at position v:
                   try to put at v-1*/

                    *baf = *binit;
                    break;
                  }
                }
                if(k == temp)
                {
                /*Succeed in shifting*/

                  *bab-- = v;
                  *baf = *binit + n;
                  break;
                }
              }
            }
          /*After succeeding  in shifting, build a new tableau s*/

          bs = s;
          binit = init;
          for(k = 0;k <=  v;k++)
            *bs++ =  *binit++;
          break;
        }
        boucle1: ;
      }
      if(jn== deg)
        break;
    }
    /*End of the loop for(;;) corresponding to Gordan's algorithm*/
  }
  else
  {
  /*It seems to the preceeding loop except that there is not ordering*/

    liste2 = (struct liste *)malloc(si);
    liste3->suivant = liste2;
    liste2->suivant = NULL;
    liste2->coef = cof * parite;
    bs = s + (np - j);
    bab = (signed char *)malloc(j + 1);
    liste2->tab = bab;
    for(jn = 0;jn < j;jn++)
      *bab++ = *bs++;
    *bab = 0;
    liste3 = liste2;
    liste2 = NULL;
    liste3p = liste3;

    tabn[0]--;
    s[np - deg] = s[np - deg] - n;

    for(;;)
    {
      while((v = tabn[0]) >=  0)
      {
        if(((np - v) > lng) && (booo == 0))
          break;
        tv = s[v] + n;
        for(jn = v + 1;jn < np;jn++)
          if(tv == s[jn])
            break;
          if(jn == np)
          {
            baf = af;
            bs = s;
            for(jn = 0;jn < v;jn++)
              *baf++ = *bs++;
            *baf++ =  tv;
            bs++;
            for(jn = v+1;jn < np;jn++)
              *baf++ =  *bs++;
            *baf = '\0';
            tv = parite;

            for(k = n /2;k > 0;k /= 2)

              for(jn = k;jn < np;jn++)

                for(j = jn-k;((j >=  0) && (af[j] > af[j+k]));j -= k)
                {
                  tv = -tv;
                  temp = af[j];
                  af[j] = af[j+k];
                  af[j+k] = temp;
                }
            liste2 = (struct liste *)malloc(si);
            if(tp < np - v)
              j = np - v;
            else
            {
              v = np - tp;
              j = tp;
            }

            baf = af + v;
            btabn = (signed char *)malloc(j + 1);

            liste2->tab = btabn;
            while(*baf != '\0')
              *btabn++ =  *baf++;
            *btabn = '\0';
            if(first == 1)
            {
              first = 0;
              liste3p = liste3;
            }
            liste2->coef = tv * cof;
            liste2->suivant = NULL;
            liste3->suivant = liste2;
            liste3 = liste2;

          }
        tabn[0]--;
      }
      for(jn = 1;jn < deg;jn++)
      {
      /*It is the same loop that in the case liste2!= NULL*/

        btabn = tabn + jn;
        if((v = *btabn) != jn)
        {
          binit = init + v;
          baf = s + v;
          *baf = *binit;
          for(j = jn;j >=  0;j--)

            for(;;)
            {
              v--;
              binit--;
              baf--;
              if((j > v) || ((booo == 0) && ((np + j - v) > lng)))
                goto boucle2;
              else
              {
                tv = *binit + n;
                if ( np <= v + n )
                  temp = np;
                else
                  temp = v + n + 1;
                bs = s + v;
                for(k = v+1;k < temp;k++)
                {
                  bs++;
                  if(tv == *bs)
                  {
                    *baf = *binit;
                    break;
                  }
                }
                if(k == temp)
                {
                  *btabn-- = v;
                  *baf = *binit+n;
                  break;
                }
              }
            }
          bs = s;
          binit = init;
          for(k = 0;k <=  v;k++)
            *bs++ =  *binit++;
          break;
        }
        boucle2: ;
      }
      if(jn == deg)
        break;
    }
  }
  }
  free(s); free(tabn); free(af); free(init);
}



static INT calcul(tab,n,ch,dep,cofe,parite,p)
	signed char *tab,*ch,parite,p,n;
	INT cofe;
	struct liste *dep;

/*calcul makes the product of the Schur function "ch" by the plethysm
L"tab" J"n" ; the final determinant is in dep*/

{
  signed char mx,boo,boo1,boo2,*btab;
  register i,j,k;
  INT cof;
  signed char np,in,jn,v,tv,ttp,tp,tp1,var,first;
  signed char si,sim,deg,max;
  signed char *binit,*bs,*s,*init,*tabn,*btabn,*baf,*af;
  signed char lg;
  unsigned vr,av,bvr,tvr,ttvr,tttvr,atvr;
  struct liste *liste,*liste1,*liste2,*liste3,*bp;
  struct monomial stmn,*mn,stmn1,*mn1,*bmn;

  /* lg is the length of the partition tab (strlen(tab))*/

  btab = tab;
  first = 0;
  lg = 0;
  while(*btab != 0)
  {
    btab++;
    lg++;
  }

  /* max (resp. deg) is the weight (resp. length) of the partition ch*/

  max = 0;
  deg = 0;
  btab = ch;
  while(*btab != 0)
  {
    deg++;
    max += *btab++;
  }
  btab = tab;
  mx = *btab;


  if((n != p) && (lg == 1))
  {
    gv = 0;

    btab = ch;
    i = max - deg;
    while(*btab != 0)
    {
      *btab += i;
      btab++;
      i++;
    }
    operer(n,max,mx,ch,cofe,dep,parite);
  }
  else
  {
    /*In the stucture monomial, there are the different determinants of order i,
    i between 1 and lg determinants taken on the i first columns*/

    mn = &stmn;
    mn->suivant = NULL;
    si = sizeof(struct liste);
    sim = sizeof(struct monomial);
    vr = 1;

    if(lg != 1)
      boo = 1;
    else
      boo = parite;
    for(k = mx;((k > mx - lg) && (k > 0));k--)
    {
    /*The calculus of all the determinants of the first column, except may be
    the product of the plethysm L0Jn (=1) by ch.*/

      if(lg != 1)

      /*The determinant is of order bigger than 1: the is put in a liste*/

        liste = (struct liste *)malloc(si);
      else

      /*The determinant is of order 1: the result is returned in dep, argument
      of the function calcul*/

        liste = dep;

      /*The program in the loop "for(k = mx;((k > mx - lg) && (k > 0));k--)"
       is the Gordan's formula to compute the determinants in the first column:
       see this algorithm in operer*/

      liste->suivant = NULL;
      np = (n * k) + deg;
      tp1 = max - deg;

      s = (signed char *)malloc(np + 1);
      init = (signed char *)malloc(np + 1);
      af = (signed char *)malloc(np + 1);
      tabn = (signed char *)malloc(k + 1);

      baf = ch;
      binit = init;
      for(in = 0;in < np - deg;in++)
          *binit++ = in + tp1;
      for(;in < np ;in++)
        *binit++ = *baf++ + in + tp1;
      *binit = 0;
      if(booo == 1)
      {
        first = 1;
        binit = init + np - 1;
        for(i = np - 1; i >= 0; i--)
        {
          if(((*binit) + n - tp1 - np ) < lng)
            break;
          if(i != 0)
            binit--;
        }
        bs = s;
        binit = init;
        for(jn = 0; jn <= i-k;jn++)
          *bs++ = *binit++;
        for(;jn < i;jn++)
          *bs++ = *binit++ + n;
        for(; jn < np;jn++)
          *bs++ = *binit++;
        *(tabn + k - 1) = i + 1;
        j = deg;
        if(j < k)
          j = k;
        var = k - 1;
        goto et3;
      }
      else
      {
        bs = s ;
        binit = init;
        btabn = tabn;
        for(in = 0;in < np - k; in ++)
          *bs++ = *binit++;
        for(; in < np; in++)
        {
          *bs++ = *binit++ + n;
          *btabn++ = in;
        }
        *btabn = 0;
        *bs = 0;

        j = deg;
        if(j < k)
          j = k;

        liste2 = (struct liste*)malloc(si);
        if(lg != 1)
          liste2->coef = 1L;
        else
          liste2->coef = boo * cofe;
        bs = s + (np - j);
        btabn = (signed char *)malloc(j + 1);
        liste2->tab = btabn;
        while(*bs != 0)
          *btabn++ =  *bs++ ;
        *btabn = '\0';
        liste2->suivant = NULL;
        liste->suivant = liste2;

        tabn[0]--;
        s[np - k] = s[np - k] - n;

        for(;;)
        {
          while((v = tabn[0]) >=  0)
          {
            if(((np - v) > lng) && (booo == 0))
              break;
            tv = s[v] + n;
            for(in = v+1;in < np;in++)
              if(tv == s[in])
                break;
            if(in == np)
            {

              baf = af;
              bs = s;
              for(in = 0;in < v;in++)
                *baf++ = *bs++;
              bs = s + v + 1;
              *baf++ =  tv;
              for(in = v+1;in < np;in++)
                *baf++ =  *bs++;
              *baf = '\0';
              tv = boo;

              for(i = n /2;i > 0;i /= 2)

                for(in = i;in < np;in++)

                  for(jn = in-i;((jn >=  0) && (af[jn] > af[jn+i]));jn -= i)

                  {
                    tv = -tv;
                    ttp = af[jn];
                    af[jn] = af[jn+i];
                    af[jn+i] = ttp;
                  }


              bp = (struct liste *)malloc(si);
              if(j < np - v)
               jn = np - v;
              else
              {
                v = np - j;
                jn = j;
              }

              btabn = (signed char *) malloc(jn + 1);
              bp->tab = btabn;
              baf = af + v;
              while(*baf != 0)
                *btabn++ = *baf++;

              *btabn = '\0';
              if(lg != 1)
                bp->coef = tv;
              else
                bp->coef = tv * cofe;
              bp->suivant = NULL;
              if(first == 1)
              {
                first = 0;
                liste2 = liste;
              }
              liste2->suivant = bp;
              liste2 = bp;

            }
            tabn[0]--;
          }
          var = 1;
et3:

        for(in = var;in < k;in++)
        {
          btabn = tabn + in;
          if((v = *btabn) != in)
          {
            binit = init + v;
            baf = s + v;
            *baf = *binit;
            for(jn = in;jn >=  0;jn--)

              for(;;)
              {
                v--;
                binit--;
                baf--;
                if((jn > v) || ((booo == 0) && ((np + jn - v) > lng)))
                  goto boucle;
                else
                {
                  tv = *binit+n;
                  if ( np <= v + n )
                    ttp = np;
                  else
                    ttp = v + n + 1;
                  bs = s + v;
                  for(i = v+1;i < ttp;i++)
                  {
                    bs++;
                    if(tv == *bs)
                    {
                      *baf = *binit;
                      break;
                    }
                  }
                  if(i == ttp)
                  {
                    *btabn-- = v;
                    *baf = *binit+n;
                    break;
                  }
                }
              }
            bs = s;
            binit = init;
            for(i = 0;i <=  v;i++)
              *bs++ =  *binit++;
            break;
          }
          boucle: ;
        }
        if(in == k)
          break;
      }
    }
    free(s); free(tabn); free(af); free(init);
    if (lg != 1)
    {
    /*The option is bigger than 0: if the final determinant is not of
    order 1, write the different partial results in the pointed liste of
    type struct monomial: stmn*/

      mn->suivant = (struct monomial *)malloc(sim);
      mn = mn->suivant;
      mn->resultat = liste;

      /*The record indice is used to recognize the different determinants*/

      mn->indice = vr;
      vr = vr << 1;
      mn->degree = k;
      mn->suivant = NULL;
    }

  }
  /*End of the loop for(k = mx;((k > mx - lg) && (k > 0));k--)*/

  if((k == 0) && (k != mx - lg))
  {
  /*To put a determinant of value the partition ch*/

    if(lg != 1)

    /*Not final liste*/

      liste = (struct liste *)malloc(si);
    else

    /*Final liste*/

      liste = dep;
    liste2 = (struct liste *)malloc(si);
    liste->suivant = liste2;

    /*Write the coefficient*/

    if(lg != 1)
      liste2->coef = 1L;
    else
      liste2->coef = boo * cofe;

    /*write the partition*/

    baf = (signed char *)malloc(deg + 1);
    liste2->tab = baf;
    bs = ch;
    for(i = max - deg;i < max ;i++)
      *baf++ = *bs++ + i ;
    *baf = 0;
    liste2->suivant = NULL;

    if(lg != 1)
    {
      mn->suivant = (struct monomial *)malloc(sim);
      mn = mn->suivant;
      mn->resultat = liste;
      mn->indice = vr;
      mn->degree = 0;
      mn->suivant = NULL;
    }

  }
  boo = 1;
  if(lg != 1)
  {
  /*The determinant is of order bigger than 0*/

    vr = 1;
    av = (1 << lg - 1);

    for(i = 1;i < lg;i++)
    {
    /*The algorithm progresses with columns i+1*/

    /*The option is bigger than i: we will write in the structure monomial*/

      if(boo == 1)
      {
      /*The preceeding determinants (of order i ) are in stmn;
       put the determinants ( of order i+1) we are going to compute
       in stmn1*/

        mn = stmn.suivant;
        mn1 = &stmn1;
      }
      else
      {
      /*The preceeding determinants (of order i ) are in stmn1;
       put the determinants ( of order i+1) we are going to compute
       in stmn*/

        mn = stmn1.suivant;
        mn1 = &stmn;
      }
      mn1->suivant = NULL;

      /*All the variables of type unsigned is used to enumerate
      the determinants: for example the determinants of order 2 have
      for indices the characters 00000011, 00000101, 00001001, ...
      where the position of 1 are the rows of the cofactor*/

      av = av | (1 << (lg - i - 1));
      vr = (1 << i) | vr;

      /*vr will be the index of the first determinant of order i+1 we
      compute; for example for the determinants of order 3, vr is 111*/

      tvr = vr;

      btab++;
      mx = *btab;

      for(;;)
      {
      /*CALCUL of the determinant of index tvr*/

        tp = -1;

        if(i != lg - 1)
        {
        /*Not final liste*/

          liste = (struct liste *)malloc(si);
          liste->suivant = NULL;
        }
        else
        /*Final liste*/

          liste = dep;

        boo1 = 0;
        boo2 = 0;
        tv = -1;

        for(in = lg - 1;in >= 0;in--)
        {
        /*Consider the factor which is in the row in + 1, and on the columns
        i + 1*/

          if(tp == i)

          /*The computation of the determinant indexed by tvr is finished*/

            break;
          ttvr = tvr;
          if(((ttvr >> in) & 1) == 0)

          /*The factor is not used in the computation of the determinant indexed
          by tvr*/

            continue;
          ttvr = (1 << in) ^ tvr;
          tp++;
          deg = mx + i - in;
          if(deg < 0)

          /*The factor is null*/

            continue;
          if((deg > lng) && (booo == 0))
            break;

          else
          {
            tv = -tv;
            if(deg == 0)
            {
            /*The factor is equal to 1*/

            /*Read the cofactor from the monomial structure mn*/

              bmn = mn;
              while(bmn != NULL)
              {
                /*Search of the cofactor*/

                if(bmn->indice == ttvr)
                  break;
                bmn = bmn->suivant;
              }
              if(bmn == NULL)

                /*The cofactor is null; it will be the same for the cofactor
                not yet considered: break */

                break;
              boo1 = 1;
              if(boo2 == 0)
              {
              /*the product 'tp1*n' will be the weight of the Schur function
              indexed by tvr*/

                boo2 = 1;
                tp1 = bmn->degree;
              }
              bp = (bmn->resultat)->suivant;

              liste3 = liste;
              liste2 = liste3->suivant;

              while( bp!= NULL)
              {
              /*Copy in liste the cofactor (the factor is equal to one);
               at the beginning liste2 is null; moreover the cofactor is
               already ordered: it is just a copy*/

                liste2 = (struct liste *)malloc(si);
                baf = bp->tab;
                j = 0;
                while(*baf != 0)
                {
                  baf++;
                  j++;
                }
                bs = (signed char *)malloc(j+1);

                /*Write the partition*/

                baf = bp->tab;
                liste2->tab = bs;
                while(*baf != 0)
                  *bs++ = *baf++;
                *bs = 0;

                /*Write the coefficient*/

                liste2->coef = bp->coef * tv;

                liste2->suivant = NULL;
                liste3->suivant = liste2;
                liste3 = liste2;
                bp = bp->suivant;

              }
            }
            /*End of the if deg == 0*/
            else
            {
              gvr = 0;

            /*It is the product by the monomial function indexed by deg and
            its cofactor indexed by ttvr*/


            /* The preceeding result is in the monomial structure bmn*/

              if(boo1 == 1)
              {

              /* The calculus of a determinant has already begun*/

                bmn = bmn->suivant;
              }
              else
              {
                bmn = mn;
              }
              while(bmn != NULL)
              {

              /* It is the search of the cofactor of the monomial indexed
               by deg*/

                if(bmn->indice == ttvr)
                  break;
                bmn = bmn->suivant;
              }
              if(bmn == NULL)

              /*The cofactor is null*/

                break;

              /*The cofactor is not null; boo1 signals that for the next
               step in the calculus of the determinant a product factor
               by cofactor different from 0 has already been*/

              boo1 = 1;
              if(boo2 == 0)
              {

              /* In the first product (boo2 == 0), '(tp1*n)+max', where max
              is the weight of the second partition entered, is the weight
              of the Schur function we are computing*/

                boo2 = 1;
                tp1 = bmn->degree + deg;
              }

              /* bp is the cofactor*/

              bp = (bmn->resultat)->suivant;

              /*ttp is the degree maxi of the cofactor np1 is the degree
              of the product*/

              ttp = (bmn->degree * n) + max;

              /*gv is a global variable to indicate to operer that the
              product begins*/

              gv = 0;

              while(bp != NULL)
              {

              /* operer which makes the product is called for each term
              of the cofactor*/

                cof = bp->coef * tv;
                if(i == lg - 1)
                {
                  cof = cof * cofe;
                  j = parite;
                }
                else
                  j = 1;
                operer(n,ttp,deg,bp->tab,cof,liste,j);
                bp = bp->suivant;
              }

            }
            /*End of deg > 0*/
          }
          /*End of a product factor by cofactor*/
        }
        /*End of the computation of the determinant indexed by tvr*/

        if(liste->suivant == NULL)
          free((signed char *)liste);
        else
        {
          if( i != lg - 1)
          {
          /*i < opt: do not use the files; i!=lg-1: put the liste in the
          structure pointed by mn1*/

            bmn = (struct monomial *)malloc(sim);
            mn1->suivant = bmn;
            mn1 = bmn;
            mn1->suivant = NULL;
            mn1->indice = tvr;
            mn1->degree = tp1;
            mn1->resultat = liste;
          }

        }
        if(av == tvr)

        /*The computation of the determinants of order i+1 is finished: break*/

          break;

        /*tvr will be the index of the next determinant: for example for
        lg+1 = 4,and i+1 = 2, the order for the indexes is the following:
        0011,0101,0110,1001,1010,1100*/

        ttvr = tvr;
        atvr = 0xFFFF;
        tp = 0;
        tp1 = 0;
        bvr = 1;
        while((ttvr & 1) == 0)
        {
          ttvr = ttvr >> 1;
          bvr = (bvr << 1) | 1;
          tp++;
        }
        tttvr = 0;
        tp++;
        tp1++;
        bvr = (bvr << 1 ) | 1;
        ttvr = ttvr >> 1;
        while((ttvr & 1) == 1)
        {
          ttvr = ttvr >> 1;
          tttvr = (tttvr << 1) | 1;
          bvr = (bvr << 1) | 1;
          tp++;
          tp1++;
        }
        ttvr = (1 << tp) | tttvr;
        atvr = atvr << tp;
        tvr = atvr & tvr;
        tvr = tvr | ttvr;
      }

      /*Erase the structure having the last results
      (determinants of order i)*/

      if(boo == 1)
        mn = stmn.suivant;
      else
        mn = stmn1.suivant;

      while(mn != NULL)
      {
        bp = (mn->resultat)->suivant;
        while(bp != NULL)
        {
          free(bp->tab);
          liste = bp;
          bp = bp->suivant;
          free((signed char *)liste);
        }
        mn1 = mn;
        mn = mn->suivant;
        free((signed char *)(mn1->resultat));
        free((signed char *)mn1);
      }

      boo = -boo;
    }
    /* End of the loop for(i = 1 ;i < lg ; i++) */
  }
  /* End of the condition lg != 1 */
}

}


static INT plethysm(m,otab,cond1,ores)
	signed char m,cond1; OP  otab,ores;
{
  OP sc,ve;
  signed char  tab[20];
  signed char  *s,*bs,*btab,*baf,*af,*bch,*tab1;
  signed char  condition,par,parite,mx,np,npt,le,inv;
  INT   cof;
  INT  c;
  signed char  n,in;
  signed char  k;
  signed char  cond,cond2,high,mid;
  register signed char  i,j,temp;
  struct  liste str,*newton,*bp,*liste,*liste1;

for (i=0;i<20;i++) tab[i]=0;

	if (not EMPTYP(ores))
		freeself(ores);
  inv = 0;
  le = (signed char)S_PA_LI(otab);
  if(le > 19)
  {
    fprintf(stderr,"partition too long\n");
    exit(inv);
  }
  btab = tab;
  mx = 0;
  for(c = 0L; c < le; c++)
  {
    *btab = (signed char)S_PA_II(otab,c);
    mx += *btab++;
  }
  if(( le * mx) > 127)
  {
    fprintf(stderr,"too big plethysm for my little structures\n");
    exit(inv);
  }
  *btab = 0;
  cond2 = 0;


  newton = (struct liste *)malloc( (m+1) * sizeof(struct liste) );
  if(*(btab - 1) < le)
  {
    inv = 1;
    tab1 = (signed char *)malloc(*(btab - 1) + 1);
    bs = tab1;
    btab = tab;
    af = (signed char *)malloc(le + 1);
    baf = af;
    while(*btab != 0)
      *baf++ = *btab++;
    *baf = 0;

    cond = -1;
    j = le - 1;
    btab = af + j;
    mid = *btab;
    j++;
    temp = 0;
    while(j >=  0)
    {
      high = 0;
      while(*btab == mid)
      {
        j--;
        high++;
        if(j == 0)
        {
          *btab = 0;
          j--;
          break;
        }
        btab--;
      }
      temp = temp+high;
      for(i = *btab;i < mid;i++)
      {
        cond++;
        *bs++ = temp;
      }
      mid = *btab;
    }
    *bs = 0;
    free(af);
  }
  else
  {
    tab1 = (signed char *)malloc(le + 1);
    btab = tab;
    bch = tab1;
    while(*btab != 0)
      *bch++ = *btab++;
    *bch = 0;
  }

  booo = 0;
  if((( cond2 == 0) && (inv == 0)) || ((cond2 == 1) && (inv == 1)))
    booo = 1;
  if(cond2 == 0)
  {
    if(lng < le)
    {
      fprintf(stderr,"No elements of the length %d in this plethysm\n",m);
      exit(inv);
    }
  }
  else
    if(lng < *(tab + le - 1))
    {
      fprintf(stderr,"No elements of the length %d in this plethysm\n",m);
      exit(inv);
    }


  /* fprintf(stderr,"It goes on\n"); */

  liste1 = &str;

  if ( cond2 == 0)

    if(cond1 == 0)

      if((mx%2 == 0) || ((mx%2 == 1)&&(inv == 1)))
        condition = 0;
      else

        condition = 1;
    else

      if((mx%2 == 0) || ((mx%2 == 1)&&(inv == 1)))
        condition = 1;
      else
        condition = 0;
  else

    if(cond1 == 0)
      if((inv == 0) || ((inv == 1) && (mx%2 == 0)))
        condition = 0;
      else

        condition = 1;
    else
      if((inv == 0) || ((inv == 1) && (mx%2 == 0)))
        condition = 1;
      else

        condition = 0;
      liste = (struct liste *)malloc(sizeof(struct liste));
      liste->coef = 1L;
      liste->suivant = NULL;
      liste1->suivant = liste;
      bs = (signed char *)malloc(1);
      liste->tab = bs;
      *bs = 0;
      (newton)->suivant = liste1->suivant;

/* fprintf(stderr,"1\n"); */
  for(n = 1;n <=  m;n++)
  {
    liste1->suivant = NULL;
	/* fprintf(stderr,"1:n=%d\n",n);*/
    np = n * mx;
    npt = np;
    if( n == 1)
    {
      liste = (struct liste *)malloc(sizeof(struct liste));
      liste->coef = 1L;
      liste->suivant = NULL;
      liste1->suivant = liste;
      if (inv == 0)
      {
	/* fprintf(stderr,"1:inv == 0\n");*/
        bs = (signed char *)calloc(tab[le - 1] + 1,sizeof(char));
        liste->tab = bs;
        btab = tab;
        af = (signed char *)calloc(le + 1,sizeof(char));
        baf = af;
        while(*btab != 0)
          *baf++ = *btab++;
        *baf = 0;

        cond = -1;
        j = le - 1;
        btab = af + j;
        mid = *btab;
        j++;
        temp = 0;
        while(j >=  0)
        {
          high = 0;
          while(*btab == mid)
          {
            j--;
            high++;
            if(j == 0)
            {
              *btab = 0;
              j--;
              break;
            }
            btab--;
          }
          temp = temp+high;
/* fprintf(stderr,"*btab=%d mid = %d\n",*btab,mid); */
          for(i = *btab;i < mid;i++,bs++)
          {
            cond++;  /* fprintf(stderr,"ai=%d",i); */
            *bs = temp; /* fprintf(stderr,"b"); */
		/* bs++; fprintf(stderr,"c"); */
          }
/* fprintf(stderr,"\n");*/
          mid = *btab;
        }
        *bs = 0;
        temp = mx - 1;
        bs--;
        for(i = 0 ;i <= cond; i++)
        {
          (*bs) += temp;
          temp--;
          if(i != cond)
            bs--;
        }
        if(bs == NULL)
          return;
        free(af); 

      }
      else
      {
        liste->tab = (signed char *)malloc(le + 1);
        bs = liste->tab + le;
        *bs-- = 0;
        btab = tab + le - 1;
        temp = mx - 1;
        for(i = 1 ;i <= le; i++)
        {
          *bs  = *btab + temp;
          temp--;
          if(i != le)
          {
            btab--;
            bs--;
          }
        }
      }
    }
    else
    {
      for(in = 0;in < n;in++)
      {

        /*fprintf(stderr,"\nn = %d,in = %d ",n,in);*/

        if(condition == 1)
        {
          i = (n+1+in)%2;
          if(i == 0)
            parite = 1;
          else
            parite = -1;
        }
        else
          parite = 1;


        liste = (newton+in)->suivant;

        while(liste != NULL)
        {
          baf = liste->tab;
          temp = np - npt;
          s = (signed char *)malloc(temp + 1);
          if(temp != 0)
          {
            temp--;
            j = 0;
            while(*baf != '\0')
            {
              j++;
              baf++;
            }

            baf--;
            btab = s + j;
            *btab-- = 0;
            for(k = j-1;k >= 0;k--)
            {
              *btab = (*baf) - temp;
              if(k != 0)
              {
                btab--;
                baf--;
                temp--;
              }
            }
          }
          else
            *s  = '\0';

          cof = liste->coef;
          gvr = 0;

          calcul(tab1,n - in,s,liste1,cof,parite,n);


          free(s); /* AK 181291 */ 
          liste = liste->suivant;
        }
        npt = npt - mx;

      }
    /* End of the loop for (in = 0;in < n ;in++) */
/*fprintf(stderr,"2\n");*/

    }
    liste = liste1->suivant;

    while(liste != NULL)
    {
      liste->coef = liste->coef/n;
      liste = liste->suivant;
    }

    (newton + n)->suivant = liste1->suivant;

  }

  /* End of the loop with n*/
  liste = newton + 1;

  /*START  OF  THE  THIRD  PART  WRITING IN THE LIST ores*/

  for(in = 1;in < m;in++)
  {
    bp = liste->suivant;
    while(bp != NULL)
    {
       free(bp->tab); 
      liste1 = bp;
      bp = bp->suivant;
       free((signed char *)liste1); 
    }
    liste1 = liste;
    liste++;
    /* free((signed char *)liste1);  AK 140192 wg sun */
  }
  bp = liste->suivant;
  k = in * mx;

  while(bp != NULL)
  {
    btab = bp->tab;
    j = -1;
    while(*btab  !=  '\0')
    {
      btab++;
      j++;
    }
    btab--;
    temp = k-1;

    for(i = j;i >=  0;i--)
    {
      (*btab--)  -= temp;
      temp--;
    }

    /*ALLOCATION OF A NEW MEMORY FOR THE VECTOR ve AND THE SCHUR FUNCTION sc.
    THE RESULT ores WILL USE THESE MEMORIES: DON'T MAKE free UPON THEM*/

    sc = callocobject();
    ve = callocobject();
    init(LIST,sc);
    init(VECTOR,ve);
    if(booo == 1)
    {
      conjug( bp->tab , j , ve);
    }
    else
    {
      btab = bp->tab;
      m_il_v( (INT)(j+1), ve );
      for(i = 0; i<=j ;i++)
      {
        M_I_I( (INT)(*btab), S_V_I(ve, (INT) i));
        btab++;
      }
    }
    free(bp->tab);
    m_v_s(ve,sc);

    M_I_I(bp->coef,s_s_k(sc));

    if( emptyp(ores) == TRUE )
      copy(sc,ores);
    else
/* alt AK 111091
      insert(sc,ores,NULL,cmmp);
*/
      insert(sc,ores,NULL,NULL);

    liste1 = bp;
    bp = bp->suivant;
    free((signed char *)liste1);
  }
  /* free((signed char *)liste);  AK 140192 wg sun */
  free(tab1);
  return OK;
}

/*plet_complete_schur COMPUTES S_n(S_I).*/


INT plet_elementary_schur(om,otab,ores) OP  otab,ores,om;
/* CC 011091 */
{
  lng = 127;
  plethysm((signed char)(S_I_I(om)),otab,(signed char)1,ores);
}

INT plet_complete_schur(om,otab,ores) OP  otab,ores,om;
/* CC 011091 */
{
  lng = 127;
  plethysm((signed char)(S_I_I(om)),otab,(signed char)0,ores);
}

INT complete_complete_plet(om,otab,ores) OP  otab,ores,om;
/* CC */
{
	OP c = callocobject();
	m_i_pa(otab,c);
	complete_schur_plet(om,c,ores);
	freeall(c);
	return OK;
}

INT complete_schur_plet(om,otab,ores) OP  otab,ores,om;
/* CC 011091 */
{
	if (nullp(om)) return m_i_i(1L,ores); /* AK 111091 */
	if (negp(om)) return m_i_i(0L,ores); /* AK 111091 */
	return plet_complete_schur(om,otab,ores);
}

/*plet_elementary_schur COMPUTES L_n(S_I).*/

INT elementary_schur_plet(om,otab,ores) OP  otab,ores,om;
/* CC 011091 */
{
	if (nullp(om)) return m_i_i(1L,ores); /* AK 111091 */
	if (negp(om)) return m_i_i(0L,ores); /* AK 111091 */
	return plet_elementary_schur(om,otab,ores);
}

/*l_plet_complete_schur COMPUTES THE TERMS OF S_n(S_I) LESS THAN lng.*/


INT l_plet_complete_schur(olng,om,otab,ores) OP  otab,ores,olng,om;
{
  lng = (signed char)(S_I_I(olng));
  plethysm((signed char)(S_I_I(om)),otab,(signed char)0,ores);
  lng = 127;
}

/*l_plet_elementary_schur COMPUTES THE TERMS OF L_n(S_I)
LESS THAN lng.*/

INT l_plet_elementary_schur(olng,om,otab,ores)
	OP  otab,ores,olng,om;
{
  lng = (signed char)(S_I_I(olng));
  plethysm((signed char)(S_I_I(om)),otab,(signed char)1,ores);
  lng = 127;
}
INT complete_schur_plet_limit(a,b,c,d) OP a,b,c,d;
{
	return l_plet_complete_schur(d,a,b,c);
}
INT elementary_schur_plet_limit(a,b,c,d) OP a,b,c,d;
{
	return l_plet_elementary_schur(d,a,b,c);
}

INT power_schur_plet(jvalu,part,res) OP part,jvalu,res;
/* CC 0589 */ /* AK 181289 V1.1 */
/* AK 200891 V1.3 */
{
	OP a,b,e,f,d,z;
	OP gl = callocobject(); /* global list */

	 signed char i, n,temp,max;
	 signed char *btab,*baf,*af,tab[50];

	if (not EMPTYP(res)) freeself(res);
	if (einsp(jvalu)) { m_pa_s(part,res); return(OK); }

	for(i=0;i<S_PA_LI(part);i++) tab[i]=( signed char)S_PA_II(part,(INT)i);

	n = ( signed char)S_I_I(jvalu);
	temp = 0; btab = tab;

	temp = ( signed char)S_PA_LI(part);
	max = temp * n;

	btab = tab;
	baf = ( signed char *)malloc(max);
		if (baf == NULL) return error(":no mem");
	af = baf;

	for(i = 0; i < max - temp ; i++) { *baf = (n*i)-i; baf++; }
	for(; i < max; i++)
	{ 
		*baf = (n * ((*btab) + i)) - i; 
		baf++; btab++; 
	}
	baf = af;

	b_skn_s(callocobject(),callocobject(),NULL,gl);
	M_I_I(1L,S_S_K(gl));
	b_ks_pa(VECTOR,callocobject(),S_S_S(gl));

	if (max >1) m_il_v((INT)max-1,S_PA_S(S_S_S(gl)));
	else m_il_v(1L,S_PA_S(S_S_S(gl)));

	baf = af;
	if (max>1)baf++;
	if(max > 1)
		for (i=0;i<max-1;i++)
			M_I_I((INT)(*baf++) ,S_PA_I(S_S_S(gl),(INT)i));
	else M_I_I((INT)(*baf++) ,S_PA_I(S_S_S(gl),0L));

	a = callocobject();    /* part 1 */
	b  = callocobject();   /* part 2*/
	d = callocobject();    /* result */
	e = callocobject();    /*limit*/

	b_ks_pa(VECTOR,callocobject(),a);
	b_ks_pa(VECTOR,callocobject(),b);
	if(max>1)
		m_il_v((INT)max-1,S_PA_S(b));
	else
		m_il_v(1L,S_PA_S(b));
	if(max>1)
		for(i=1;i<max;i++)
			M_I_I((INT)(i*n - i ),S_PA_I(b,(INT)i-1));
	else M_I_I(1L,S_PA_I(b,0L));
marke:
	if (not EMPTYP(gl))
		if (S_L_S(gl) != NULL)
		{
			INT zz,kk;
			z = S_S_S(gl);
			kk = max - S_PA_LI(z);
			for (i=0;i<S_PA_LI(z);i++)
			 if (S_PA_II(z,(INT)i) > (INT)(i+kk)*(n-1) ) break;

			m_il_v(S_PA_LI(z)-i,S_PA_S(a));
			for (zz=0;zz<S_PA_LI(a);zz++,i++)
			  M_I_I(S_PA_II(z,(INT)i)-(i+kk)*(n-1),S_PA_I(a,zz));

		}
		else goto ende;
	else goto ende;

	M_I_I((INT)max,e);
	outerproduct_schur_limit(a,b,d,e);
	/*Remove the dominant terms */



	mult (d, S_S_K(gl), d);
	f = callocobject();
	m_skn_s(a,S_S_K(gl),NULL,f);
	add(f,res,res); 
	addinvers(d,f);
/*
	insert(f,gl,add_koeff,NULL);
*/
	insert(f,gl,add_koeff,comp_colex_schurmonom);
	goto marke;

ende:
	freeall(a); freeall(b); freeall(d); freeall(e); free(af);

}




INT schur_schur_plet(a,b,c) OP a,b,c;
/* schurpolyomial with det */ 
/* AK 090790 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j;
	OP d = callocobject();
	OP h = callocobject();
	m_ilih_m(S_PA_LI(a),S_PA_LI(a),d);
	for (i=0L; i<S_PA_LI(a); i++)
		for (j=0L; j<S_PA_LI(a); j++)
			{
			M_I_I(S_PA_II(a,j)+j-i,h);
			complete_schur_plet(h,b,S_M_IJ(d,i,j));
			}
	det_mat_imm(d,c);
	freeall(d); return OK;
}

#endif /* PLETTRUE */

#ifdef PLETTRUE
test_plet()
{
	OP a,b,c;
	a = callocobject();
	b = callocobject();
	c = callocobject();
	printeingabe("test_plet:complete_complete_plet(3L,3L,c)");
	m_i_i(3L,a);
	m_i_i(3L,b);
	complete_complete_plet(a,b,c); 
	println(c);
	printeingabe("test_plet:complete_schur_plet(3L,PARTITION,c)");
	scan(PARTITION,b);
	complete_schur_plet(a,b,c); 
	println(c);
	printeingabe("test_plet:power_schur_plet(2L,PARTITION,c)");
	scan(PARTITION,b);
	power_schur_plet(cons_zwei,b,c); 
	println(c);
	printeingabe("test_plet:schur_schur_plet(PARTITION,PARTITION,c)");
	scan(PARTITION,a);
	scan(PARTITION,b);
	schur_schur_plet(a,b,c); 
	println(c);
	freeall(a);
	freeall(b);
	freeall(c);
}
#endif /* PLETTRUE */
