 
/* 
 * makebuildtime.c - FreeMiNT. 
 * Create buildtime.h. 
 * Author: Guido Flohr <gufl0000@stud.uni-sb.de> 
 * Started: Mon, 30 Mar 1998. 
 */ 
 
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 
#include <time.h> 
#include <errno.h> 
#include <signal.h> 
#include <unistd.h> 
 
#ifdef __STDC__ 
# define P_(param) param 
#else 
# define P_(param) () 
#endif 
 
#define OUTNAME "build.h" 
char* killfile = NULL; 
 
void signal_handler P_((int sigum)); 
 
main(int argc, char* argv[]) 
{ 
  char* myname = argv[0]; 
  time_t then = time (NULL); 
  /* Fixme: Should we use gmtime() instead of local time?  */ 
  struct tm* now = localtime (&then); 
  FILE* out = fopen ("build.h", "wb"); 
  int catchsigs[] = { SIGHUP, SIGINT, SIGQUIT, SIGTERM, -1 }; 
  int i; 
  
  for (i = 0; catchsigs[i] > 0; i++) 
    if (signal (catchsigs[i], signal_handler) != 0) 
      fprintf (stderr, "%s: warning: can't catch signal #%d: %s\n", 
          myname, catchsigs[i], strerror (errno)); 
  
  if (out == NULL) { 
    fprintf (stderr, "%s: error: can't open `%s' for writing: %s\n", 
        myname, OUTNAME, strerror (errno)); 
    return 1; 
  } else 
    killfile = OUTNAME; 
  
  fprintf (out, "\ 
/* Do not edit this file.  It is automatically created.  Edit\n\ 
 * %s instead.\n\ 
 */\n\n", __FILE__); 
  fprintf (out, "\ 
#define BUILD_DAY_OF_WEEK %d\n\ 
#define BUILD_DAY %d\n\ 
#define BUILD_MONTH %d\n\ 
#define BUILD_YEAR %d\n\ 
#define BUILD_HOUR %d\n\ 
#define BUILD_MIN %d\n\ 
#define BUILD_SEC %d\n", 
      now->tm_wday, now->tm_mday, now->tm_mon, now->tm_year + 1900, 
      now->tm_hour, now->tm_min, now->tm_sec); 
  
  if (ferror (out) != 0) { 
    fprintf (stderr, "%s: write error on `%s': %s\n", 
        myname, OUTNAME, strerror (errno)); 
    (void) unlink (OUTNAME); 
    return 1;    
  } 
  
  if (fclose (out) != 0) { 
    fprintf (stderr, "%s: error: can't close `%s': %s\n", 
        myname, OUTNAME, strerror (errno)); 
    (void) unlink (OUTNAME); 
    return 1;    
  } 
  
  return 0; 
} 
 
void signal_handler (int signum) 
{ 
  if (killfile != NULL) 
    (void) unlink (killfile); 
} 
