/* @(#)time.h, mint/freemint
 * file /usr/include/sys/time.h
 * $Id$
 * by jerry g geiger
 *  - jerry@zedat.fu-berlin.de  or jerry@merlin.abacus.de
 */

#ifndef SYS_TIME_H
#define SYS_TIME_H

#define CLOCKS_PER_SEC	(200UL)			  /* clock ticks per second */
#define CLK_TCK         CLOCKS_PER_SEC            /* old name for this */

#ifndef _TIME_T
#define _TIME_T long
typedef long	time_t;
#endif

typedef unsigned long	clock_t;

struct timeval {
	long	tv_sec;		/* seconds, time_t value! */
	long	tv_usec;	/* microseconds */
};

struct timezone {
	/* this structure is not supported, here only for compatibility	*/
	short	tz_minuteswest;	/* minutes west of GMT */
	short	tz_dsttime;	/* daylight savings time correction */
};



/* available std (BSD) functions:
	int	gettimeofday(struct timeval *, struct timezone *);
long Tgettimeofday(struct timeval *, struct timezone *);
	int	settimeofday(struct timeval *, struct timezone *);
long Tsettimeofday(struct timeval *, struct timezone *);
	int adjtime(struct timeval *, struct timeval *);
long Tadjtime(struct timeval *, struct timeval *);

emulated functions:
	clock_t	clock(void);
long Ssystem(GetCLOCKT, clock_t *value);

 */
#endif
/* eof sys/time.h */
