/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableColumnModelEvent;
import com.sun.java.swing.event.TableColumnModelListener;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;
    static /* synthetic */ Class class$com$sun$java$swing$event$TableColumnModelListener;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.setColumnSelectionAllowed(true);
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.recalcWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(n, n);
            }
            tableColumn.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(n);
            this.recalcWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, this.getColumnCount() - 1, 0));
        }
    }

    public void moveColumn(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (n == n2) {
            return;
        }
        TableColumn tableColumn = (TableColumn)this.tableColumns.elementAt(n);
        boolean bl = false;
        if (this.selectionModel.isSelectedIndex(n)) {
            this.selectionModel.removeSelectionInterval(n, n);
            bl = true;
        }
        this.tableColumns.removeElementAt(n);
        this.tableColumns.insertElementAt(tableColumn, n2);
        if (bl) {
            this.selectionModel.addSelectionInterval(n2, n2);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    public void setColumnMargin(int n) {
        if (n != this.columnMargin) {
            this.columnMargin = n;
            this.recalcWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration enumeration = this.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (object.equals(tableColumn.getIdentifier())) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.tableColumns.elementAt(n);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int n) {
        int n2 = 0;
        Point point = new Point(n, 1);
        Rectangle rectangle = new Rectangle(0, 0, 0, 3);
        Enumeration enumeration = this.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle.width = tableColumn.getWidth() + this.columnMargin;
            if (rectangle.contains(point)) {
                return n2;
            }
            rectangle.x += rectangle.width;
            ++n2;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this);
            }
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    ++n3;
                }
                ++n4;
            }
            return n3;
        }
        return 0;
    }

    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : (class$com$sun$java$swing$event$TableColumnModelListener = DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener")), tableColumnModelListener);
    }

    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : (class$com$sun$java$swing$event$TableColumnModelListener = DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener")), tableColumnModelListener);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnAdded(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnRemoved(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnMoved(tableColumnModelEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener"))) {
                ((TableColumnModelListener)objectArray[n + 1]).columnSelectionChanged(listSelectionEvent);
            }
            n -= 2;
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TableColumnModelListener != null ? class$com$sun$java$swing$event$TableColumnModelListener : DefaultTableColumnModel.class$("com.sun.java.swing.event.TableColumnModelListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((TableColumnModelListener)objectArray[n + 1]).columnMarginChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("columWidth".equals(string)) {
            this.recalcWidthCache();
            return;
        }
        if (!"headerValue".equals(string) && !"headerRenderer".equals(string)) {
            "cellRenderer".equals(string);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setLeadAnchorNotificationEnabled(false);
        return defaultListSelectionModel;
    }

    protected void recalcWidthCache() {
        Enumeration enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += ((TableColumn)enumeration.nextElement()).getWidth() + this.columnMargin;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

