/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.ElementInfo;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.tags.TagAppletPanel;

public abstract class BeanDocumentPanel
extends MasterDocumentPanel
implements PropertyChangeListener,
VetoableChangeListener {
    static final String propName = "hotjava";
    private static final String debugProp = "hotjava.debug.BeanDocumentPanel";
    int currentCursor = 0;
    protected Frame parentFrm;
    protected String statusMessage = "";
    protected String errorMessage = "";
    protected String documentTitle = "";
    protected int documentState;
    protected ElementInfo hover;
    private DocListener docListener;

    public BeanDocumentPanel() {
        this.initDefaults();
    }

    public BeanDocumentPanel(BeanDocumentPanel beanDocumentPanel) {
        this.initDefaults();
    }

    protected void initDefaults() {
        this.addDocumentListener(new DocListener());
        this.docListener = new DocListener();
        this.setTopEventListeners(this.docListener, null);
    }

    public void push(DocumentPanel documentPanel, Document document) {
        super.push(documentPanel, document);
    }

    protected void registerInterestIn(Document document) {
        document.addPropertyChangeListener(this);
        document.addVetoableChangeListener(this);
        super.registerInterestIn(document);
    }

    protected void deregisterInterestIn(Document document) {
        document.removePropertyChangeListener(this);
        document.removeVetoableChangeListener(this);
        super.deregisterInterestIn(document);
    }

    public boolean pushInNamedPanel(URL uRL, URL uRL2, String string) {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("documentLoadStatus")) {
            this.setStatusMessage((String)propertyChangeEvent.getNewValue());
            return;
        }
        if (string.equals("documentTitle")) {
            this.setDocumentTitle((String)propertyChangeEvent.getNewValue());
            return;
        }
        if (string.equals("documentError")) {
            this.setErrorMessage((String)propertyChangeEvent.getNewValue());
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
    }

    protected abstract void setStatusMessage(String var1);

    protected abstract void setDocumentTitle(String var1);

    protected abstract void setErrorMessage(String var1);

    protected abstract void notifyHistoryChanges();

    protected Frame getContainingFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void setCurrentCursor(int n) {
        this.currentCursor = n;
        Frame frame = this.getContainingFrame();
        if (frame != null) {
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(n));
        }
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1025: {
                Object object = documentEvent.getArgument();
                Object object2 = documentEvent.getSource();
                if (object instanceof Document) {
                    if (documentEvent.isShiftDown()) {
                        this.push((Document)object);
                        return;
                    }
                    this.push((Document)object);
                    return;
                }
                if (!(object instanceof NamedLink)) break;
                NamedLink namedLink = (NamedLink)documentEvent.getArgument();
                if (object2 instanceof DocPanel) {
                    this.push((Component)object2, namedLink.name, namedLink.url, namedLink.referer, documentEvent.getDocument());
                    return;
                }
                if (!this.isSetCurrentDocumentAllowed(namedLink.url, null, documentEvent.isShiftDown())) break;
                this._push((DocumentPanel)this, namedLink.url, namedLink.referer);
                return;
            }
            case 1027: {
                ElementInfo elementInfo = (ElementInfo)documentEvent.getArgument();
                if (elementInfo == null || this.hover == null || elementInfo.hrefURL == null || this.hover.hrefURL == null || !elementInfo.hrefURL.equals(this.hover.hrefURL) || elementInfo.imageURL == null || this.hover.imageURL == null || elementInfo.imageURL.equals(this.hover.imageURL) || elementInfo.event == null || this.hover.event == null || elementInfo.event.getModifiers() != this.hover.event.getModifiers()) {
                    this.setIndicatedElement(elementInfo);
                }
                return;
            }
            case 1024: {
                this.setErrorMessage((String)documentEvent.getArgument());
                return;
            }
            case 1000: {
                this.setStatusMessage((String)documentEvent.getArgument());
                return;
            }
            case 1019: {
                TagAppletPanel tagAppletPanel = (TagAppletPanel)documentEvent.getArgument();
                tagAppletPanel.addDocumentListener(this.docListener);
                super.processDocumentEvent(documentEvent);
                return;
            }
            case 1017: {
                Object object = documentEvent.getArgument();
                if (!(object instanceof DocumentFormatter)) break;
                this.addTopDocListenerToSource((DocumentFormatter)object);
                return;
            }
            case 1018: {
                Object object = documentEvent.getArgument();
                if (!(object instanceof DocumentFormatter)) break;
                this.removeTopDocListenerFromSource((DocumentFormatter)object);
                return;
            }
            case 1010: {
                super.processDocumentEvent(documentEvent);
                this.notifyHistoryChanges();
                return;
            }
            default: {
                super.processDocumentEvent(documentEvent);
            }
        }
    }

    protected void setIndicatedElement(ElementInfo elementInfo) {
        this.hover = elementInfo;
    }

    public ElementInfo getIndicatedElement() {
        return this.hover;
    }

    public void removeNotify() {
        this.stop();
        this.destroy();
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    private final class DocListener
    implements DocumentListener {
        public void documentChanged(DocumentEvent documentEvent) {
            BeanDocumentPanel.this.processDocumentEvent(documentEvent);
        }

        DocListener() {
            BeanDocumentPanel.this = BeanDocumentPanel.this;
        }
    }
}

