/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventMulticaster;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.ElementInfo;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FloaterInfo;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.ItemComponent;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.MouseDownInfo;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.ProcessActivationQueueThread;
import sunw.hotjava.doc.Range;
import sunw.hotjava.doc.Responsibility;
import sunw.hotjava.doc.ResponsibilityEnumeration;
import sunw.hotjava.doc.ResponsibilityRangeEnumeration;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.ToolTipInfo;
import sunw.hotjava.doc.TraversalState;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.URLConnector;
import sunw.hotjava.tables.TablePanel;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.IMG;
import sunw.hotjava.tags.TagAppletPanel;
import sunw.hotjava.ui.UserPopupMenuItem;
import sunw.html.Attributes;

public abstract class Formatter
implements DocConstants,
DocPanel,
ImageObserver,
DocumentEventSource {
    public int width;
    public int height;
    protected Document doc;
    protected DocumentState ds = new DocumentState();
    protected MouseDownInfo down;
    private DocumentEventMulticaster listeners = new DocumentEventMulticaster();
    protected int docWidth;
    protected int docHeight;
    protected int XOriginDelta;
    public int displayPos;
    public DocStyle displayStyle;
    protected int marginHeight = 10;
    protected DocLine[] lines;
    protected int nlines;
    protected int nItemComponents;
    protected ItemComponent[] itemComponents;
    protected Vector itemsNeedingDeactivation;
    private boolean hasFrameSetPanel = false;
    private Vector respVec;
    protected Vector floaters;
    public Vector formatFloaterQueue;
    private BitSet panelVisibility;
    private Graphics hackGraphics;
    private Vector activationQueue;
    private IMG lastImage;

    public DocumentState getDocumentState() {
        return this.ds;
    }

    public int getVScrollBarWidth() {
        return 0;
    }

    protected void setVScrollBarWidth(int n) {
    }

    protected boolean getRepair() {
        return false;
    }

    protected void setRepair(boolean bl) {
    }

    public abstract int getAvailableWidth();

    public abstract int getAvailableHeight();

    protected abstract int getStartIndex();

    protected abstract int getMaxIndex();

    public abstract void select(int var1, int var2);

    protected abstract Graphics getGraphics();

    public abstract void getBackgroundDisplacement(Point var1);

    protected abstract void disconnectFromParent(Component var1);

    public abstract Container getParent();

    public int getAvailableWidth(int n) {
        int n2 = this.getMargin(n);
        return this.width - (n2 >> 16) - (n2 & 0xFFFF);
    }

    public int getMargin(DocStyle docStyle, int n, int n2) {
        int n3 = this.getFloatingIndentAt(n2, true) + docStyle.left;
        int n4 = this.getFloatingIndentAt(n2, false) + docStyle.right;
        return n3 << 16 | n4;
    }

    public int getMargin(int n) {
        DocStyle docStyle = this.doc.getStyle(this.ds.docStyle, n);
        int n2 = docStyle.left;
        int n3 = docStyle.right;
        return n2 << 16 | n3;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public void dispatchDocumentEvent(int n, Object object) {
        DocumentEvent documentEvent = new DocumentEvent(this, n, object);
        this.listeners.documentChanged(documentEvent);
    }

    public void dispatchDocumentEvent(Object object, int n, boolean bl, Object object2) {
        DocumentEvent documentEvent = new DocumentEvent(object, n, bl, object2);
        this.listeners.documentChanged(documentEvent);
    }

    public void dispatchToolTipEvent(int n, IMG iMG, Point point) {
        if (iMG != null) {
            ToolTipInfo toolTipInfo = new ToolTipInfo();
            toolTipInfo.image = iMG;
            toolTipInfo.point = point;
            toolTipInfo.source = this.getParent();
            this.dispatchDocumentEvent(n, toolTipInfo);
        }
    }

    public Formatter getParentFormatter() {
        return null;
    }

    public boolean isFormatterBackgroundColorDeliberate() {
        return false;
    }

    public void touch() {
        this.touch(this.doc.isOkToFormat(), 0);
    }

    public abstract void touch(boolean var1, int var2);

    public abstract void touch(boolean var1, int var2, DocItem var3);

    public DocFont getDocFont() {
        return this.ds.docStyle.font;
    }

    public boolean showingTags() {
        return this.ds.tags;
    }

    public void setShowingTags(boolean bl) {
        this.ds.tags = bl;
        if (this.hasFrameSetPanel()) {
            int n = 0;
            while (n < this.nItemComponents) {
                Component component = this.itemComponents[n].getComponent();
                if (component instanceof FrameSetPanel) {
                    ((FrameSetPanel)component).setShowingTags(bl);
                }
                ++n;
            }
        }
    }

    public final void setBreak(FormatState formatState, FormatState formatState2, int n, int n2) {
        formatState2.copyFrom(formatState);
        formatState2.pos = formatState.pos & 0x7FFF0000 | n;
        formatState2.width = n2;
    }

    public TagItem inTag(DocStyle docStyle, String string) {
        while (docStyle.tag != null) {
            if (string.equals(docStyle.tag.getName())) {
                return docStyle.tag;
            }
            docStyle = docStyle.next;
        }
        return null;
    }

    public Component getPanel(DocItem docItem) {
        int n = 0;
        while (n < this.nItemComponents) {
            ItemComponent itemComponent = this.itemComponents[n];
            int n2 = itemComponent.getIndex();
            DocItem docItem2 = this.doc.getItem(n2);
            if (docItem2 == docItem) {
                return itemComponent.getComponent();
            }
            ++n;
        }
        return null;
    }

    protected boolean hasFrameSetPanel() {
        return this.hasFrameSetPanel;
    }

    public TagAppletPanel getAppletPanel(String string) {
        int n = 0;
        while (n < this.nItemComponents) {
            TagAppletPanel tagAppletPanel;
            Component component = this.itemComponents[n].getComponent();
            if (component instanceof TablePanel) {
                tagAppletPanel = ((TablePanel)component).getAppletPanel(string);
                if (tagAppletPanel != null) {
                    return tagAppletPanel;
                }
            } else if (component instanceof TagAppletPanel) {
                tagAppletPanel = (TagAppletPanel)component;
                String string2 = tagAppletPanel.getParameter("name");
                if (string2 != null) {
                    string2 = string2.toLowerCase();
                }
                if (string.equals(string2)) {
                    return tagAppletPanel;
                }
            }
            ++n;
        }
        return null;
    }

    public void getAppletPanels(Vector vector, boolean bl) {
        int n = 0;
        while (n < this.nItemComponents) {
            Component component = this.itemComponents[n].getComponent();
            if (component instanceof TablePanel) {
                ((TablePanel)component).getAppletPanels(vector);
            } else if (bl && component instanceof FrameSetPanel) {
                ((FrameSetPanel)component).getAppletPanels(vector);
            } else if (component instanceof TagAppletPanel) {
                vector.addElement(component);
            }
            ++n;
        }
    }

    public void getAppletPanels(Vector vector) {
        this.getAppletPanels(vector, false);
    }

    protected void wakeScreenUpdater() {
    }

    protected void setVisible(Component component, BitSet bitSet, int n) {
    }

    protected void setInvisible(Component component, BitSet bitSet, int n) {
    }

    protected void connectBackgroundClient() {
    }

    protected void disconnectBackgroundClient() {
    }

    protected void quitViewingDoc() {
    }

    protected void setFormatterStarted(boolean bl) {
    }

    protected void activateItem(int n) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.ds.started) {
                    this.processActivationQueue();
                    this.performActivation(n);
                } else {
                    if (this.activationQueue == null) {
                        this.activationQueue = new Vector();
                    }
                    this.activationQueue.addElement(new Integer(n));
                }
            }
            return;
        }
    }

    private void performActivation(int n) {
        DocItem docItem = this.doc.items[n >> 16];
        Component component = docItem.createView(this, this.doc);
        if (docItem.activate(this, this.doc)) {
            if (this.itemsNeedingDeactivation == null) {
                this.itemsNeedingDeactivation = new Vector(4);
            }
            this.itemsNeedingDeactivation.addElement(docItem);
        }
        if (component != null) {
            if (component instanceof FrameSetPanel) {
                this.hasFrameSetPanel = true;
            }
            this.validateItemComponentVector();
            this.itemComponents[this.nItemComponents++] = new ItemComponent(component, n >> 16);
            Container container = this.getParent();
            if (container != null && component.getParent() == null) {
                container.add(component);
            }
            ((DocPanel)((Object)component)).activateSubItems();
            ((DocPanel)((Object)component)).start();
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    this.paintRange(graphics, n, n + 65536, false);
                    return;
                }
                finally {
                    Object var7_6 = null;
                    graphics.dispose();
                }
            }
        }
    }

    public void activateItemComponents() {
        int n = this.getStartIndex();
        while (n < this.getMaxIndex()) {
            DocItem docItem = this.doc.items[n];
            docItem.getOffset();
            if (docItem.needsActivation() && docItem.getOffset() >= 0) {
                this.activateItem(n << 16);
            }
            n += docItem.getActivateIncrement();
        }
    }

    private void validateItemComponentVector() {
        if (this.itemComponents == null) {
            this.itemComponents = new ItemComponent[1];
        }
        if (this.nItemComponents >= this.itemComponents.length) {
            ItemComponent[] itemComponentArray = new ItemComponent[3 * (this.nItemComponents + 1) / 2];
            System.arraycopy(this.itemComponents, 0, itemComponentArray, 0, this.nItemComponents);
            this.itemComponents = itemComponentArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processActivationQueue() {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.activationQueue == null) {
                    return;
                }
                int n = this.activationQueue.size();
                int n2 = 0;
                while (n2 < n) {
                    Integer n3 = (Integer)this.activationQueue.elementAt(n2);
                    this.performActivation(n3);
                    ++n2;
                }
                this.activationQueue = null;
            }
            return;
        }
    }

    protected void maybeStartActivationQueueThread() {
        if (this.activationQueue == null) {
            return;
        }
        ProcessActivationQueueThread processActivationQueueThread = new ProcessActivationQueueThread(this);
        processActivationQueueThread.setPriority(4);
        processActivationQueueThread.start();
    }

    protected void copyPanelsForPrinting(Formatter formatter, DocumentState documentState) {
        int n = formatter.nItemComponents;
        ItemComponent[] itemComponentArray = formatter.itemComponents;
        this.itemComponents = new ItemComponent[n];
        this.nItemComponents = n;
        int n2 = 0;
        while (n2 < this.nItemComponents) {
            ItemComponent itemComponent = itemComponentArray[n2];
            Component component = itemComponent.getComponent();
            if (component instanceof TablePanel) {
                itemComponent = new ItemComponent(((TablePanel)component).copyForPrinting(this, documentState), itemComponent.getIndex());
            }
            this.itemComponents[n2] = itemComponent;
            ++n2;
        }
    }

    public void start() {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (!this.ds.started) {
                    this.getParent();
                    int n = 0;
                    while (n < this.nItemComponents) {
                        Component component = this.itemComponents[n].getComponent();
                        this.setVisible(component, this.panelVisibility, n);
                        try {
                            ((DocPanel)((Object)component)).start();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n;
                    }
                    this.wakeScreenUpdater();
                    this.reactivateItems();
                    this.setFormatterStarted(true);
                    this.connectBackgroundClient();
                    if (this.doc.doneParsing()) {
                        this.maybeStartActivationQueueThread();
                    }
                }
            }
            return;
        }
    }

    public void unregisterListeners() {
        int n = 0;
        while (n < this.nItemComponents) {
            Component component = this.itemComponents[n].getComponent();
            if (component instanceof TablePanel) {
                ((TablePanel)component).unregisterListeners();
            }
            ++n;
        }
    }

    public void stop() {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.ds.started) {
                    this.panelVisibility = new BitSet(this.nItemComponents);
                    this.getParent();
                    int n = 0;
                    while (n < this.nItemComponents) {
                        Component component = this.itemComponents[n].getComponent();
                        ((DocPanel)((Object)component)).stop();
                        this.setInvisible(component, this.panelVisibility, n);
                        ++n;
                    }
                    this.deactivateItems();
                    this.setFormatterStarted(false);
                    this.disconnectBackgroundClient();
                    this.clearParentBackground();
                }
            }
            return;
        }
    }

    public void destroy() {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                this.quitViewingDoc();
                while (this.nItemComponents > 0) {
                    Component component = this.itemComponents[--this.nItemComponents].getComponent();
                    if (this.ds.started) {
                        ((DocPanel)((Object)component)).stop();
                        component.setVisible(false);
                    }
                    ((DocPanel)((Object)component)).destroy();
                    this.disconnectFromParent(component);
                }
                this.deactivateItems();
            }
            return;
        }
    }

    public void interruptLoading() {
    }

    protected void deactivateItems() {
        if (this.itemsNeedingDeactivation != null) {
            int n = 0;
            while (n < this.itemsNeedingDeactivation.size()) {
                DocItem docItem = (DocItem)this.itemsNeedingDeactivation.elementAt(n);
                docItem.deactivate(this);
                ++n;
            }
        }
    }

    protected void reactivateItems() {
        if (this.itemsNeedingDeactivation != null) {
            int n = 0;
            while (n < this.itemsNeedingDeactivation.size()) {
                DocItem docItem = (DocItem)this.itemsNeedingDeactivation.elementAt(n);
                docItem.activate(this, this.doc);
                ++n;
            }
        }
    }

    public int findYOfDocLine(int n) {
        if (this.lines.length > n && this.lines.length >= 0) {
            DocLine docLine = this.lines[n];
            return docLine.y;
        }
        return -1;
    }

    public int findPos(int n) {
        DocLine[] docLineArray = this.lines;
        int n2 = 0;
        int n3 = this.nlines - 1;
        while (n2 < n3) {
            int n4 = n2 + (n3 - n2 >> 1);
            DocLine docLine = docLineArray[n4];
            if (n < docLine.start) {
                n3 = n4 - 1;
                continue;
            }
            if (n >= docLine.end) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return n2;
    }

    protected int findXPos(DocLine docLine, DocStyle docStyle, int n) {
        int n2;
        FloaterInfo floaterInfo;
        DocItem docItem;
        if (n < docLine.start) {
            return 0;
        }
        if (n >= docLine.end) {
            return this.width;
        }
        int n3 = docLine.start;
        int n4 = n3 >> 16;
        int n5 = n >> 16;
        int n6 = 0;
        while (n4 < n5) {
            docItem = this.doc.items[n4];
            floaterInfo = this.getFloaterInfo(docItem);
            if (floaterInfo == null || !floaterInfo.isLeft) {
                n2 = docItem.getOffset();
                if (n2 > 0) {
                    if ((n3 & 0xFFFF) == 0) {
                        docStyle = docStyle.push(docItem);
                    }
                    n6 += docItem.getStartTagWidth(docLine, docStyle, n6, n3 & 0xFFFF, 65535);
                } else if (n2 < 0) {
                    n6 += this.doc.items[n4 + n2].getEndTagWidth(docLine, docStyle, n6, n3 & 0xFFFF, 65535);
                    docStyle = docStyle.next;
                } else {
                    docStyle = docItem.modifyStyleInPlace(docStyle);
                    n6 += docItem.getWidth(docLine, docStyle, n6, n3 & 0xFFFF, 65535);
                }
            }
            n3 = ++n4 << 16;
        }
        docItem = this.doc.items[n4];
        n2 = docItem.getOffset();
        if (n2 > 0) {
            if ((n3 & 0xFFFF) == 0) {
                docStyle = docStyle.push(docItem);
            }
        } else if (n2 == 0) {
            docStyle = docItem.modifyStyleInPlace(docStyle);
        }
        if ((floaterInfo = this.getFloaterInfo(docItem)) == null) {
            return (docLine.margin >> 16) + n6 + docItem.getWidth(docLine, docStyle, n6, n3 & 0xFFFF, n & 0xFFFF);
        }
        Point point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
        return point.x;
    }

    protected int findAffected(int n) {
        DocLine[] docLineArray = this.lines;
        int n2 = 0;
        int n3 = this.nlines - 1;
        while (n2 < n3) {
            int n4 = n2 + (n3 - n2 >> 1);
            if (n > docLineArray[n4].tail) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n2;
    }

    protected int findY(int n) {
        DocLine[] docLineArray = this.lines;
        int n2 = 0;
        int n3 = this.nlines - 1;
        while (n2 < n3) {
            int n4 = n2 + (n3 - n2 >> 1);
            DocLine docLine = docLineArray[n4];
            int n5 = docLine.y;
            if (n <= n5) {
                if (n == n5) {
                    n3 = n4;
                    continue;
                }
                n3 = n4 - 1;
                continue;
            }
            if (n >= n5 + docLine.height) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return n2;
    }

    protected int findX(int n, int n2) {
        return this.findX(n, n2, -1);
    }

    protected int findX(int n, int n2, int n3) {
        if (n >= this.nlines) {
            return this.getMaxIndex() << 16;
        }
        DocLine docLine = this.lines[n];
        int n4 = docLine.start;
        int n5 = n4 >> 16;
        int n6 = docLine.end;
        DocStyle docStyle = this.doc.getStyle(this.ds.docStyle, n4);
        FloaterInfo floaterInfo = this.findFloaterAt(n2, n3);
        if (floaterInfo != null) {
            if (floaterInfo.startY + floaterInfo.height < n3) {
                return this.getMaxIndex() << 16;
            }
            return floaterInfo.item.index << 16;
        }
        if (docLine.y + docLine.height < n3) {
            return this.getMaxIndex() << 16;
        }
        if (n2 <= docLine.margin >> 16) {
            return n4;
        }
        if (n2 >= this.width - (docLine.margin & 0xFFFF)) {
            return n6;
        }
        int n7 = 0;
        n2 -= docLine.margin >> 16;
        int n8 = this.getMaxIndex();
        while (n4 < n6 && n5 < n8) {
            DocItem docItem = this.doc.items[n5];
            int n9 = docItem.getOffset();
            if (n9 > 0) {
                if ((n4 & 0xFFFF) == 0) {
                    docStyle = docStyle.push(docItem);
                }
            } else if (n9 == 0) {
                docStyle = docItem.modifyStyleInPlace(docStyle);
            }
            int n10 = 0;
            n10 = n9 > 0 ? docItem.findStartTagX(docLine, docStyle, n7, n4, n2, this) : (n9 < 0 ? this.doc.items[n5 + n9].findEndTagX(docLine, docStyle, n7, n4, n2, this) : docItem.findX(docLine, docStyle, n7, n4, n2, this));
            if (this.isFloater(docItem)) {
                n10 = -1;
            }
            if (n10 >= 0) {
                return n10;
            }
            n7 -= n10 + 1;
            if (n9 < 0) {
                docStyle = docStyle.next;
            }
            n4 = ++n5 << 16;
        }
        return n6;
    }

    public void reformat() {
        Document document = this.doc;
        synchronized (document) {
            int n = this.getMaxIndex() << 16;
            this.removeFloatersInRange(0, n);
            DocLine[] docLineArray = this.lines;
            int n2 = this.nlines;
            while (n2-- > 0) {
                docLineArray[n2].updated = true;
            }
            this.reformatResponsibles();
            return;
        }
    }

    public int findYFor(int n) {
        Responsibility responsibility = this.findResponsibility(n);
        if (responsibility != null) {
            DocPanel docPanel = responsibility.getTarget();
            return docPanel.findYFor(n);
        }
        Point point = new Point(0, 0);
        this.getBackgroundDisplacement(point);
        DocLine docLine = this.lines[this.findPos(n)];
        return docLine.y + -point.y;
    }

    void adjustXOrigin(int n) {
        if (n < 0 && this.XOriginDelta > n) {
            this.XOriginDelta = n >> 16;
            return;
        }
        this.XOriginDelta = 0;
    }

    int getXOriginDelta() {
        return this.XOriginDelta;
    }

    protected DocLine formatLine(int n, int n2, FormatState formatState, FormatState formatState2) {
        int n3;
        formatState.y = n;
        if (formatState.pos != n2) {
            formatState.pos = n2;
            formatState.style = this.doc.getStyle(this.ds.docStyle, formatState.pos);
        } else if (formatState.style == null) {
            formatState.style = this.doc.getStyle(this.ds.docStyle, formatState.pos);
        }
        formatState.startPos = formatState2.pos = formatState.pos;
        formatState.state = 0;
        formatState.width = 0;
        formatState.descent = 0;
        formatState.ascent = 0;
        formatState.above = formatState.startPos == this.getStartIndex() << 16 ? this.marginHeight : 0;
        formatState.below = 0;
        formatState.textAscent = 0;
        formatState.margin = this.getMargin(formatState.style, formatState.pos, formatState.y + formatState.above);
        formatState.maxWidth = this.width - ((formatState.margin >> 16) + formatState.margin & 0xFFFF);
        formatState.format = formatState.style.format;
        int n4 = this.getMaxIndex() << 16;
        this.setBreak(formatState, formatState2, 0, formatState.width);
        while (formatState.pos < n4) {
            n3 = formatState.pos >> 16;
            DocItem docItem = this.doc.items[n3];
            int n5 = docItem.getOffset();
            if (n5 > 0) {
                if (docItem.formatStartTag(this, formatState, formatState2)) {
                    break;
                }
            } else if (n5 >= 0 ? docItem.format(this, formatState, formatState2) : this.doc.items[n3 + n5].formatEndTag(this, formatState, formatState2)) break;
            if (formatState.width > formatState.maxWidth && formatState2.pos > formatState.startPos) {
                formatState.pos = formatState2.pos;
                formatState.width = formatState2.width;
                formatState.ascent = formatState2.ascent;
                formatState.descent = formatState2.descent;
                formatState.style = formatState2.style;
                break;
            }
            if (formatState.width <= formatState.maxWidth) continue;
            if (!this.floatersInYRange(formatState.y)) break;
            formatState.pos = formatState2.pos;
            formatState.width = formatState2.width;
            formatState.ascent = formatState2.ascent;
            formatState.descent = formatState2.descent;
            formatState.style = formatState2.style;
            formatState.below += this.getCumulativeFloaterHeight(formatState.y);
            break;
        }
        switch (formatState.format) {
            case 3: {
                n3 = (formatState.maxWidth - formatState.width) / 2 << 16;
                if (n3 < formatState.style.left) {
                    n3 = formatState.style.left;
                }
                formatState.margin += n3;
                this.adjustXOrigin(n3);
                break;
            }
            case 1: {
                formatState.margin += formatState.maxWidth - formatState.width << 16;
                break;
            }
        }
        this.insertQueuedFloaters(formatState);
        this.formatFloaterQueue = null;
        this.finishLineFormatting(formatState);
        return new DocLine(formatState.startPos, formatState.pos, formatState.pos, formatState.margin, formatState.width, formatState.above, formatState.below, formatState.ascent, formatState.descent, formatState.textAscent);
    }

    protected void finishLineFormatting(FormatState formatState) {
    }

    protected void processMouseAction(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.handleMouseDown(mouseEvent);
                return;
            }
            case 506: {
                this.handleMouseDrag(mouseEvent);
                return;
            }
            case 502: {
                this.handleMouseUp(mouseEvent);
                return;
            }
            case 503: {
                this.handleMouseMove(mouseEvent);
                return;
            }
            case 505: {
                this.dispatchDocumentEvent(1001, null);
                this.dispatchDocumentEvent(1027, null);
                this.dispatchToolTipEvent(1035, this.lastImage, null);
                return;
            }
        }
    }

    protected boolean handleMouseDown(MouseEvent mouseEvent) {
        this.down = new MouseDownInfo();
        this.down.x = this.mapPaneXToDocX(mouseEvent.getX());
        this.down.y = this.mapPaneYToDocY(mouseEvent.getY());
        int n = this.findY(this.down.y);
        this.down.pos = this.findX(n, this.down.x, this.down.y);
        if (this.findResponsibility(this.down.pos) == null) {
            int n2 = this.down.pos >> 16;
            if ((mouseEvent.getModifiers() & 4) != 0) {
                boolean bl = true;
                if (!Globals.isBean) {
                    String string = System.getProperty("hotjava.showpopupmenu");
                    bl = string.equals("true");
                }
                if (bl) {
                    this.showPopupMenu(mouseEvent, n, this.down);
                }
                return true;
            }
            if (n2 < this.doc.nitems) {
                DocItem docItem = this.doc.items[n2];
                DocStyle docStyle = this.doc.getStyle(this.ds.docStyle, this.down.pos);
                if (docItem.needsLoading() && Globals.isExpensiveLoadingAllowed()) {
                    this.dispatchDocumentEvent(1000, Globals.localProps.handleGetString("img.load"));
                    docItem.load(this);
                    return true;
                }
                if (docItem.isMappable()) {
                    Point point;
                    int n3;
                    int n4;
                    this.down.tag = (TagItem)docItem;
                    this.select(this.down.pos, this.down.pos);
                    DocLine docLine = this.lines[n];
                    FloaterInfo floaterInfo = this.getFloaterInfo(docItem);
                    if (floaterInfo == null) {
                        n4 = this.down.x - this.findXPos(docLine, docStyle, n2 << 16);
                        n3 = this.down.y - docLine.y;
                    } else {
                        point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                        n4 = this.down.x - point.x;
                        n3 = this.down.y - floaterInfo.startY;
                    }
                    point = this.doc.getBaseURL() == null ? null : this.doc.getBaseURL().toString();
                    NamedLink namedLink = docItem.map(docLine, docStyle, (String)((Object)point), n4, n3);
                    if (namedLink == null) {
                        return true;
                    }
                    URL uRL = namedLink.url;
                    this.dispatchDocumentEvent(1001, uRL);
                    return true;
                }
                TagItem tagItem = this.inTag(docStyle, "a");
                if (tagItem != null && docStyle.href != null) {
                    this.down.url = docStyle.href;
                    this.dispatchDocumentEvent(1001, this.down.url);
                    this.down.tag = tagItem;
                    this.select(this.down.pos, this.down.pos);
                    this.paintTag(tagItem);
                    return true;
                }
            }
            if (mouseEvent.isShiftDown()) {
                if (this.down.pos <= this.ds.selStart) {
                    this.select(this.down.pos, this.ds.selEnd);
                    this.down.pos = this.ds.selEnd;
                } else {
                    this.select(this.ds.selStart, this.down.pos);
                    this.down.pos = this.ds.selStart;
                }
            } else {
                this.select(this.down.pos, this.down.pos);
            }
        }
        return true;
    }

    protected boolean handleMouseDrag(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.down != null && this.findResponsibility(this.down.pos) == null) {
            if (this.down.tag != null) {
                if (Math.abs(this.mapPaneXToDocX(point.x) - this.down.x) < 5 && Math.abs(this.mapPaneYToDocY(point.y) - this.down.y) < 5) {
                    return true;
                }
                TagItem tagItem = this.down.tag;
                this.down.tag = null;
                this.paintTag(tagItem);
                this.dispatchDocumentEvent(1001, null);
            }
            this.select(this.down.pos, this.findX(this.findY(this.mapPaneYToDocY(point.y)), this.mapPaneXToDocX(point.x)));
        }
        return true;
    }

    private boolean sameFileURL(URL uRL, URL uRL2) {
        return uRL.getPort() == uRL2.getPort() && uRL.getProtocol().equals(uRL2.getProtocol()) && uRL.getFile().equals(uRL2.getFile()) && uRL.getHost().equals(uRL2.getHost());
    }

    protected boolean handleMouseUp(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.hidePopupMenu(mouseEvent);
            return true;
        }
        if (this.down != null && this.down.tag != null) {
            int n;
            TagItem tagItem = this.down.tag;
            this.down.tag = null;
            this.paintTag(tagItem);
            Point point = mouseEvent.getPoint();
            int n2 = this.findY(this.mapPaneYToDocY(point.y));
            int n3 = this.findX(n2, this.mapPaneXToDocX(point.x), this.mapPaneYToDocY(point.y));
            if (this.findResponsibility(n3) == null && (n = n3 >> 16) < this.getMaxIndex()) {
                Serializable serializable;
                Object object;
                int n4;
                int n5;
                DocLine docLine = this.lines[n2];
                DocItem docItem = this.doc.items[n];
                FloaterInfo floaterInfo = this.getFloaterInfo(docItem);
                if (floaterInfo == null) {
                    n5 = this.mapPaneXToDocX(point.x) - this.findXPos(docLine, this.doc.getStyle(this.ds.docStyle, docLine.start), n << 16);
                    n4 = this.mapPaneYToDocY(point.y) - docLine.y;
                } else {
                    object = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                    n5 = this.mapPaneXToDocX(point.x) - ((Point)object).x;
                    n4 = this.mapPaneYToDocY(point.y) - floaterInfo.startY;
                }
                object = tagItem.map(docLine, this.doc.getStyle(this.ds.docStyle, n << 16), this.down.url, n5, n4);
                if (object == null) {
                    serializable = this.getDocument().getURL();
                    object = new NamedLink("_top", null, (URL)serializable);
                }
                if (((NamedLink)object).url == null) {
                    serializable = new Properties();
                    if (this.down.url == null) {
                        return true;
                    }
                    ((Hashtable)serializable).put("badlink", this.down.url);
                    if (Globals.isBean && this.doc.getBaseURL() == null) {
                        DocumentFormatter documentFormatter = this.getTopFormatter();
                        if (documentFormatter.parent != null) {
                            DocumentPanel documentPanel = (DocumentPanel)documentFormatter.parent.getParent();
                            if (documentPanel != null && documentPanel.setsBaseURL()) {
                                this.dispatchDocumentEvent(1032, serializable);
                            } else {
                                URL uRL = this.doc.getBaseURL();
                                if (uRL != null) {
                                    ((Hashtable)serializable).put("baseurl", uRL.toExternalForm());
                                }
                                this.dispatchDocumentEvent(1011, serializable);
                            }
                        }
                    }
                    return true;
                }
                serializable = this.getTopFormatter();
                if (((DocumentFormatter)serializable).parent != null) {
                    URL uRL = this.doc.getBaseURL();
                    boolean bl = false;
                    Date date = this.doc.getExpirationDate();
                    if (date != null && date.getTime() <= System.currentTimeMillis()) {
                        bl = true;
                    }
                    if (!mouseEvent.isShiftDown() && uRL != null && this.getLinkTarget(tagItem).equals("_self") && this.sameFileURL(uRL, ((NamedLink)object).url) && !bl) {
                        this.dispatchDocumentEvent(1010, ((DocumentFormatter)serializable).parent.getParent());
                        ((DocumentFormatter)serializable).gotoLabel(((NamedLink)object).url.getRef());
                        this.dispatchDocumentEvent(1001, null);
                        this.dispatchDocumentEvent(1005, null);
                    } else {
                        ((NamedLink)object).referer = this.getDocument().getURL();
                        if (((NamedLink)object).name == null) {
                            ((NamedLink)object).name = this.getLinkTarget(tagItem);
                        }
                        this.dispatchDocumentEvent(1001, null);
                        this.dispatchDocumentEvent(((DocumentFormatter)serializable).parent.getParent(), 1002, mouseEvent.isShiftDown(), object);
                    }
                    this.paintTag(tagItem);
                }
            }
            this.down = null;
            return true;
        }
        this.down = null;
        return false;
    }

    protected boolean handleMouseMove(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.findY(this.mapPaneYToDocY(point.y));
        int n2 = this.findX(n, this.mapPaneXToDocX(point.x), this.mapPaneYToDocY(point.y));
        ElementInfo elementInfo = new ElementInfo();
        elementInfo.event = mouseEvent;
        if (this.findResponsibility(n2) == null) {
            int n3 = 0;
            int n4 = 0;
            DocLine docLine = this.lines[n];
            if (docLine != null) {
                n3 = docLine.margin >> 16;
                n4 = n3 + docLine.width + 1;
            }
            DocStyle docStyle = this.doc.getStyle(this.ds.docStyle, n2);
            int n5 = n2 >> 16;
            if (n5 < this.doc.nitems && n3 < point.x && n4 > point.x) {
                DocItem docItem = this.doc.items[n5];
                URL uRL = this.getImageURL(n5);
                if (uRL != null) {
                    elementInfo.imageURL = uRL.toString();
                }
                if (docItem.isMappable()) {
                    Point point2;
                    int n6;
                    int n7;
                    FloaterInfo floaterInfo = this.getFloaterInfo(docItem);
                    if (floaterInfo == null) {
                        n7 = this.mapPaneXToDocX(point.x) - this.findXPos(docLine, docStyle, n5 << 16);
                        n6 = this.mapPaneYToDocY(point.y) - docLine.y;
                    } else {
                        point2 = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                        n7 = this.mapPaneXToDocX(point.x) - point2.x;
                        n6 = this.mapPaneYToDocY(point.y) - floaterInfo.startY;
                    }
                    point2 = this.doc.getBaseURL() == null ? null : this.doc.getBaseURL().toString();
                    NamedLink namedLink = docItem.map(docLine, docStyle, (String)((Object)point2), n7, n6);
                    TagItem tagItem = (TagItem)docItem;
                    Attributes attributes = tagItem.getAttributes();
                    elementInfo.altText = attributes.get("alt");
                    if (namedLink != null) {
                        elementInfo.hrefURL = namedLink.url.toString();
                    }
                    this.dispatchDocumentEvent(1001, namedLink != null ? namedLink.url : null);
                    this.dispatchDocumentEvent(1027, elementInfo);
                    return true;
                }
                if (docItem instanceof IMG) {
                    if (this.lastImage == (IMG)docItem) {
                        this.dispatchToolTipEvent(1034, this.lastImage, null);
                    } else {
                        this.dispatchToolTipEvent(1035, this.lastImage, null);
                        this.lastImage = null;
                        TagItem tagItem = (TagItem)docItem;
                        Attributes attributes = tagItem.getAttributes();
                        String string = attributes.get("alt");
                        if (string != null) {
                            this.lastImage = (IMG)docItem;
                            this.dispatchToolTipEvent(1033, this.lastImage, mouseEvent.getPoint());
                        }
                    }
                } else {
                    this.dispatchToolTipEvent(1035, this.lastImage, null);
                    this.lastImage = null;
                }
            } else {
                this.dispatchToolTipEvent(1035, this.lastImage, null);
                this.lastImage = null;
            }
            if (n3 >= point.x || n4 <= point.x) {
                docStyle.href = null;
            }
            if (docStyle.href != null) {
                elementInfo.hrefURL = docStyle.href.toString();
            }
            this.dispatchDocumentEvent(1001, docStyle.href);
            this.dispatchDocumentEvent(1027, elementInfo);
        } else {
            this.dispatchToolTipEvent(1035, this.lastImage, null);
            this.lastImage = null;
        }
        return true;
    }

    private void hidePopupMenu(MouseEvent mouseEvent) {
        if (Globals.isBean) {
            mouseEvent.getPoint();
            MouseDownInfo mouseDownInfo = new MouseDownInfo();
            mouseDownInfo.x = this.mapPaneXToDocX(mouseEvent.getX());
            mouseDownInfo.y = this.mapPaneYToDocY(mouseEvent.getY());
            int n = this.findY(mouseDownInfo.y);
            mouseDownInfo.pos = this.findX(n, mouseDownInfo.x, mouseDownInfo.y);
            if (this.findResponsibility(mouseDownInfo.pos) == null) {
                DocItem docItem;
                int n2 = mouseDownInfo.pos >> 16;
                URL uRL = this.getLinkURL(n2, n, mouseDownInfo);
                URL uRL2 = this.getImageURL(n2);
                ElementInfo elementInfo = new ElementInfo();
                if (uRL2 != null) {
                    elementInfo.imageURL = uRL2.toString();
                }
                if (uRL != null) {
                    elementInfo.hrefURL = uRL.toString();
                }
                if ((docItem = this.doc.items[n2]) != null && docItem.isMappable()) {
                    TagItem tagItem = (TagItem)docItem;
                    Attributes attributes = tagItem.getAttributes();
                    elementInfo.altText = attributes.get("alt");
                }
                elementInfo.event = mouseEvent;
                this.dispatchDocumentEvent(1027, elementInfo);
                return;
            }
        } else {
            DocumentFormatter documentFormatter = this.getTopFormatter();
            PopupMenu popupMenu = documentFormatter.getPopup();
            if (popupMenu != null) {
                documentFormatter.setPopup(null);
                documentFormatter.getParent().getParent().remove(popupMenu);
            }
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent, int n, MouseDownInfo mouseDownInfo) {
        Serializable serializable;
        Serializable serializable2;
        PopupMenu popupMenu = null;
        if (!Globals.isBean) {
            popupMenu = new PopupMenu(Globals.localProps.handleGetString("hotjava.popupMenu.title", "HotJava Commands"));
        }
        int n2 = mouseDownInfo.pos >> 16;
        boolean bl = false;
        ElementInfo elementInfo = new ElementInfo();
        if (n2 < this.doc.nitems) {
            serializable2 = this.getLinkURL(n2, n, mouseDownInfo);
            if (serializable2 != null) {
                elementInfo.hrefURL = ((URL)serializable2).toString();
                if (!Globals.isBean) {
                    bl = true;
                    this.addLinkMenuItems(popupMenu, (URL)serializable2, null);
                }
            }
            if ((serializable = this.getImageURL(n2)) != null) {
                elementInfo.imageURL = ((URL)serializable).toString();
                if (!Globals.isBean) {
                    if (bl) {
                        popupMenu.addSeparator();
                    } else {
                        bl = true;
                    }
                    this.addImageMenuItems(popupMenu, (URL)serializable);
                }
            }
        } else if (Globals.isBean) {
            return;
        }
        if (Boolean.getBoolean("hotjava.allowMenuBarToggling") && !Globals.isBean && !Boolean.getBoolean("hotjava.useMenuBar")) {
            if (bl) {
                popupMenu.addSeparator();
            } else {
                bl = true;
            }
            popupMenu.add(new UserPopupMenuItem("hotjava.menuBarMenu.restoremenubar", null, null, 1016));
        }
        if (Globals.isBean && n2 < this.doc.nitems) {
            serializable2 = this.doc.items[n2];
            if (((DocItem)serializable2).isMappable()) {
                serializable = (TagItem)serializable2;
                Attributes attributes = ((TagItem)serializable).getAttributes();
                elementInfo.altText = attributes.get("alt");
            }
            elementInfo.event = mouseEvent;
            this.dispatchDocumentEvent(1027, elementInfo);
            return;
        }
        if (bl) {
            popupMenu.addSeparator();
        } else {
            bl = true;
        }
        this.addNavigationMenuItems(popupMenu);
        if (bl) {
            serializable2 = this.getTopFormatter();
            ((DocumentFormatter)serializable2).setPopup(popupMenu);
            serializable = (DocumentPanel)((DocumentFormatter)serializable2).getParent().getParent();
            ((Component)serializable).add(popupMenu);
            ((DocumentPanel)serializable).addActionListenerOnPopup(popupMenu);
            Point point = mouseEvent.getPoint();
            popupMenu.show((Component)mouseEvent.getSource(), point.x, point.y);
        }
    }

    private URL getLinkURL(int n, int n2, MouseDownInfo mouseDownInfo) {
        DocItem docItem = this.doc.items[n];
        DocStyle docStyle = this.doc.getStyle(this.ds.docStyle, mouseDownInfo.pos);
        if (docItem != null && docItem.isMappable()) {
            Point point;
            int n3;
            int n4;
            DocLine docLine = this.lines[n2];
            FloaterInfo floaterInfo = this.getFloaterInfo(docItem);
            if (floaterInfo == null) {
                n4 = mouseDownInfo.x - this.findXPos(docLine, docStyle, n << 16);
                n3 = mouseDownInfo.y - docLine.y;
            } else {
                point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                n4 = mouseDownInfo.x - point.x;
                n3 = mouseDownInfo.y - floaterInfo.startY;
            }
            point = this.doc.getBaseURL() == null ? null : this.doc.getBaseURL().toString();
            NamedLink namedLink = docItem.map(docLine, docStyle, (String)((Object)point), n4, n3);
            if (namedLink != null) {
                return namedLink.url;
            }
        } else {
            TagItem tagItem = this.inTag(docStyle, "a");
            if (tagItem != null) {
                try {
                    return new URL(this.doc.getBaseURL(), docStyle.href);
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
        }
        return null;
    }

    private URL getImageURL(int n) {
        DocItem docItem = this.doc.items[n];
        if (docItem != null) {
            return docItem.getImageURL();
        }
        return null;
    }

    private void addLinkMenuItems(PopupMenu popupMenu, URL uRL, URLConnector uRLConnector) {
        URL uRL2 = this.getDocument().getURL();
        NamedLink namedLink = new NamedLink("", uRL, uRL2);
        namedLink.setConnector(uRLConnector);
        String string = Globals.getFileNameFromURL(uRL);
        if (string == null) {
            string = uRL.getFile();
            string = string.equals("/") ? uRL.getHost() : string.substring(1, string.length());
        }
        popupMenu.add(new UserPopupMenuItem("hotjava.linkMenu.open", namedLink, 1031));
        popupMenu.add(new UserPopupMenuItem("hotjava.linkMenu.remember", namedLink, 1014));
        popupMenu.add(new UserPopupMenuItem("hotjava.linkMenu.openClone", namedLink, 1015));
        popupMenu.add(new UserPopupMenuItem("hotjava.linkMenu.save", string, namedLink, 1013));
    }

    private void addImageMenuItems(PopupMenu popupMenu, URL uRL) {
        URL uRL2 = this.getDocument().getURL();
        NamedLink namedLink = new NamedLink("", uRL, uRL2);
        String string = Globals.getFileNameFromURL(uRL);
        if (string == null) {
            string = "";
        }
        popupMenu.add(new UserPopupMenuItem("hotjava.imageMenu.open", namedLink, 1031));
        popupMenu.add(new UserPopupMenuItem("hotjava.imageMenu.save", string, namedLink, 1013));
        popupMenu.add(new UserPopupMenuItem("hotjava.imageMenu.openClone", namedLink, 1015));
    }

    private void addNavigationMenuItems(PopupMenu popupMenu) {
        NamedLink namedLink = null;
        DocumentFormatter documentFormatter = this.getTopFormatter();
        if (Globals.isBean) {
            popupMenu.add(new UserPopupMenuItem("hotjava.navigationMenu.showgotoplacedialog", namedLink, 1022));
            return;
        }
        UserPopupMenuItem userPopupMenuItem = new UserPopupMenuItem("hotjava.navigationMenu.back", namedLink, 1020);
        UserPopupMenuItem userPopupMenuItem2 = new UserPopupMenuItem("hotjava.navigationMenu.forward", namedLink, 1021);
        Container container = documentFormatter.getParent().getParent();
        while (container != null) {
            if (container instanceof MasterDocumentPanel) break;
            container = container.getParent();
        }
        if (container != null) {
            MasterDocumentPanel masterDocumentPanel = (MasterDocumentPanel)container;
            userPopupMenuItem2.enable(masterDocumentPanel.canForward());
            userPopupMenuItem.enable(masterDocumentPanel.canBack());
        } else {
            userPopupMenuItem2.disable();
            userPopupMenuItem.disable();
        }
        popupMenu.add(userPopupMenuItem);
        popupMenu.add(userPopupMenuItem2);
        popupMenu.add(new UserPopupMenuItem("hotjava.navigationMenu.showgotoplacedialog", namedLink, 1022));
    }

    public String getLinkTarget(TagItem tagItem) {
        String string = null;
        string = tagItem.getLinkTarget();
        if (string != null) {
            return string;
        }
        string = (String)this.doc.getProperty("target");
        if (string == null) {
            string = "_self";
        }
        return string;
    }

    public DocumentFormatter getTopFormatter() {
        return this.ds.topFormatter;
    }

    protected void paintBack(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.ds.bg != null && !this.isFormatterBackgroundColorDeliberate()) {
            Point point = new Point(0, 0);
            this.getBackgroundDisplacement(point);
            this.ds.bg.paint(graphics, point.x, point.y, n, n2, n3, n4);
            return;
        }
        graphics.setColor(this.getFormatterBackgroundColor());
        graphics.fillRect(n, n2, n3, n4);
    }

    public Color getFormatterBackgroundColor() {
        return this.ds.background;
    }

    protected DocStyle paintLine(Graphics graphics, DocLine docLine, int n, int n2, int n3, DocStyle docStyle, boolean bl) {
        int n4;
        int n5;
        Object object;
        this.displayPos = docLine.start;
        this.displayStyle = docStyle;
        int n6 = docLine.end;
        if (docLine.margin >> 16 < 0) {
            object = this.doc.getStyle(this.ds.docStyle, docLine.start);
            n5 = this.getMargin((DocStyle)object, docLine.start, docLine.y) >> 16;
        } else {
            n5 = (docLine.margin >> 16) - this.getXOriginDelta();
        }
        if (docStyle == null) {
            this.displayStyle = docStyle = this.doc.getStyle(this.ds.docStyle, this.displayPos);
        }
        if (this.displayPos <= this.ds.selEnd && n6 >= this.ds.selStart) {
            int n7 = this.findXPos(docLine, docStyle, this.ds.selStart);
            if (this.ds.selStart == this.ds.selEnd) {
                if (this.ds.showcur) {
                    graphics.setColor(Globals.getColor("hotjava.curcolor", null));
                    graphics.fillRect(n7, n, 1, docLine.height);
                }
            } else if (this.ds.showsel) {
                n4 = this.findXPos(docLine, docStyle, this.ds.selEnd);
                graphics.setColor(Globals.getColor("hotjava.selcolor", null));
                graphics.fillRect(n7, n, n4 - n7, docLine.height);
            }
        }
        while (this.displayPos < n6) {
            object = this.doc.items[this.displayPos >> 16];
            n4 = ((DocItem)object).getOffset();
            if (n4 > 0) {
                if ((this.displayPos & 0xFFFF) == 0) {
                    this.displayStyle = this.displayStyle.push((DocItem)object);
                }
                n5 += ((DocItem)object).paint(this, graphics, n5, n, docLine, bl);
                continue;
            }
            if (n4 < 0) {
                n5 += ((DocItem)object).paint(this, graphics, n5, n, docLine, bl);
                this.displayStyle = this.displayStyle.next;
                continue;
            }
            this.displayStyle = ((DocItem)object).modifyStyleInPlace(this.displayStyle);
            n5 += ((DocItem)object).paint(this, graphics, n5, n, docLine, bl);
        }
        return this.displayStyle;
    }

    public boolean paintRangeNoFloaters(Graphics graphics, int n, int n2, boolean bl) {
        Enumeration enumeration = this.enumerateResponsiblesInRange(n, n2);
        while (enumeration.hasMoreElements()) {
            Responsibility responsibility = (Responsibility)enumeration.nextElement();
            if (responsibility.startIndex > n2 >> 16) break;
            if (n < responsibility.getStartPos()) {
                this.setRepair(this.getRepair() | this.paintLocalRangeNoFloaters(graphics, n, responsibility.getStartPos(), bl));
                n = responsibility.getStartPos();
            }
            if (responsibility.getStartPos() > n) continue;
            DocPanel docPanel = responsibility.getTarget();
            int n3 = Math.min(n2, responsibility.endIndex << 16);
            ((TablePanel)docPanel).paintRangeNoFloaters(graphics, n, n3, bl);
            n = responsibility.endIndex << 16;
        }
        if (n <= n2) {
            return this.paintLocalRangeNoFloaters(graphics, n, n2, bl);
        }
        return false;
    }

    protected boolean paintLocalRangeNoFloaters(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.findPos(n);
        DocStyle docStyle = null;
        boolean bl2 = this.ds.paintingScreen;
        boolean bl3 = false;
        try {
            this.ds.paintingScreen = true;
            while (n3 < this.nlines) {
                DocLine docLine = this.lines[n3];
                if (docLine.start > n2) break;
                if (!docLine.updated || bl2) {
                    if (docStyle == null) {
                        docStyle = this.doc.getStyle(this.ds.docStyle, docLine.start);
                    }
                    int n4 = docLine.start < n ? this.findXPos(docLine, docStyle, n) : 0;
                    int n5 = docLine.end > n2 ? this.findXPos(docLine, docStyle, n2) : this.width;
                    Graphics graphics2 = graphics.create();
                    this.setHackGraphics(graphics);
                    try {
                        this.clipToDrawableArea(graphics2);
                        if (n4 != 0 || n5 != this.width) {
                            graphics2.clipRect(n4, this.getDocumentY(), n5 - n4, this.height);
                        }
                        if (bl) {
                            this.paintBack(graphics2, 0, docLine.y, this.width, docLine.height);
                        }
                        docStyle = this.paintLine(graphics2, docLine, docLine.y, 0, this.width, docStyle, false);
                    }
                    finally {
                        Object var16_13 = null;
                        this.setHackGraphics(null);
                        graphics2.dispose();
                    }
                } else {
                    bl3 = true;
                    this.setRepair(true);
                    docStyle = null;
                }
                ++n3;
            }
            this.paintFloatersInRange(graphics, n, n2);
        }
        finally {
            Object var10_15 = null;
            this.ds.paintingScreen = bl2;
        }
        return bl3;
    }

    public boolean paintRange(Graphics graphics, int n, int n2, boolean bl) {
        Enumeration enumeration = this.enumerateResponsiblesInRange(n, n2);
        while (enumeration.hasMoreElements()) {
            Responsibility responsibility = (Responsibility)enumeration.nextElement();
            if (responsibility.startIndex > n2 >> 16) break;
            if (n < responsibility.getStartPos()) {
                this.setRepair(this.getRepair() | this.paintLocalRange(graphics, n, responsibility.getStartPos(), bl));
                n = responsibility.getStartPos();
            }
            if (responsibility.getStartPos() > n) continue;
            DocPanel docPanel = responsibility.getTarget();
            int n3 = Math.min(n2, responsibility.endIndex << 16);
            ((TablePanel)docPanel).paintRange(graphics, n, n3, bl);
            n = responsibility.endIndex << 16;
        }
        if (n <= n2) {
            return this.paintLocalRange(graphics, n, n2, bl);
        }
        return false;
    }

    public int getDocumentY() {
        return 0;
    }

    protected boolean paintLocalRange(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.findPos(n);
        DocStyle docStyle = null;
        boolean bl2 = this.ds.paintingScreen;
        boolean bl3 = false;
        try {
            this.ds.paintingScreen = true;
            while (n3 < this.nlines) {
                DocLine docLine = this.lines[n3];
                if (docLine.start > n2) break;
                if (!docLine.updated || bl2) {
                    if (docStyle == null) {
                        docStyle = this.doc.getStyle(this.ds.docStyle, docLine.start);
                    }
                    int n4 = docLine.start < n ? this.findXPos(docLine, docStyle, n) : 0;
                    int n5 = docLine.end > n2 ? this.findXPos(docLine, docStyle, n2) : this.width;
                    Graphics graphics2 = graphics.create();
                    this.setHackGraphics(graphics);
                    try {
                        this.clipToDrawableArea(graphics2);
                        if (n4 != 0 || n5 != this.width) {
                            graphics2.clipRect(n4, this.getDocumentY(), n5 - n4, this.height);
                        }
                        if (bl) {
                            this.paintBack(graphics2, 0, docLine.y, this.width, docLine.height);
                        }
                        docStyle = this.paintLine(graphics2, docLine, docLine.y, 0, this.width, docStyle, false);
                    }
                    finally {
                        Object var16_13 = null;
                        this.setHackGraphics(null);
                        graphics2.dispose();
                    }
                } else {
                    bl3 = true;
                    this.setRepair(true);
                    docStyle = null;
                }
                ++n3;
            }
            this.paintFloaters(graphics, n, n2);
        }
        finally {
            Object var10_15 = null;
            this.ds.paintingScreen = bl2;
        }
        return bl3;
    }

    protected void setHackGraphics(Graphics graphics) {
        this.hackGraphics = graphics;
    }

    public Graphics getHackGraphics() {
        return this.hackGraphics;
    }

    protected void clipToDrawableArea(Graphics graphics) {
    }

    protected DocStyle printLine(Graphics graphics, DocLine docLine, int n, int n2, int n3, DocStyle docStyle, PrintedLineInfo printedLineInfo) {
        this.displayPos = docLine.start;
        this.displayStyle = docStyle;
        int n4 = docLine.end;
        int n5 = docLine.margin >> 16;
        if (docStyle == null) {
            this.displayStyle = docStyle = this.doc.getStyle(this.ds.docStyle, this.displayPos);
        }
        printedLineInfo.startDocY = docLine.y;
        printedLineInfo.height = docLine.height;
        while (this.displayPos < n4) {
            DocItem docItem = this.doc.items[this.displayPos >> 16];
            int n6 = docItem.getOffset();
            if (n6 > 0) {
                if ((this.displayPos & 0xFFFF) == 0) {
                    this.displayStyle = this.displayStyle.push(docItem);
                }
                n5 += docItem.print(this, graphics, n5, n, docLine, printedLineInfo);
                continue;
            }
            if (n6 < 0) {
                n5 += docItem.print(this, graphics, n5, n, docLine, printedLineInfo);
                this.displayStyle = this.displayStyle.next;
                continue;
            }
            this.displayStyle = docItem.modifyStyleInPlace(this.displayStyle);
            n5 += docItem.print(this, graphics, n5, n, docLine, printedLineInfo);
        }
        return this.displayStyle;
    }

    protected int formatPrintDocument(int n) {
        int n2 = 0;
        int n3 = this.getMaxIndex() << 16;
        int n4 = this.getStartIndex() << 16;
        int n5 = n;
        FormatState formatState = new FormatState();
        FormatState formatState2 = new FormatState();
        formatState.pos = -1;
        while (n4 < n3) {
            DocLine docLine = this.formatLine(n5, n4, formatState, formatState2);
            if (docLine == null) break;
            docLine.y = n5;
            n4 = docLine.end;
            n5 += docLine.height;
            this.docHeight += docLine.height;
            if (this.nlines >= this.lines.length) {
                DocLine[] docLineArray = new DocLine[3 * (this.lines.length + 1) / 2];
                System.arraycopy(this.lines, 0, docLineArray, 0, this.nlines);
                this.lines = docLineArray;
            }
            if (docLine.width > n2) {
                n2 = docLine.width;
            }
            this.lines[this.nlines] = docLine;
            ++this.nlines;
        }
        return n2;
    }

    protected void paintTag(TagItem tagItem) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                Graphics graphics;
                int n = tagItem.getIndex();
                if (n < this.getMaxIndex() && this.doc.items[n] == tagItem && (graphics = this.getGraphics()) != null) {
                    block10: {
                        try {
                            if (tagItem.getOffset() > 0) {
                                this.paintRange(graphics, n << 16, n + tagItem.getOffset() + 1 << 16, true);
                                break block10;
                            }
                            this.paintRange(graphics, n << 16, n + 1 << 16, true);
                        }
                        catch (Throwable throwable) {
                            Object var9_7 = null;
                            graphics.dispose();
                            throw throwable;
                        }
                    }
                    Object var9_6 = null;
                    graphics.dispose();
                }
            }
            return;
        }
    }

    private int mapPaneXToDocX(int n) {
        return n + this.getXOriginDelta();
    }

    private int mapPaneYToDocY(int n) {
        return n;
    }

    protected boolean lineOverflows(DocLine docLine, int n, Dimension dimension) {
        DocStyle docStyle;
        int n2 = docLine.start >> 16;
        this.displayPos = docLine.start;
        this.displayStyle = docStyle = this.doc.getStyle(this.ds.docStyle, this.displayPos);
        TraversalState traversalState = new TraversalState();
        traversalState.style = docStyle;
        traversalState.pos = docLine.start;
        while (traversalState.pos < docLine.end) {
            n2 = traversalState.pos >> 16;
            DocItem docItem = this.doc.items[n2];
            if (!this.itemOverflows(traversalState, docLine, docItem, n, dimension)) continue;
            return true;
        }
        return false;
    }

    protected boolean itemOverflows(TraversalState traversalState, DocLine docLine, DocItem docItem, int n, Dimension dimension) {
        return docItem.doesOverflow(traversalState, this, docLine, n, dimension);
    }

    public boolean isFloater(DocItem docItem) {
        if (this.floaters == null || this.floaters.size() == 0) {
            return false;
        }
        int n = this.floaters.size();
        int n2 = 0;
        while (n2 < n) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n2);
            if (docItem == floaterInfo.item) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private FloaterInfo getFloaterInfo(DocItem docItem) {
        if (this.floaters == null || this.floaters.size() == 0) {
            return null;
        }
        int n = this.floaters.size();
        int n2 = 0;
        while (n2 < n) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n2);
            if (docItem == floaterInfo.item) {
                return floaterInfo;
            }
            ++n2;
        }
        return null;
    }

    public boolean floatersInYRange(int n) {
        if (this.floaters == null) {
            return false;
        }
        int n2 = this.floaters.size();
        while (--n2 >= 0) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n2);
            if (floaterInfo.invalid || !floaterInfo.inRange(n)) continue;
            return true;
        }
        return false;
    }

    private FloaterInfo findFloaterAt(int n, int n2) {
        if (this.floaters == null || this.floaters.size() == 0) {
            return null;
        }
        int n3 = this.floaters.size();
        int n4 = 0;
        while (n4 < n3) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n4);
            if (floaterInfo.startY > n2) break;
            if (floaterInfo.inRange(n2)) {
                Point point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                if (point.x <= n && n < point.x + floaterInfo.item.getWidth(this, floaterInfo.style)) {
                    return floaterInfo;
                }
            }
            ++n4;
        }
        return null;
    }

    protected int adjustDocHeightForFloaters(int n) {
        if (this.floaters == null || this.floaters.size() == 0) {
            return n;
        }
        int n2 = this.floaters.size();
        int n3 = 0;
        while (n3 < n2) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n3);
            if (floaterInfo.startY + floaterInfo.height > n) {
                n = floaterInfo.startY + floaterInfo.height;
            }
            ++n3;
        }
        return n;
    }

    protected int getFloatingIndentAt(int n, boolean bl) {
        if (this.floaters == null || this.floaters.size() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.floaters.size();
        while (--n3 >= 0) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n3);
            if (floaterInfo.invalid || floaterInfo.isLeft != bl || !floaterInfo.inRange(n)) continue;
            n2 += floaterInfo.item.getWidth(this, floaterInfo.style);
            n = floaterInfo.startY;
        }
        return n2;
    }

    public Point getFloaterOrigin(Formatter formatter, TagItem tagItem, boolean bl) {
        Point point = new Point(0, 0);
        if (formatter.floaters == null) {
            return point;
        }
        int n = formatter.floaters.size();
        FloaterInfo floaterInfo = null;
        int n2 = 0;
        while (n2 < n) {
            FloaterInfo floaterInfo2 = (FloaterInfo)formatter.floaters.elementAt(n2);
            if (floaterInfo2.item == tagItem) {
                floaterInfo = floaterInfo2;
                point.y = floaterInfo.startY;
                break;
            }
            ++n2;
        }
        int n3 = point.y;
        int n4 = 0;
        while (n2 >= 0) {
            FloaterInfo floaterInfo3 = (FloaterInfo)this.floaters.elementAt(n2);
            if (floaterInfo3.isLeft == bl && floaterInfo3.inRange(n3)) {
                n4 += floaterInfo3.item.getWidth(this, floaterInfo3.style);
                n3 = floaterInfo3.startY;
            }
            --n2;
        }
        if (bl) {
            n4 += floaterInfo.style.left;
            n4 -= floaterInfo.item.getWidth(this, floaterInfo.style);
        } else {
            n4 += floaterInfo.style.right;
            n4 = this.width - n4;
        }
        point.x = n4;
        return point;
    }

    public int getCumulativeFloaterHeight(int n) {
        int n2 = this.getCumulativeFloaterHeight(n, true);
        return Math.max(n2, this.getCumulativeFloaterHeight(n, false));
    }

    public int getCumulativeFloaterHeight(int n, boolean bl) {
        if (this.floaters == null) {
            return 0;
        }
        int n2 = this.floaters.size();
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n2) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n5);
            if (!floaterInfo.invalid && floaterInfo.isLeft == bl) {
                if (floaterInfo.startY < n3 && floaterInfo.startY + floaterInfo.height >= n4) {
                    n3 = Math.max(n3, floaterInfo.startY + floaterInfo.height);
                } else {
                    if (floaterInfo.startY > n) break;
                    n4 = floaterInfo.startY;
                    n3 = floaterInfo.startY + floaterInfo.height;
                }
                if (floaterInfo.inRange(n)) {
                    bl2 = true;
                }
            }
            ++n5;
        }
        if (bl2) {
            return n3 - n;
        }
        return 0;
    }

    public void queueFloater(Formatter formatter, FormatState formatState, TagItem tagItem, int n, boolean bl) {
        if (formatter.formatFloaterQueue == null) {
            formatter.formatFloaterQueue = new Vector();
        }
        FloaterInfo floaterInfo = new FloaterInfo();
        floaterInfo.item = tagItem;
        floaterInfo.style = formatState.style;
        floaterInfo.isLeft = bl;
        floaterInfo.height = n;
        floaterInfo.invalid = false;
        int n2 = tagItem.getIndex();
        if (formatState.width == 0) {
            boolean bl2 = this.insertQueuedFloater(floaterInfo, formatState.y + formatState.above);
            int n3 = tagItem.getWidth(this, formatState.style);
            if (bl2) {
                formatState.margin = bl ? (formatState.margin += n3 << 16) : (formatState.margin += n3);
                formatState.maxWidth -= n3;
                return;
            }
        } else {
            formatter.formatFloaterQueue.addElement(floaterInfo);
        }
    }

    protected void insertQueuedFloaters(FormatState formatState) {
        if (this.formatFloaterQueue != null) {
            Enumeration enumeration = this.formatFloaterQueue.elements();
            while (enumeration.hasMoreElements()) {
                this.insertQueuedFloater((FloaterInfo)enumeration.nextElement(), formatState.y + formatState.ascent + formatState.descent + formatState.above + formatState.below);
            }
        }
    }

    private boolean insertQueuedFloater(FloaterInfo floaterInfo, int n) {
        int n2;
        int n3;
        boolean bl = true;
        if (this.floaters == null) {
            this.floaters = new Vector();
        }
        floaterInfo.startY = n;
        int n4 = n + floaterInfo.height;
        int n5 = this.findY(n);
        if ((n3 = ++n5) < this.nlines && (n2 = this.findY(n4)) < this.nlines) {
            while (n3 <= n2) {
                this.lines[n3].updated = true;
                ++n3;
            }
            this.invalidateFloatersInRange(this.lines[n5].start, this.lines[n2].end);
            this.invalidateFloaterDocLines(n2 + 1, floaterInfo.item.index);
        }
        n2 = 0;
        int n6 = this.floaters.size();
        n3 = 0;
        while (n3 < n6) {
            FloaterInfo floaterInfo2 = (FloaterInfo)this.floaters.elementAt(n3);
            if (floaterInfo2.item == floaterInfo.item) {
                floaterInfo2.startY = n;
                floaterInfo2.height = floaterInfo.height;
                n2 = 1;
                bl = floaterInfo2.invalid;
                if (!floaterInfo2.invalid) break;
                floaterInfo2.invalid = false;
                break;
            }
            if (floaterInfo2.startY > n || floaterInfo2.startY == n && floaterInfo2.item.index > floaterInfo.item.index) {
                this.floaters.insertElementAt(floaterInfo, n3);
                n2 = 1;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            this.floaters.addElement(floaterInfo);
        }
        return bl;
    }

    protected void invalidateFloatersInRange(int n, int n2) {
        if (this.floaters != null) {
            int n3 = this.floaters.size();
            int n4 = 0;
            while (n4 < n3) {
                FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n4);
                int n5 = floaterInfo.item.index << 16;
                if (n5 >= n && n5 < n2) {
                    floaterInfo.invalid = true;
                } else if (n5 >= n2) {
                    return;
                }
                ++n4;
            }
        }
    }

    private void invalidateFloaterDocLines(int n, int n2) {
        if (this.floaters == null) {
            return;
        }
        int n3 = this.floaters.size();
        int n4 = n;
        while (n4 < this.nlines) {
            int n5 = 0;
            while (n5 < n3) {
                FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n5);
                if (n2 <= floaterInfo.item.index) {
                    if (floaterInfo.startY >= this.lines[n4].y && n4 + 1 < this.nlines && floaterInfo.startY < this.lines[n4 + 1].y) {
                        floaterInfo.invalid = true;
                        this.lines[n4].updated = true;
                    } else if (floaterInfo.startY > this.lines[n4].y) break;
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected void removeFloatersInRange(int n, int n2) {
        if (this.floaters != null) {
            int n3 = 0;
            while (n3 < this.floaters.size()) {
                FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n3);
                int n4 = floaterInfo.item.index << 16;
                if (n4 >= n && n4 < n2) {
                    this.floaters.removeElementAt(n3);
                    --n3;
                } else if (n4 >= n2) {
                    return;
                }
                ++n3;
            }
        }
    }

    protected void paintFloaters(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.floaters != null) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = new Rectangle();
            Enumeration enumeration = this.floaters.elements();
            while (enumeration.hasMoreElements()) {
                FloaterInfo floaterInfo = (FloaterInfo)enumeration.nextElement();
                rectangle2.y = floaterInfo.startY;
                rectangle2.height = floaterInfo.height;
                Point point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
                rectangle2.x = point.x;
                rectangle2.width = floaterInfo.item.getWidth(this, floaterInfo.style);
                if (!this.intersects(rectangle, rectangle2)) continue;
                this.paintAFloater(graphics, floaterInfo);
            }
        }
    }

    private boolean intersects(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x + rectangle2.width >= rectangle.x && rectangle2.y + rectangle2.height >= rectangle.y && rectangle2.x <= rectangle.x + rectangle.width && rectangle2.y <= rectangle.y + rectangle.height;
    }

    protected void paintFloatersInRange(Graphics graphics, int n, int n2) {
        if (this.floaters != null) {
            int n3 = n >> 16;
            int n4 = n2 >> 16;
            Enumeration enumeration = this.floaters.elements();
            while (enumeration.hasMoreElements()) {
                FloaterInfo floaterInfo = (FloaterInfo)enumeration.nextElement();
                if (n4 <= floaterInfo.item.index) {
                    return;
                }
                if (n3 > floaterInfo.item.index) continue;
                this.paintAFloater(graphics, floaterInfo);
            }
        }
    }

    protected void paintFloaters(Graphics graphics, int n, int n2) {
        if (n > n2) {
            return;
        }
        int n3 = this.findPos(n);
        DocLine docLine = this.lines[n3];
        int n4 = 0;
        int n5 = this.docHeight;
        if (docLine != null) {
            n4 = docLine.y;
        }
        if ((docLine = this.lines[n3 = this.findPos(n2)]) != null) {
            n5 = docLine.y + docLine.height;
        }
        this.paintFloaters(graphics, 0, n4, this.width, n5 - n4);
    }

    private void paintAFloater(Graphics graphics, FloaterInfo floaterInfo) {
        if (floaterInfo.invalid) {
            return;
        }
        Floatable floatable = (Floatable)((Object)floaterInfo.item);
        Point point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
        floatable.paint(this, graphics, point.x, point.y);
    }

    protected void printFloatersInYRange(Graphics graphics, int n, int n2) {
        if (this.floaters == null) {
            return;
        }
        Enumeration enumeration = this.floaters.elements();
        while (enumeration.hasMoreElements()) {
            FloaterInfo floaterInfo = (FloaterInfo)enumeration.nextElement();
            if (floaterInfo.startY + floaterInfo.height < n) continue;
            if (floaterInfo.startY > n2) break;
            Point point = this.getFloaterOrigin(this, floaterInfo.item, floaterInfo.isLeft);
            this.printAFloater(graphics, floaterInfo, point.x, floaterInfo.startY - n);
        }
    }

    protected int highestSplitFloaterY(int n) {
        int n2 = -1;
        if (this.floaters != null) {
            int n3 = 0;
            while (n3 < this.floaters.size()) {
                FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n3);
                if (floaterInfo.startY < n && floaterInfo.startY + floaterInfo.height > n && (n2 == -1 || n2 > floaterInfo.startY)) {
                    n2 = floaterInfo.startY;
                }
                ++n3;
            }
        }
        return n2;
    }

    private void printAFloater(Graphics graphics, FloaterInfo floaterInfo, int n, int n2) {
        Floatable floatable = (Floatable)((Object)floaterInfo.item);
        floatable.print(this, graphics, n, n2);
    }

    protected int getFloatersStartY(int n) {
        int n2 = 0;
        if (this.floaters == null || this.floaters.size() == 0) {
            return n;
        }
        int n3 = this.floaters.size();
        while (--n3 >= 0) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n3);
            if (floaterInfo.invalid || !floaterInfo.inRange(n) || n2 >= floaterInfo.startY) continue;
            n2 = floaterInfo.startY;
        }
        if (n2 == 0) {
            return n;
        }
        return n2;
    }

    protected void updateFloatersYInRange(int n, int n2, int n3) {
        if (this.floaters != null) {
            int n4 = this.floaters.size();
            int n5 = 0;
            while (n5 < n4) {
                FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n5);
                int n6 = floaterInfo.item.index << 16;
                if (n6 >= n && n6 < n2) {
                    floaterInfo.startY += n3;
                } else if (n6 >= n2) {
                    return;
                }
                ++n5;
            }
        }
    }

    protected void dirtyFloaterLines(FormatState formatState, int n, int n2) {
        Range range = new Range(Integer.MAX_VALUE, 0);
        this.getFloaterYRange(formatState, this.floaters, n, n2, range);
        int n3 = this.findY(range.minVal);
        while (this.lines[n3] != null && this.lines[n3].y < range.maxVal) {
            this.lines[n3].updated = true;
            this.invalidateFloatersInRange(this.lines[n3].start, this.lines[n3].end);
            ++n3;
        }
    }

    private void getFloaterYRange(FormatState formatState, Vector vector, int n, int n2, Range range) {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FloaterInfo floaterInfo = (FloaterInfo)enumeration.nextElement();
            TagItem tagItem = floaterInfo.item;
            int n3 = tagItem.index << 16;
            if (n3 >= n2) {
                return;
            }
            if (n3 < n) continue;
            floaterInfo.height = tagItem.getAscent(this, formatState) + tagItem.getDescent(this, formatState);
            range.minVal = Math.min(floaterInfo.startY, range.minVal);
            range.maxVal = Math.max(floaterInfo.startY + floaterInfo.height, range.maxVal);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void repaintAffectedFloaters(int n, int n2) {
        if (this.floaters == null) {
            return;
        }
        int n3 = this.floaters.size();
        int n4 = 0;
        while (n4 < n3) {
            FloaterInfo floaterInfo = (FloaterInfo)this.floaters.elementAt(n4);
            if (!floaterInfo.invalid) {
                int n5 = floaterInfo.item.index << 16;
                if (n5 >= n2) {
                    return;
                }
                if (n5 >= n) {
                    int n6 = floaterInfo.startY;
                    int n7 = floaterInfo.startY + floaterInfo.height;
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        Object var11_10;
                        try {
                            int n8 = n4;
                            while (n8 < n3) {
                                FloaterInfo floaterInfo2 = (FloaterInfo)this.floaters.elementAt(n8);
                                if (floaterInfo2.isLeft == floaterInfo.isLeft) {
                                    if (n7 < floaterInfo2.startY || n6 > floaterInfo2.startY + floaterInfo2.height) break;
                                    this.paintAFloater(graphics, floaterInfo2);
                                    n6 = Math.min(n6, floaterInfo2.startY);
                                    n7 = Math.max(n7, floaterInfo2.startY + floaterInfo2.height);
                                }
                                ++n8;
                            }
                        }
                        catch (Throwable throwable) {
                            var11_10 = null;
                            graphics.dispose();
                            throw throwable;
                        }
                        var11_10 = null;
                        graphics.dispose();
                    }
                }
            }
            ++n4;
        }
        return;
    }

    public void claimResponsibilityFor(DocPanel docPanel, int n, int n2) {
        if (this.respVec == null) {
            this.respVec = new Vector();
        }
        Responsibility responsibility = new Responsibility(docPanel, n, n2);
        int n3 = this.respVec.size();
        int n4 = 0;
        while (n4 < n3) {
            Responsibility responsibility2 = (Responsibility)this.respVec.elementAt(n4);
            if (responsibility2.startIndex > n2) {
                this.respVec.insertElementAt(responsibility, n4);
                return;
            }
            ++n4;
        }
        this.respVec.addElement(responsibility);
    }

    public void disclaimResponsibilityFor(DocPanel docPanel, int n, int n2) {
        if (this.respVec == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.respVec.size()) {
            Responsibility responsibility = (Responsibility)this.respVec.elementAt(n3);
            if (responsibility.startIndex >= n && responsibility.endIndex <= n2) {
                this.respVec.removeElementAt(n3);
                --n3;
            }
            ++n3;
        }
    }

    protected void notifyResponsiblesInRange(Document document, int n, int n2, int n3) {
        Enumeration enumeration = this.subsequentResponsiblesFrom(n2);
        while (enumeration.hasMoreElements()) {
            Responsibility responsibility = (Responsibility)enumeration.nextElement();
            DocPanel docPanel = responsibility.getTarget();
            docPanel.notify(document, n, n2, n3);
        }
    }

    protected Responsibility findResponsibility(int n) {
        if (this.respVec == null) {
            return null;
        }
        int n2 = this.getResponsibilityIndex(n);
        if (n2 < this.respVec.size()) {
            return (Responsibility)this.respVec.elementAt(n2);
        }
        return null;
    }

    private int getResponsibilityIndex(int n) {
        if (this.respVec == null) {
            return 0;
        }
        int n2 = this.respVec.size();
        int n3 = n >> 16;
        int n4 = 0;
        n4 = 0;
        while (n4 < n2) {
            Responsibility responsibility = (Responsibility)this.respVec.elementAt(n4);
            if (responsibility.startIndex <= n3 && n3 < responsibility.endIndex) break;
            ++n4;
        }
        return n4;
    }

    private Enumeration enumerateResponsiblesInRange(int n, int n2) {
        if (this.respVec == null) {
            return new ResponsibilityRangeEnumeration(this, 0, -1);
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = this.respVec.size();
        int n6 = n >> 16;
        int n7 = n2 >> 16;
        int n8 = 0;
        n8 = 0;
        while (n8 < n5) {
            Responsibility responsibility = (Responsibility)this.respVec.elementAt(n8);
            if (responsibility.startIndex <= n7 && responsibility.endIndex >= n6) {
                if (n3 < 0) {
                    n3 = n8;
                }
                n4 = n8;
            } else if (responsibility.startIndex > n7) break;
            ++n8;
        }
        return new ResponsibilityRangeEnumeration(this, n3, n4);
    }

    private Enumeration subsequentResponsiblesFrom(int n) {
        int n2 = this.getResponsibilityIndex(n);
        return new ResponsibilityEnumeration(this, n2);
    }

    int countResponsiblities() {
        if (this.respVec == null) {
            return 0;
        }
        return this.respVec.size();
    }

    Responsibility responsibilityAt(int n) {
        if (this.respVec == null) {
            return null;
        }
        return (Responsibility)this.respVec.elementAt(n);
    }

    protected void reformatResponsibles() {
        if (this.respVec == null) {
            return;
        }
        int n = this.respVec.size();
        int n2 = 0;
        while (n2 < n) {
            Responsibility responsibility = (Responsibility)this.respVec.elementAt(n2);
            DocPanel docPanel = responsibility.getTarget();
            docPanel.reformat();
            ++n2;
        }
    }

    public Vector getChildFormatters() {
        if (this.respVec == null) {
            return null;
        }
        Vector vector = new Vector();
        int n = this.respVec.size();
        int n2 = 0;
        while (n2 < n) {
            Responsibility responsibility = (Responsibility)this.respVec.elementAt(n2);
            DocPanel docPanel = responsibility.getTarget();
            if (docPanel instanceof TablePanel) {
                ((TablePanel)docPanel).addTablePanelFormatters(vector);
            }
            ++n2;
        }
        return vector;
    }

    public void clearParentBackground() {
        Container container = this.getParent();
        if (container != null) {
            Graphics graphics = container.getGraphics();
            Dimension dimension = container.getSize();
            if (graphics != null) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.dispose();
            }
        }
    }

    public abstract void activateSubItems();

    public abstract void notify(Document var1, int var2, int var3, int var4);

    public abstract boolean imageUpdate(Image var1, int var2, int var3, int var4, int var5, int var6);

    protected class FormatterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseExited(MouseEvent mouseEvent) {
            Formatter.this.processMouseAction(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Formatter.this.processMouseAction(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Formatter.this.processMouseAction(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Formatter.this.processMouseAction(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Formatter.this.processMouseAction(mouseEvent);
        }

        protected FormatterMouseListener() {
            Formatter.this = Formatter.this;
        }
    }
}

