/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TraversalState;
import sunw.hotjava.tables.TablePanel;
import sunw.hotjava.tags.Align;

public class TABLE
extends TagItem
implements Floatable {
    private int fmt = 2;
    private int align;
    private boolean surroundedByForm = false;
    private int formsToEnd = 0;

    public void init(Document document) {
        if (this.atts != null) {
            this.fmt = Align.getFormat(this.atts, "align", 2);
        }
        this.align = Align.getAlign(this.atts);
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state != 0) {
            formatState.below = Math.max(formatState.above, this.style.above);
            return true;
        }
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            tablePanel.format();
            if (this.alignIsFloating()) {
                boolean bl = false;
                if (!formatter.isFloater(this) && formatState.width + this.getWidth(formatter, formatState.style) > formatState.maxWidth) {
                    if (formatter.floatersInYRange(formatState.y)) {
                        formatState.below += formatter.getCumulativeFloaterHeight(formatState.y);
                        return true;
                    }
                    bl = true;
                }
                formatter.queueFloater(formatter, formatState, this, this.getAscent(formatter, formatState) + this.getDescent(formatter, formatState), this.align == 7);
                formatState.pos += this.getOffset() << 16;
                return bl;
            }
        }
        formatState.style = formatState.style.push(this);
        formatState.above = Math.max(formatState.above, 0);
        formatState.below = Math.max(0, formatState.below);
        formatState.state = 1;
        formatState.pos += this.getOffset() << 16;
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            formatState.ascent = dimension.height;
            formatState.width += dimension.width;
            formatState.descent = 0;
            if (this.fmt != 2) {
                formatState.format = this.fmt;
            }
        }
        return false;
    }

    public boolean formatEndTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (this.alignIsFloating()) {
            formatState.pos += 65536;
            return false;
        }
        if (formatState.state != 0) {
            return true;
        }
        formatState.above = Math.max(formatState.below, this.style.below);
        formatState.pos += 65536;
        formatState.style = formatState.style.next;
        formatState.state = 2;
        return false;
    }

    protected int getActivateIncrement() {
        return this.getOffset();
    }

    public int getWidth(Formatter formatter, DocStyle docStyle) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            return dimension.width;
        }
        return 0;
    }

    public int getAscent(Formatter formatter, FormatState formatState) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            return Align.getAscent(formatState, this.align, dimension.height);
        }
        return 0;
    }

    public int getDescent(Formatter formatter, FormatState formatState) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            return Align.getDescent(formatState, this.align, dimension.height);
        }
        return 0;
    }

    private boolean alignIsFloating() {
        return this.align == 7 || this.align == 8;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, boolean bl) {
        if (this.alignIsFloating()) {
            formatter.displayPos += this.getOffset() << 16;
            return 0;
        }
        return this.paintTable(formatter, graphics, n, n2, docLine, bl);
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2) {
        return this.paintTable(formatter, graphics, n, n2, null, false);
    }

    private int paintTable(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, boolean bl) {
        formatter.displayPos += this.getOffset() + 1 << 16;
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            if (docLine != null) {
                tablePanel.setLocation(n, n2 + docLine.getAbove());
            } else {
                tablePanel.setLocation(n, n2);
            }
            if (!tablePanel.isVisible()) {
                tablePanel.setVisible(true);
            } else if (!bl) {
                TablePanel.paintWithClipping(graphics, tablePanel);
            }
        }
        return 0;
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, PrintedLineInfo printedLineInfo) {
        formatter.displayPos += this.getOffset() + 1 << 16;
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            tablePanel.validate();
            Graphics graphics2 = graphics.create(n, n2, dimension.width, dimension.height);
            try {
                tablePanel.print(graphics2, n2, printedLineInfo);
            }
            finally {
                Object var11_10 = null;
                graphics2.dispose();
            }
        }
        return 0;
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        if (tablePanel != null) {
            Dimension dimension = tablePanel.getSize();
            tablePanel.validate();
            Graphics graphics2 = graphics.create(n, n2, dimension.width, dimension.height);
            try {
                tablePanel.print(graphics2, n2, new PrintedLineInfo());
            }
            finally {
                Object var9_8 = null;
                graphics2.dispose();
            }
        }
        return 0;
    }

    public boolean doesOverflow(TraversalState traversalState, Formatter formatter, DocLine docLine, int n, Dimension dimension) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        traversalState.pos += this.getOffset() + 1 << 16;
        if (tablePanel != null) {
            return tablePanel.doesOverflow(formatter, docLine, n, dimension);
        }
        return true;
    }

    public boolean needsActivation() {
        return true;
    }

    public boolean measureStartTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        TablePanel tablePanel = (TablePanel)formatter.getPanel(this);
        Measurement measurement2 = new Measurement();
        measureState.style = measureState.style.push(this);
        if (tablePanel != null) {
            tablePanel.measureWidth(measurement2, measureState);
        } else {
            measurement.reset();
            measureState.measurementInvalid = true;
        }
        measureState.pos += this.getOffset() << 16;
        if (this.alignIsFloating()) {
            measurement.setFloaterMinWidth(measurement2.getMinWidth());
            measurement.setFloaterPreferredWidth(measurement2.getPreferredWidth());
            return false;
        }
        measurement.setMinWidth(measurement2.getMinWidth());
        measurement.setPreferredWidth(measurement2.getPreferredWidth());
        return true;
    }

    public boolean measureEndTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        measureState.pos += 65536;
        if (this.alignIsFloating()) {
            return false;
        }
        measureState.style = measureState.style.next;
        return true;
    }

    public int getFormPanel(Formatter formatter, Vector vector) {
        TablePanel tablePanel;
        while ((tablePanel = (TablePanel)formatter.getPanel(this)) == null && (formatter = formatter.getParentFormatter()) != null) {
        }
        if (tablePanel != null) {
            tablePanel.getFormPanel(vector);
        }
        return this.getOffset() + 1;
    }

    public Component createView(Formatter formatter, Document document) {
        TablePanel tablePanel = new TablePanel(formatter, this, document);
        return tablePanel;
    }

    public void setSurroundedTableByForm(boolean bl) {
        this.surroundedByForm = bl;
    }

    public boolean getSurroundedTableByForm() {
        return this.surroundedByForm;
    }

    public void incrementFormsToEnd() {
        ++this.formsToEnd;
    }

    public int getFormsToEnd() {
        return this.formsToEnd;
    }
}

