/*
 * Decompiled with CFR 0.152.
 */
package sunw.html.build;

import java.io.CharArrayReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.Entity;
import sunw.html.build.DTDBuilder;

public final class DTDInputStream
extends FilterReader
implements DTDConstants {
    public DTD dtd;
    public Stack stack = new Stack();
    public char[] str = new char[64];
    public int replace;
    public int ln = 1;
    public int ch;

    public DTDInputStream(InputStream inputStream, DTD dTD) throws IOException {
        super(new InputStreamReader(inputStream));
        this.dtd = dTD;
        this.ch = inputStream.read();
    }

    public void error(String string) {
        System.out.println("line " + this.ln + ": dtd input error: " + string);
    }

    public void push(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.push(new CharArrayReader(cArray));
    }

    public void push(char[] cArray) throws IOException {
        if (cArray.length > 0) {
            this.push(new CharArrayReader(cArray));
        }
    }

    void push(Reader reader) throws IOException {
        this.stack.push(new Integer(this.ln));
        this.stack.push(new Integer(this.ch));
        this.stack.push(this.in);
        this.in = reader;
        this.ch = reader.read();
    }

    public int read() throws IOException {
        switch (this.ch) {
            case 37: {
                this.ch = this.in.read();
                if (this.replace > 0) {
                    return 37;
                }
                int n = 0;
                while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch >= 48 && this.ch <= 57 || this.ch == 46 || this.ch == 45) {
                    this.str[n++] = (char)this.ch;
                    this.ch = this.in.read();
                }
                if (n == 0) {
                    return 37;
                }
                String string = new String(this.str, 0, n);
                Entity entity = this.dtd.getEntity(string);
                if (entity == null) {
                    this.error("undefined entity reference: " + string);
                    return this.read();
                }
                switch (this.ch) {
                    case 13: {
                        ++this.ln;
                    }
                    case 59: {
                        this.ch = this.in.read();
                        break;
                    }
                    case 10: {
                        ++this.ln;
                        this.ch = this.in.read();
                        if (this.ch != 13) break;
                        this.ch = this.in.read();
                        break;
                    }
                }
                try {
                    this.push(this.getEntityInputReader(entity));
                }
                catch (Exception exception) {
                    this.error("entity data not found: " + entity + ", " + entity.getString());
                }
                return this.read();
            }
            case 10: {
                ++this.ln;
                this.ch = this.in.read();
                if (this.ch == 13) {
                    this.ch = this.in.read();
                }
                return 10;
            }
            case 13: {
                ++this.ln;
                this.ch = this.in.read();
                return 10;
            }
            case -1: {
                if (this.stack.size() > 0) {
                    this.in = (Reader)this.stack.pop();
                    this.ch = (Integer)this.stack.pop();
                    this.ln = (Integer)this.stack.pop();
                    return this.read();
                }
                return -1;
            }
        }
        int n = this.ch;
        this.ch = this.in.read();
        return n;
    }

    private Reader getEntityInputReader(Entity entity) throws IOException {
        if ((entity.type & 0xA) != 0) {
            InputStream inputStream = DTDBuilder.mapping.get(entity.getString()).openStream();
            return new InputStreamReader(inputStream);
        }
        if ((entity.type & 0x11) != 0) {
            InputStream inputStream = new URL(DTDBuilder.mapping.base, entity.getString()).openStream();
            return new InputStreamReader(inputStream);
        }
        return new CharArrayReader(entity.data);
    }
}

