/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_esp.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_esp.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Added definitions for new ESP transforms.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * Minor Cleanup.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

struct esp
{
	__u32	esp_spi;		/* Security Parameters Index */
	__u8	esp_iv[8];		/* iv[4] may actually be data! */
};


extern struct inet_protocol esp_protocol;


struct espdes_xdata
{
	int	edx_ivlen;		/* 4 or 8 */
	union
	{
		__u8	Iv[8];		/* that's enough space */
		__u32	Ivl[2];
		__u64	Ivq;
	}Iu;
#define edx_iv	Iu.Iv
#define edx_ivl Iu.Ivl
#define edx_ivq Iu.Ivq
	union
	{
		__u8 Rk[8];
		__u32 Eks[16][2];
	}Xu;
#define edx_rk	Xu.Rk
#define edx_eks	Xu.Eks
};

#define EMT_ESPDESCBC_ULEN	20	/* coming from user mode */
#define EMT_ESPDES_KMAX		64	/* 512 bit secret key enough? */

#include "ipsec_md5h.h"

struct espblkrply_edata
{
	__u16	eme_klen;		/* key length */
	__u8	eme_flags;		/* see below */
	__u8	eme_ooowin;		/* out-of-order window size */
	union
	{
		__u8	Iv[8];		/* that's enough space */
		__u32	Ivl[2];
		__u64	Ivq;
	}Iu;
#define eme_iv	Iu.Iv
#define eme_ivl Iu.Ivl
#define eme_ivq Iu.Ivq
	__u8	eme_key[EMT_ESPDES_KMAX]; /* the actual raw key */
};

struct espdesmd5_xdata
{
	__u8	edmx_flags;		/* same as before */
	__u8	edmx_ooowin;		/* out-of-order window size */
	__u16	edmx_x0;		/* stuffing */
	__u32	edmx_bitmap;		/* this&next should be 4 bytes each */
	__u32	edmx_lastseq;		/* in host order */
	__u32	edmx_eks[16][2];	/* the key schedule */
	__u32	edmx_iv[2];		/* constant IV */
	MD5_CTX edmx_ictx;		/* derived from HMAC_key */
	MD5_CTX edmx_octx;		/* ditto */
};

struct esp3desmd5_xdata
{
	__u8	edmx_flags;		/* same as before */
	__u8	edmx_ooowin;		/* out-of-order window size */
	__u16	edmx_x0;		/* stuffing */
	__u32	edmx_bitmap;		/* this&next should be 4 bytes each */
	__u32	edmx_lastseq;		/* in host order */
	__u32	edmx_eks1[16][2];	/* the first key schedule */
	__u32	edmx_eks2[16][2];	/* the second key schedule */
	__u32	edmx_eks3[16][2];	/* the third key schedule */
	__u32	edmx_iv[2];		/* constant IV */
	MD5_CTX edmx_ictx;		/* derived from HMAC_key */
	MD5_CTX edmx_octx;		/* ditto */
};


#define EME_CONSTIV	0x01		/* IV derived from key */
#define	EME_INITIATOR	0x02		/* we are the initiator */
	
#ifdef DEBUG_IPSEC_ESP

extern int debug_esp;

#define DB_ES_PKTRX	0x0001
#define DB_ES_PKTRX2	0x0002
#define DB_ES_TDB	0x0010
#define DB_ES_XF	0x0020
#define DB_ES_IPAD	0x0040
#define DB_ES_OINFO	0x0100
#define DB_ES_OINFO2	0x0200
#define DB_ES_OH	0x0400
#endif
