/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHParameterGenerator;
import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger y;
    private BigInteger x;
    private BigInteger p;
    private BigInteger g;
    private int pSize = 1024;
    private int l;
    private SecureRandom random;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        if (this.l == 0) {
            this.l = this.pSize - 1;
        }
        try {
            Object object;
            Object object2;
            if (this.p == null || this.g == null) {
                object2 = new DHGenParameterSpec(this.pSize, this.l);
                DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
                dHParameterGenerator.engineInit((AlgorithmParameterSpec)object2, null);
                AlgorithmParameters algorithmParameters = dHParameterGenerator.engineGenerateParameters();
                object = (DHParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : (class$javax$crypto$spec$DHParameterSpec = DHKeyPairGenerator.class$("javax.crypto.spec.DHParameterSpec")));
                this.p = ((DHParameterSpec)object).getP();
                this.g = ((DHParameterSpec)object).getG();
            }
            this.x = new BigInteger(this.l, this.random);
            this.y = this.g.modPow(this.x, this.p);
            object2 = new DHPublicKey(this.y, this.p, this.g, this.l);
            object = new DHPrivateKey(this.x, this.p, this.g, this.l);
            keyPair = new KeyPair((PublicKey)object2, (PrivateKey)object);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        return keyPair;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.pSize = n;
        this.l = 0;
        this.random = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.p = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.pSize = this.p.bitLength();
        if (this.pSize < 512 || this.pSize > 1024 || this.pSize % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Prime size must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.g = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.l = ((DHParameterSpec)algorithmParameterSpec).getL();
        this.random = secureRandom;
        if (this.l != 0 && this.l >= this.pSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }
}

