/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AlgorithmId;
import com.sun.crypto.provider.DerValue;
import java.io.IOException;
import java.math.BigInteger;

class PrivateKeyInfo {
    private static final BigInteger VERSION = BigInteger.valueOf(0L);
    private AlgorithmId algid;
    private byte[] privkey;

    public PrivateKeyInfo(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("private key parse error: not a sequence");
        }
        BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
        if (!bigInteger.equals(VERSION)) {
            throw new IOException("version mismatch: (supported: " + VERSION + ", parsed: " + bigInteger);
        }
        this.algid = new AlgorithmId(derValue.data.getDerValue());
        this.privkey = derValue.data.getOctetString();
    }

    public AlgorithmId getAlgorithm() {
        return this.algid;
    }
}

