/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.BigInt;
import com.sun.crypto.provider.DerInputStream;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.DerValue;
import com.sun.crypto.provider.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue(byteArrayInputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + bigInteger);
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.tag == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (derValue3.tag != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            derValue3.data.reset();
            this.p = derValue3.data.getInteger().toBigInteger();
            this.g = derValue3.data.getInteger().toBigInteger();
            if (derValue3.data.available() != 0) {
                this.l = derValue3.data.getInteger().toInt();
            }
            if (derValue3.data.available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derValue.data.getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PrivateKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public String getAlgorithm() {
        return "DH";
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(new BigInt(PKCS8_VERSION.toByteArray()));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(new BigInt(this.p.toByteArray()));
                derOutputStream3.putInteger(new BigInt(this.g.toByteArray()));
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g);
    }

    public BigInteger getX() {
        return this.x;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getEncoded();
        int n2 = 1;
        while (n2 < byArray.length) {
            n += byArray[n2] * n2;
            ++n2;
        }
        return n;
    }

    private void parseKeyBits() throws InvalidKeyException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger().toBigInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String toString() {
        return "Sun DH Private Key \nparameters:\nx: " + new BigInt(this.x).toString() + "\n";
    }
}

