/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.JceSecurity;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private Provider provider;
    private SecretKeyFactorySpi keyFacSpi;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider) {
        this.keyFacSpi = secretKeyFactorySpi;
        this.provider = provider;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGenerateSecret(keySpec);
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = JceSecurity.getImpl(string, "SecretKeyFactory", null);
            return new SecretKeyFactory((SecretKeyFactorySpi)objectArray[0], (Provider)objectArray[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = JceSecurity.getImpl(string, "SecretKeyFactory", string2);
        return new SecretKeyFactory((SecretKeyFactorySpi)objectArray[0], (Provider)objectArray[1]);
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(secretKey, clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(secretKey);
    }
}

