/*
**	ssh_mp_int.h	-- handles multiple precision integers
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**	See the LICENSE file.
*/

#ifndef __SSH_MP_INT_H
#define __SSH_MP_INT_H

/*
**	Include Eric Young's SSLeay include files :)
*/
#include <stdio.h>
#include <rsa.h>
#include <bn.h>

/*
**	Now lets include the stuff we need to do network byte ordering
**	and Posix-ish types
*/
#include "ssh_types.h"

/*
**	Multiple precision integer type
*/
typedef struct
{
	uint16_t nbits;			/* number of bits */
	uint8_t * num;			/* actual number (bytes) */

	uint16_t data_bytes;		/* num's of bytes (from bits) */
} MP_Int;

#ifdef __cplusplus
extern "C" {
#endif

/*
**	Take an MP_Int (already allocated), and mark as unused
*/
int mp_int_new(MP_Int * number);

/*
**	Functions to pack and unpack an MP_Int from a stream
*/
int mp_int_to_stream(uint8_t * stream, MP_Int number, int stream_size);
int mp_int_from_stream(uint8_t * stream, MP_Int * number);

/*
**	Create an RSA key with MP_Ints as the modulus and exponent
*/
int make_rsakey(MP_Int mod, MP_Int exp, RSA * key);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_MP_INT_H */


